/*
This file is part of CrocoLib.

CrocoLib is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

CrocoLib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crASIC.h"

#include <string.h> // memcpy

// ----------------------------------------------------------------------------
void __LIB__ crASICSetSpriteData( unsigned int spriteIndex, unsigned int source )
{	
	int x;
	int y;
	int pixel;
	
	unsigned int adr = 0x4000 + ( spriteIndex * 256 );

	for ( y = 0; y < 16; y++ )
	{
		crASICBegin( );

		for ( x = 0; x < 16 / 2; x++ )
		{
			pixel = *( (unsigned char *) source );
			source++;

			*( (unsigned char *) adr ) = ( pixel >> 7 ) + ( ( pixel & 32 ) >> 3 ) + ( ( pixel & 0x08 ) >> 2 ) + ( ( pixel & 0x02 ) << 2 );
			adr++;

			*( (unsigned char *) adr ) = ( ( pixel & 0x40 ) >> 6 ) + ( ( pixel & 0x10 ) >> 2 ) + ( ( pixel & 0x04 ) >> 1 ) + ( ( pixel & 0x01 ) << 3 );
			adr++;
		}

		crASICEnd( );
	}
}
