@echo off

echo Compiling framework..
cd ..\Sources\CrocoLib
..\..\ThirdParty\mingw32-make\mingw32-make.exe -f ..\..\Build\Makefile 2> build_err.log > build.log
z80asm -d -ns -nm -Mo -xCrocoLib @..\..\Build\crLib.lst > nul
find /c "Error" build_err.log > nul
if %ERRORLEVEL% NEQ 0 goto :libOK
type build_err.log
echo.
goto :libCompileAborted
:libOK
move /Y CrocoLib.lib "C:\Program Files\z88dk\lib\clibs" > nul
cd ..\..\Build

echo Compiling "Loading" part..
if not exist ..\Output\LOADING.DAT goto :createLoading
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createLoading
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Loading.c modified after ..\Output\LOADING.DAT
if %ERRORLEVEL% NEQ 0 goto :endLoading
:createLoading
cd ..\Sources\Demo\Data\Loading
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist LOADING.SCR.NOHEADER delAmsHeader.exe LOADING.SCR LOADING.SCR.NOHEADER > nul
if not exist LOADING.PAL.NOHEADER delAmsHeader.exe LOADING.PAL LOADING.PAL.NOHEADER > nul
if not exist LOADING.SCR.NOHEADER.PCK pack.exe LOADING.SCR.NOHEADER
if not exist PT3MUSIC.BIN.PCK pack PT3MUSIC.BIN
if not exist DMALIB.BIN.PCK pack DMALIB.BIN
DataLinker.exe -c DATA.CFG -o ..\..\Loading.h > nul
zcc +cpc -zorg=2272 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loading.c -create-app -o LOADING.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Loading.cpc > nul
move /Y LOADING.Z80 ..\..\..\..\Output
ren LOADING LOADING.DAT > nul
move /Y LOADING.DAT ..\..\..\..\Output
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoading

echo Compiling "Nuages" part..
if not exist ..\Output\NUAGES.DAT goto :createNuages
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createNuages
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Nuages.c modified after ..\Output\NUAGES.DAT
if %ERRORLEVEL% NEQ 0 goto :endNuages
:createNuages
cd ..\Sources\Demo\Data\Nuages
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist ALONE.PAL.NOHEADER delAmsHeader.exe ALONE.PAL ALONE.PAL.NOHEADER > nul
if not exist SKULL.SCR.NOHEADER delAmsHeader.exe SKULL.SCR SKULL.SCR.NOHEADER > nul
if not exist SKULL.PAL.NOHEADER delAmsHeader.exe SKULL.PAL SKULL.PAL.NOHEADER > nul
if not exist SKULL.SCR.NOHEADER.PCK pack.exe SKULL.SCR.NOHEADER
if not exist NUAGES_30X34.BIN.PCK pack.exe NUAGES_30X34.BIN
if not exist NUAGES_30X34_2.BIN.PCK pack.exe NUAGES_30X34_2.BIN
DataLinker.exe -c DATA.CFG -o ..\..\Nuages.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Nuages.c -create-app -o NUAGES.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Nuages.cpc > nul
pack.exe NUAGES.Z80
ren NUAGES NUAGES.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Nuages_Link.h > nul
move /Y NUAGES ..\..\..\..\Output\NUAGES.DAT
del NUAGES.DAT > nul
del NUAGES.Z80 > nul
del NUAGES.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endNuages

echo Compiling "Solar" part..
if not exist ..\Output\SOLAR.DAT goto :createSolar
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createSolar
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Solar.c modified after ..\Output\SOLAR.DAT
if %ERRORLEVEL% NEQ 0 goto :endSolar
:createSolar
cd ..\Sources\Demo\Data\Solar
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist SOLAR.SCR.NOHEADER delAmsHeader.exe SOLAR.SCR SOLAR.SCR.NOHEADER > nul
if not exist SOLAR.SCR.NOHEADER.PCK pack.exe SOLAR.SCR.NOHEADER
if not exist SOLAR2.SCR.NOHEADER delAmsHeader.exe SOLAR2.SCR SOLAR2.SCR.NOHEADER > nul
if not exist SOLAR2.SCR.NOHEADER.PCK pack.exe SOLAR2.SCR.NOHEADER
if not exist SOLAR3.SCR.NOHEADER delAmsHeader.exe SOLAR3.SCR SOLAR3.SCR.NOHEADER > nul
if not exist SOLAR3.SCR.NOHEADER.PCK pack.exe SOLAR3.SCR.NOHEADER
DataLinker.exe -c DATA.CFG -o ..\..\Solar.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Solar.c -create-app -o SOLAR.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Solar.cpc > nul
pack.exe SOLAR.Z80
ren SOLAR SOLAR.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Solar_Link.h > nul
move /Y SOLAR ..\..\..\..\Output\SOLAR.DAT
del SOLAR.DAT > nul
del SOLAR.Z80 > nul
del SOLAR.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endSolar

echo Compiling "Tunnel" part..
if not exist ..\Output\TUNNEL.DAT goto :createTunnel
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createTunnel
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Tunnel.c modified after ..\Output\TUNNEL.DAT
if %ERRORLEVEL% NEQ 0 goto :endTunnel
:createTunnel
cd ..\Sources\Demo\Data\Tunnel
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
rem if not exist SOLAR3.SCR.NOHEADER delAmsHeader.exe SOLAR3.SCR SOLAR3.SCR.NOHEADER > nul
rem if not exist SOLAR3.SCR.NOHEADER.PCK pack.exe SOLAR3.SCR.NOHEADER
DataLinker.exe -c DATA.CFG -o ..\..\Tunnel.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Tunnel.c -create-app -o TUNNEL.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Tunnel.cpc > nul
pack.exe TUNNEL.Z80
ren TUNNEL TUNNEL.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Tunnel_Link.h > nul
move /Y TUNNEL ..\..\..\..\Output\TUNNEL.DAT
del TUNNEL.DAT > nul
del TUNNEL.Z80 > nul
del TUNNEL.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endTunnel

echo Compiling "PreBozo" part..
if not exist ..\Output\PREBOZO.DAT goto :createPreBozo
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createPreBozo
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\PreBozo.c modified after ..\Output\PREBOZO.DAT
if %ERRORLEVEL% NEQ 0 goto :endPreBozo
:createPreBozo
cd ..\Sources\Demo\Data\PreBozo
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist TIME.SCR.NOHEADER delAmsHeader.exe TIME.SCR TIME.SCR.NOHEADER > nul
if not exist TIME.SCR.NOHEADER.PCK pack.exe TIME.SCR.NOHEADER
if not exist FOR.SCR.NOHEADER delAmsHeader.exe FOR.SCR FOR.SCR.NOHEADER > nul
if not exist FOR.SCR.NOHEADER.PCK pack.exe FOR.SCR.NOHEADER
if not exist MOCAP.SCR.NOHEADER delAmsHeader.exe MOCAP.SCR MOCAP.SCR.NOHEADER > nul
if not exist MOCAP.SCR.NOHEADER.PCK pack.exe MOCAP.SCR.NOHEADER
DataLinker.exe -c DATA.CFG -o ..\..\PreBozo.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\PreBozo.c -create-app -o PREBOZO.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del PreBozo.cpc > nul
pack.exe PREBOZO.Z80
ren PREBOZO PREBOZO.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\PreBozo_Link.h > nul
move /Y PREBOZO ..\..\..\..\Output\PREBOZO.DAT
del PREBOZO.DAT > nul
del PREBOZO.Z80 > nul
del PREBOZO.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endPreBozo

echo Compiling "Bozo" part..
if not exist ..\Output\BOZO.DAT goto :createBozo
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createBozo
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Bozo.c modified after ..\Output\BOZO.DAT
if %ERRORLEVEL% NEQ 0 goto :endBozo
:createBozo
cd ..\Sources\Demo\Data\Bozo
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c DATA.CFG -o ..\..\Bozo.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Bozo.c -create-app -o BOZO.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Bozo.cpc > nul
pack.exe BOZO.Z80
ren BOZO BOZO.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Bozo_Link.h > nul
move /Y BOZO ..\..\..\..\Output\BOZO.DAT
del BOZO.DAT > nul
del BOZO.Z80 > nul
del BOZO.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endBozo

echo Compiling "Interference" part..
if not exist ..\Output\INTER.DAT goto :createInter
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createInter
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Interference.c modified after ..\Output\INTER.DAT
if %ERRORLEVEL% NEQ 0 goto :endInter
:createInter
cd ..\Sources\Demo\Data\Interference
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist INTER.RAW.PCK pack.exe INTER.RAW
DataLinker.exe -c DATA.CFG -o ..\..\Interference.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Interference.c -create-app -o INTER.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Inter.cpc > nul
pack.exe INTER.Z80
ren INTER INTER.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Interference_Link.h > nul
move /Y INTER ..\..\..\..\Output\INTER.DAT
del INTER.DAT > nul
del INTER.Z80 > nul
del INTER.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endInter

echo Compiling "RotoZoom" part..
if not exist ..\Output\ROTOZOOM.DAT goto :createRotoZoom
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createRotoZoom
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\RotoZoom.c modified after ..\Output\ROTOZOOM.DAT
if %ERRORLEVEL% NEQ 0 goto :endRotoZoom
:createRotoZoom
cd ..\Sources\Demo\Data\RotoZoom
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c DATA.CFG -o ..\..\RotoZoom.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\RotoZoom.c -create-app -o ROTOZOOM.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del RotoZoom.cpc > nul
pack.exe ROTOZOOM.Z80
ren ROTOZOOM ROTOZOOM.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\RotoZoom_Link.h > nul
move /Y ROTOZOOM ..\..\..\..\Output\ROTOZOOM.DAT
del ROTOZOOM.DAT > nul
del ROTOZOOM.Z80 > nul
del ROTOZOOM.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endRotoZoom

echo Compiling "Tunnel2" part..
if not exist ..\Output\TUNNEL2.DAT goto :createTunnel2
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createTunnel2
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Tunnel2.c modified after ..\Output\TUNNEL2.DAT
if %ERRORLEVEL% NEQ 0 goto :endTunnel2
:createTunnel2
cd ..\Sources\Demo\Data\Tunnel2
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c DATA.CFG -o ..\..\Tunnel2.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Tunnel2.c -create-app -o TUNNEL2.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Tunnel2.cpc > nul
pack.exe TUNNEL2.Z80
ren TUNNEL2 TUNNEL2.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Tunnel2_Link.h > nul
move /Y TUNNEL2 ..\..\..\..\Output\TUNNEL2.DAT
del TUNNEL2.DAT > nul
del TUNNEL2.Z80 > nul
del TUNNEL2.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endTunnel2

echo Compiling "Nuages2" part..
if not exist ..\Output\NUAGES2.DAT goto :createNuages2
find /c ".c" ..\Sources\CrocoLib\build.log > nul
if %ERRORLEVEL% NEQ 1 goto :createNuages2
..\ThirdParty\WasFile\WasFile.exe ..\Sources\Demo\Nuages2.c modified after ..\Output\NUAGES2.DAT
if %ERRORLEVEL% NEQ 0 goto :endNuages2
:createNuages2
cd ..\Sources\Demo\Data\Nuages2
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\DataLinker\DataLinker.exe > nul
if not exist CHAOS.SCR.NOHEADER delAmsHeader.exe CHAOS.SCR CHAOS.SCR.NOHEADER > nul
if not exist CHAOS.PAL.NOHEADER delAmsHeader.exe CHAOS.PAL CHAOS.PAL.NOHEADER > nul
if not exist CHAOS.SCR.NOHEADER.PCK pack.exe CHAOS.SCR.NOHEADER
DataLinker.exe -c DATA.CFG -o ..\..\Nuages2.h > nul
zcc +cpc -zorg=5376 -lCrocoLib -llib3d -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Nuages2.c -create-app -o NUAGES2.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del Nuages2.cpc > nul
pack.exe NUAGES2.Z80
ren NUAGES2 NUAGES2.DAT > nul
DataLinker.exe -c PART.CFG -o ..\..\Nuages2_Link.h > nul
move /Y NUAGES2 ..\..\..\..\Output\NUAGES2.DAT
del NUAGES2.DAT > nul
del NUAGES2.Z80 > nul
del NUAGES2.Z80.PCK > nul
del DataLinker.exe > nul
del delAmsHeader.exe > nul
del pack.exe > nul
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endNuages2

echo Compiling "Demo Loader (Part 1)"..
cd ..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\PART1.CFG -o ..\Sources\Demo\Loader_Link1.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILEPART1 -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER1.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER1.CPC > nul
move /Y LOADER1.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoader1

echo Compiling "Demo Loader (Part 2)"..
cd ..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\PART2.CFG -o ..\Sources\Demo\Loader_Link2.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILEPART2 -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER2.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER2.CPC > nul
move /Y LOADER2.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoader2

echo Compiling "Demo Loader (Part 3)"..
cd ..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\PART3.CFG -o ..\Sources\Demo\Loader_Link3.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILEPART3 -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER3.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER3.CPC > nul
move /Y LOADER3.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoader3

echo Compiling "Demo Loader (Part 4)"..
cd ..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\PART4.CFG -o ..\Sources\Demo\Loader_Link4.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILEPART4 -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER4.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER4.CPC > nul
move /Y LOADER4.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoader4

echo Compiling "Demo Loader (Part 5)"..
cd ..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\PART5.CFG -o ..\Sources\Demo\Loader_Link5.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILEPART5 -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER5.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER5.CPC > nul
move /Y LOADER5.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoader5

echo Compiling "Demo Loader (LastPart)"..
cd ..\Sources\Demo\Data\Loader
copy ..\..\..\..\ThirdParty\BitBuster\pack.exe > nul
copy ..\..\..\..\ThirdParty\delAmsHeader\delAmsHeader.exe > nul
if not exist ALONE.SCR.NOHEADER delAmsHeader.exe ALONE.SCR ALONE.SCR.NOHEADER > nul
if not exist ALONE.SCR.NOHEADER.PCK pack.exe ALONE.SCR.NOHEADER
if not exist DMALIB.BIN.PCK pack DMALIB.BIN
del pack.exe > nul
del delAmsHeader.exe > nul
cd ..\..\..\..\Output
copy ..\ThirdParty\DataLinker\DataLinker.exe > nul
DataLinker.exe -c ..\Sources\Demo\Data\Loader\LASTPART.CFG -o ..\Sources\Demo\Loader_LinkLastPart.h > nul
del DataLinker.exe > nul
cd ..\Sources\Demo\Data\Loader
zcc +cpc -zorg=2272 -DCOMPILELASTPART -lCrocoLib -O3 -I..\..\..\CrocoLib -I..\.. ..\..\Loader.c -create-app -o LOADER6.Z80 > nul
if %ERRORLEVEL% NEQ 0 goto :compileAborted
del LOADER6.CPC > nul
move /Y LOADER6.Z80 ..\..\..\..\Output
del zcc_opt.def > nul
cd ..\..\..\..\Build
:endLoaderLastPart

echo Creating disc-image..
cd ..\Output
if exist DEMO.DSK del DEMO.DSK > nul
..\ThirdParty\CPCFS\CPCFS.exe -nD DEMO.DSK > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p DEMO.BIN,41728,41728 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER1.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER2.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER3.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER4.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER5.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADER6.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART1.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART2.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART3.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART4.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART5.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p PART6.DAT > nul
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADING.Z80 > nul	
..\ThirdParty\CPCTools\CPCFS.exe DEMO.DSK -b -e p LOADING.DAT > nul
cd ..\Build

if (%1)==() goto :endScript
echo Launching emulator..
..\ThirdParty\WinAPE\WinAPE.exe ..\..\..\Output\DEMO.DSK /A

goto :endScript

:libCompileAborted
cd ..\..\Build
goto :endFailed

:compileAborted
cd ..\..\..\..\Build
goto :endFailed

:endFailed

:endScript
if exist ..\Sources\CrocoLib\build.log del ..\Sources\CrocoLib\build.log > nul
if exist ..\Sources\CrocoLib\build.log del ..\Sources\CrocoLib\build_err.log > nul
