/******************************************************************************
 * Tile.h                                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __TILE_H__
#define __TILE_H__

// ---------------------------------------------------------------------------- TILE TYPE
enum TileType
{
    TILE_EMPTY,
    TILE_SLOW,
    TILE_NORMAL,
    TILE_FAST,
    TILE_VERYFAST,
    TILE_CUBE
};

// ---------------------------------------------------------------------------- TILE
class Tile
{
public:
	~Tile( );

    static Tile *createTile( TileType type, const string textureFilename );

    void render( );

    Mesh *getMesh( );
    float getSize( );

    TileType getType( );

private:
    Tile( TileType type, const string textureFilename );
    
    void createQuad( );
    void createCube( );

    TileType m_type;

    Mesh *m_mesh;
    Texture *m_texture;

    struct Cube
    {
        const float posX1, posY1, posZ1;
        const float posX2, posY2, posZ2;
        const float posX3, posY3, posZ3;
        const float posX4, posY4, posZ4;
    };
    static const Cube cubeFace[ ];
};

// ---------------------------------------------------------------------------- END
#endif // __TILE_H__
