/******************************************************************************
 * Ship.h                                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __SHIP_H__
#define __SHIP_H__

// ---------------------------------------------------------------------------- SHIP
class Ship
{
public:
	~Ship( );

    static Ship *createShip( string name, string meshFilename, float scale, float grip, float maxSpeed, float lenghtJump );
    
    void render( );

    void setEnvmap( Texture *envmap );

    Mesh *getMesh( ) { return m_mesh; };
    
    string getName( ) { return m_name; };

    float getScale( ) { return m_scale; };

    float getGrip( ) { return m_grip; };
    float getMaxSpeed( ) { return m_maxSpeed; };
    float getLenghtJump( ) { return m_lenghtJump; };

private:
    Ship( string name, string meshFilename, float scale, float grip, float maxSpeed, float lenghtJump );

    Mesh *m_mesh;
    
    string m_name;

    float m_scale;

    float m_grip;
    float m_maxSpeed;
    float m_lenghtJump;
};

// ---------------------------------------------------------------------------- END
#endif // __SHIP_H__
