#include "DevLib.h"
/******************************************************************************
 * Ship.cpp                                                                   *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "Ship.h"

// ---------------------------------------------------------------------------- CONSTRUCTOR
Ship::Ship( string name, string meshFilename, float scale, float grip, float maxSpeed, float lenghtJump )
{
    m_name = name;

    m_scale = scale;

    m_grip = grip;
    m_maxSpeed = maxSpeed;
    m_lenghtJump = lenghtJump;
    
    m_mesh = Mesh::createMesh( meshFilename );
}

// ---------------------------------------------------------------------------- DESTRUCTOR
Ship::~Ship( )
{
    delete m_mesh;
}

// ---------------------------------------------------------------------------- CREATE SHIP
Ship *Ship::createShip( string name, string meshFilename, float scale, float grip, float maxSpeed, float lenghtJump )
{    
    return new Ship( name, meshFilename, scale, grip, maxSpeed, lenghtJump );
}

// ---------------------------------------------------------------------------- RENDER
void Ship::render( )
{
    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    // Set culling    
    rs->setRenderState( RS_CULLING, RV_CULLING_CW );
    
    m_mesh->render( );
}

// ---------------------------------------------------------------------------- SET ENVMAP
void Ship::setEnvmap( Texture *envmap )
{
    assert( envmap );
    
    for ( int material = 0; material < m_mesh->getMaterialCount( ); ++material )
    {
        m_mesh->getMaterial( material )->setRenderState( 0, RS_MAPPING, RV_MAPPING_SPHERICAL );	
        m_mesh->getMaterial( material )->setTexture( 0, envmap );
    }
}