/******************************************************************************
 * Player.h                                                                   *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __PLAYER_H__
#define __PLAYER_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Tile.h"
#include "Ship.h"

// ---------------------------------------------------------------------------- COLLIDE TYPE
enum CollideType
{
    COLLIDE_NONE,

    COLLIDE_LEFT,
    COLLIDE_RIGHT,
    COLLIDE_FRONTLEFT,
    COLLIDE_FRONTRIGHT
};

// ---------------------------------------------------------------------------- COLLIDE ITEM
struct CollideItem
{
    CollideType type;
    TileType tileType;
};

// ---------------------------------------------------------------------------- PLAYER
class Player
{
public:
	~Player( );

    static Player *createPlayer( Ship *ship );

    void update( );
    void keyPress( Key key );

    void reset( );
    
    Ship *getShip( ) { return m_ship; };

    void setPosX( float posX ) { m_posX = posX; };
    void setPosY( float posY ) { m_posY = posY; };
    void setPosZ( float posZ ) { m_posZ = posZ; };
    float getPosX( ) { return m_posX; };
    float getPosY( ) { return m_posY; };
    float getPosZ( ) { return m_posZ; };
    
    void setRotX( float rotX ) { m_rotX = rotX; };
    void setRotY( float rotY ) { m_rotY = rotY; };
    void setRotZ( float rotZ ) { m_rotZ = rotZ; };
    float getRotX( ) { return m_rotX; };
    float getRotY( ) { return m_rotY; };
    float getRotZ( ) { return m_rotZ; };

    void setAccelX( float AccelX ) { m_accelX = AccelX; };
    void setAccelY( float AccelY ) { m_accelY = AccelY; };
    void setAccelZ( float AccelZ ) { m_accelZ = AccelZ; };
    float getAccelX( ) { return m_accelX; };
    float getAccelY( ) { return m_accelY; };
    float getAccelZ( ) { return m_accelZ; };

    void setFreezeTime( float freezeTime ) { m_freezeTime = freezeTime; };
    float getFreezeTime( ) { return m_freezeTime; };

    void setFallY( float fallY ) { m_fallY = fallY; };
    float getFallY( ) { return m_fallY; };

    void setJumpCount( int jumpCount ) { m_jumpCount = jumpCount; };
    int getJumpCount( ) { return m_jumpCount; };

    void setScore( int score ) { m_score = score; };
    int getScore( ) { return m_score; };
    
    void setLifeCount( int lifeCount ) { m_lifeCount = lifeCount; };
    int getLifeCount( ) { return m_lifeCount; };

    float getLostTime( ) { return m_lostTime; };

    bool hasFinishedLevel( ) { return m_hasFinishedLevel; };

    bool hasLost( );
    
private:
    Player( Ship *ship );

    TileType getCurrentTile( );
    bool checkCollisions( );

    vector< CollideItem > m_collideList;

    Ship *m_ship;
    
    float m_posX;
    float m_posY;
    float m_posZ;

    float m_rotX;
    float m_rotY;
    float m_rotZ;

    float m_accelX;
    float m_accelY;
    float m_accelZ;

    float m_fallY;

    bool m_freezeAddTime;
    float m_freezeTime;

    float m_speed;

    int m_jumpCount;

    int m_score;
    int m_lifeCount;

    bool m_hasFinishedLevel;
    bool m_hasLost;

    float m_lostTime;
};

// ---------------------------------------------------------------------------- END
#endif // __PLAYER_H__
