/******************************************************************************
 * MenuMain.h                                                                 *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __MENU_MAIN_H__
#define __MENU_MAIN_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"

// ---------------------------------------------------------------------------- MENU MAIN SELECTION
enum MenuMainSelection
{
    MENUMAIN_SELECTION_ONEPLAYER,
    MENUMAIN_SELECTION_TWOPLAYERS,
    MENUMAIN_SELECTION_INSTRUCTIONS,
    MENUMAIN_SELECTION_QUIT
};

// ---------------------------------------------------------------------------- MENU MAIN
class MenuMain : public Displayable
{
public:
	~MenuMain( );

    static MenuMain *createMenuMain( );

    virtual void displayUpdate( );
    virtual void keyPress( Key key );

    virtual bool isFinished( ) { return m_isFinished; };

    virtual DisplayableType getDisplayableType( ) { return DISPLAYABLE_MENU_MAIN; }

    MenuMainSelection getSelection( ) { return m_selection; };

private:
    MenuMain( );

    MenuMainSelection m_selection;
    bool m_isFinished;

    Texture *m_cursor;
    int m_item;
};

// ---------------------------------------------------------------------------- END
#endif // __MENU_MAIN_H__
