/******************************************************************************
 * Menu.h                                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __MENU_H__
#define __MENU_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"
#include "Ship.h"

// ---------------------------------------------------------------------------- MENU
class Menu : public Displayable
{
public:
	~Menu( );

    static Menu *createMenu( );

    virtual void displayUpdate( );
    virtual void keyPress( Key key );

    virtual bool isFinished( ) { return m_isFinished; };

    virtual DisplayableType getDisplayableType( ) { return DISPLAYABLE_MENU; }

    Ship *getShipPlayer1( ) { return m_shipPlayer1; };
    Ship *getShipPlayer2( ) { return m_shipPlayer2; };

private:
    Menu( );

    bool m_isFinished;

    float m_keyActivateTime;
    
    Ship *m_shipPlayer1;
    Ship *m_shipPlayer2;

    Sound *m_music;

    Displayable *m_displayable;
};

// ---------------------------------------------------------------------------- END
#endif // __MENU_H__
