#include "DevLib.h"
/******************************************************************************
 * Menu.cpp                                                                   *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "Menu.h"
#include "MenuMain.h"
#include "MenuInstructions.h"
#include "MenuSelectShip.h"
#include "Application.h"
#include "DisplayableFactory.h"

// ---------------------------------------------------------------------------- CONSTRUCTOR
Menu::Menu( )
{
    string backgroundFilename = Application::getInstance( )->getXML( )->getRoot( )->getChildElement( "menu" )->getChildElement( "background" )->getChildElement( )->getString( );
    string cloudsFilename = Application::getInstance( )->getXML( )->getRoot( )->getChildElement( "menu" )->getChildElement( "clouds" )->getChildElement( )->getString( );

    Application::getInstance( )->getBackground( )->setTextures( backgroundFilename, cloudsFilename );

    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    m_displayable = DisplayableFactory::createDisplayable( DISPLAYABLE_MENU_MAIN );

    m_keyActivateTime = 0.0f;

    m_shipPlayer1 = 0;
    m_shipPlayer2 = 0;

    string musicFilename = Application::getInstance( )->getXML( )->getRoot( )->getChildElement( "menu" )->getChildElement( "music" )->getChildElement( )->getString( );
    m_music = Sound::createSound( musicFilename );
    m_music->play( );

    m_isFinished = false;
}

// ---------------------------------------------------------------------------- DESTRUCTOR
Menu::~Menu( )
{
    delete m_displayable;
    
    delete m_music;
}

// ---------------------------------------------------------------------------- CREATE MENU
Menu *Menu::createMenu( )
{
    return new Menu( );
}

// ---------------------------------------------------------------------------- KEY PRESS
void Menu::keyPress( Key key )
{
    float time = Application::getInstance( )->getTime( );

    if ( time > m_keyActivateTime )
    {
        m_keyActivateTime = time + 0.2f;

        m_displayable->keyPress( key );
    }
}

// ---------------------------------------------------------------------------- DISPLAY UPDATE
void Menu::displayUpdate( )
{
    float time = Application::getInstance( )->getTime( );
    float elapsedTime = Application::getInstance( )->getElapsedTime( );

    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    rs->setViewport( 0, 0, rs->getWidth( ), rs->getHeight( ) );
    
    // Display background
    Application::getInstance( )->getBackground( )->displayUpdate( );

    if ( !m_displayable->isFinished( ) )
    {
        m_displayable->displayUpdate( );
    }
    else
    {
            Displayable *newDisplayable = 0;

            switch( m_displayable->getDisplayableType( ) )
            {
            case DISPLAYABLE_MENU_MAIN:
                {
                    switch( ( ( MenuMain *) m_displayable )->getSelection( ) )
                    {
                    case MENUMAIN_SELECTION_ONEPLAYER:
                        newDisplayable = DisplayableFactory::createDisplayable( DISPLAYABLE_MENU_SELECTSHIP );
                        ( ( MenuSelectShip *) newDisplayable )->setPlayerCount( 1 );
                        break;

                    case MENUMAIN_SELECTION_TWOPLAYERS:
                        newDisplayable = DisplayableFactory::createDisplayable( DISPLAYABLE_MENU_SELECTSHIP );
                        ( ( MenuSelectShip *) newDisplayable )->setPlayerCount( 2 );
                        break;

                    case MENUMAIN_SELECTION_INSTRUCTIONS:
                        newDisplayable = DisplayableFactory::createDisplayable( DISPLAYABLE_MENU_INSTRUCTIONS );
                        break;

                    case MENUMAIN_SELECTION_QUIT:
                        m_music->stop( );
                        m_isFinished = true;
                        break;
                    }
                }
                break;

            case DISPLAYABLE_MENU_INSTRUCTIONS:
                newDisplayable = DisplayableFactory::createDisplayable( DISPLAYABLE_MENU_MAIN );
                break;

            case DISPLAYABLE_MENU_SELECTSHIP:
                m_shipPlayer1 = ( ( MenuSelectShip *) m_displayable )->getShipPlayer1( );
                m_shipPlayer2 = ( ( MenuSelectShip *) m_displayable )->getShipPlayer2( );
                m_isFinished = true;
                m_music->stop( );
                Application::getInstance( )->getLoading( )->displayUpdate( );
                break;
            }

            delete m_displayable;
            
            if ( newDisplayable )
                m_displayable = newDisplayable;
            else
                m_displayable = 0;
    }
}
