#include "DevLib.h"
/******************************************************************************
 * DisplayableFactory.cpp                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "DisplayableFactory.h"
#include "Menu.h"
#include "MenuMain.h"
#include "MenuInstructions.h"
#include "MenuSelectShip.h"
#include "Game.h"

// ---------------------------------------------------------------------------- CREATE DISPLAYABLE
Displayable *DisplayableFactory::createDisplayable( DisplayableType type )
{
    Displayable *displayable = 0;
    
    switch( type )
    {
    case DISPLAYABLE_MENU:
        displayable = Menu::createMenu( );
        break;

    case DISPLAYABLE_MENU_MAIN:
        displayable = MenuMain::createMenuMain( );
        break;
    
    case DISPLAYABLE_MENU_INSTRUCTIONS:
        displayable = MenuInstructions::createMenuInstructions( );
        break;
    
    case DISPLAYABLE_MENU_SELECTSHIP:
        displayable = MenuSelectShip::createMenuSelectShip( );
        break;

    case DISPLAYABLE_GAME:
        displayable = Game::createGame( );
        break;
    }

    assert( displayable );
    return displayable;
}
