org 49152

;uchar BallLineLength(int gridx, int gridy, uchar *grid)
;{
;  uchar maxlength = 1;
;  uchar *tmp;
;  uchar i;
;  char diffx[6];      



; INPUT
;		c: gridx
;		e: gridy
; 		hl: grid
; LOCAL
;		d: loop counter
;		b: maxlength
; OUTPUT
;		a: maxlength
  
BallLineLength_ASM
;if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
; return 0;  	
	ld a, c
	and $80		; if the highest bit is 1, it is a negative integer
	jp nz, bll_return_0
	ld a, e
	and $80
	jp nz, bll_return_0
	ld a, c
	cp 8		; a = gridx - 8
	jp nc, bll_return_0		; if there is no carry, then it is higher. Return 0
	ld a, e
	cp 9
	jp nc, bll_return_0
	jp continue_balllinelength		
bll_return_0
	ld a,0
	ret	
continue_balllinelength

;  modifier = gridy&1;	
	ld a, e
	and 1		; the modifier variable is only used in the loop below, so A = modifier
		
;  for(i=2;i<6;i++) 
;    diffx[i] = init_diffx[i]+modifier;
;  diffx[0]=-1;
;  diffx[1]=1;
	push hl		; create a pointer variable (tmp)
	push hl
	push hl		; 
	push hl		; then a local 6 byte variable in the stack (diffx)
	push hl
	push bc		; these two are normal pushes, to be restored later on
	ld hl, 6	; this will take hl to the beginning of the diffx variable
   	add hl,sp
   	ld b, h
   	ld c, l
   	ld ix,0  
   	add ix, bc	; IX = pointer to diffx local variable
   			; (HL and BC are still in the stack!)
   	ld (ix+0), -1
   	ld (ix+1),1
   	ld bc, init_diffx
   	inc bc
   	inc bc
   	ld iy, 0
   	add iy, bc	; IY =pointer to init_diffx + 2
   	ld b,0
   	ld c,a		; bc = modifier   	
   	ld h,0
   	ld l, (iy+0)
   	add hl, bc	; hl = init_diffx[2]+ modifier
   	ld (ix+2), l
   	ld h,0
   	ld l, (iy+1)
   	add hl, bc	; hl = init_diffx[3]+ modifier
   	ld (ix+3), l   	
   	ld h,0
   	ld l, (iy+2)
   	add hl, bc	; hl = init_diffx[4]+ modifier
   	ld (ix+4), l
   	ld h,0
   	ld l, (iy+3)
   	add hl, bc	; hl = init_diffx[5]+ modifier
   	ld (ix+5), l
   	pop bc
   	pop hl		; restore BC and HL (finally)
   	
;  // We have to search all 6 directions  
;  tmp=&(grid[gridx|gridy<<3]);   	
;	HL will be this tmp when needed

	push hl		; may need it later on
	push de			

	ld d,0
	ex de,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ex de,hl	; DE = gridy << 3; HL = grid
	ld a, c
	or e
	ld e, a		; DE = gridx | (gridy <<3)
	add hl, de	; HL == tmp = &(grid[gridx|gridy<<3]);

; we need diffy in the loop, so IY = diffy. 
	ld iy, diffy	; IY = diffy
	
; d will be the looop counter, maxlength (b) is 1 initially
	pop de
	ld d,0		; d is the loop counter
	push de		; it will usually be in the stack
	ld b,1
			; the stack when entering the loop is: -> (gridy, grid)
bll_loopstart
;  for(i=0;i<6;i++)
;  {
;  	if (*tmp == *(tmp+diffx[i]+(diffy[i]<<3)))
;  	{  	
	ld a, (iy+0)
	add a,a
	add a,a
	add a,a		; a = diffy[i]<<3
	add a, (ix+0)	; a = diffx[i]+(diffy[i]<<3)
	push hl
	ld e,a 		; now we have to extend the sign into D, if E is negative
	rlca
	sbc a,a
	ld d, a		
	add hl, de	; hl = tmp+diffx[i]+(diffy[i]<<3)			
	ld a, (hl)	; a = *(tmp+diffx[i]+(diffy[i]<<3)))
	pop hl
	cp (hl)		; compare with *tmp
	jp nz, bll_loop_continue
; *tmp  |= 0x80;  // Mark the ball to avoid loops!
	ld a, (hl)
	or $80
	ld (hl), a	
; maxlength += BallLineLength(gridx+diffx[i],gridy+diffy[i],grid);
	ld (ix-2), l
	ld (ix-1), h	; save tmp in the reserved stack space
	pop de		; 
	pop hl		; get back the original hl value (i.e. grid)
	push hl		; save the current state in the stack
	push de
	push ix		
	push iy
	push bc

	ld a, c
	add a, (ix+0)	; a = gridx + diffx[i]
	ld c, a
	ld a, e
	add a, (iy+0)	; a = gridy + diffy [i]
	ld e, a		; b=maxlength, c: gridx + diffx[i] , d: loop counter, e: gridy + diffy [i], hl: grid
	call BallLineLength_ASM	; recursive call

	pop bc
	pop iy
	pop ix		; the current stack state is -> (de, hl), just like it was when we entered the loop

	add a,b
	ld b,a		; add the result to the current maxlength
	
;*tmp  &= 0x7f;  // Unmark the ball
	ld l,(ix-2)
	ld h,(ix-1)		; get tmp back from the stack
	ld a, (hl)
	and $7f
	ld (hl), a	
;	}	
bll_loop_continue
;	if(maxlength > 2) return maxlength;
	ld a,b
	cp 3
	jp c, bll_loop_updatecounter	; the current maxlength is not 3 or more yet
	pop de
	pop hl				; get the stack to a decent state
	pop hl
	pop hl
	pop hl		
	pop hl				; the 8 bytes we used in the stack
	ld a, b
	ret				; it is, so we return the maxlength
bll_loop_updatecounter
	pop de
	inc d
	push de				; the loop counter is back in the stack
	ld a, d				; the current stack state is -> (de, hl), just like it was when we entered the loop
	cp 6
	jp nc, bll_finish		; if the counter has not reached 6, continue with the loop
	inc iy
	inc ix				; WARNING: when moving IX, we are moving the place where the tmp pointer is stored
					; in this VERY special case, it works, since we do not need the previous values of diffx
					; anymore. BUT THIS IS A NASTY HACK, which seems to be the best option btw :P	
	jp bll_loopstart			
; } 
; return maxlength;	
;}
bll_finish
	pop de
	pop hl				; get the stack to a decent state
	pop hl
	pop hl
	pop hl		
	pop hl				; the 8 bytes we used in the stack
	ld a,b
	ret


; INPUT
;		c: gridx
;		e: gridy
; 		hl: grid
; LOCAL
;		d: loop counter
; OUTPUT
;		NONE

;void MarkLines(char gridx, char gridy, uchar *grid)
;{
;  uchar i;
;  char diffx[6];

MarkLines_ASM
  
;// If we are at the border of the game area, return 0 (no more balls)
;  if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
;	return; 
	ld a, c
	and $80		; if the highest bit is 1, it is a negative integer
	jp nz, mkl_return
	ld a, e
	and $80
	jp nz, mkl_return
	ld a, c
	cp 8		; a = gridx - 7
	jp nc, mkl_return		; if there is no carry, then it is higher. Return
	ld a, e
	cp 9
	jp nc, mkl_return
	jp continue_marklines
mkl_return
	ret	
continue_marklines
;modifier = gridy&1;
	ld a, e
	and 1		; the modifier variable is only used in the loop below, so A = modifier		
;  for(i=2;i<6;i++) 
;    diffx[i] = init_diffx[i]+modifier;
;  diffx[0]=-1;
;  diffx[1]=1;
	push hl		; create a pointer variable (tmp), to hold &grid[gridx | (gridy<<3)] later on
	push hl
	push hl		; 
	push hl		; create a local 6 byte variable in the stack (diffx)
	push hl
	push bc		; these two are normal pushes, to be restored later on
	ld hl, 6	; this will take hl to the beginning of the diffx variable
   	add hl,sp
   	ld b, h
   	ld c, l
   	ld ix,0  
   	add ix, bc	; IX = pointer to diffx local variable
   			; (HL and BC are still in the stack!)
   	ld (ix+0), -1
   	ld (ix+1),1
   	ld bc, init_diffx
   	inc bc
   	inc bc
   	ld iy, 0
   	add iy, bc	; IY =pointer to init_diffx + 2
   	ld b,0
   	ld c,a		; bc = modifier   	
   	ld h,0
   	ld l, (iy+0)
   	add hl, bc	; hl = init_diffx[2]+ modifier
   	ld (ix+2), l
   	ld h,0
   	ld l, (iy+1)
   	add hl, bc	; hl = init_diffx[3]+ modifier
   	ld (ix+3), l   	
   	ld h,0
   	ld l, (iy+2)
   	add hl, bc	; hl = init_diffx[4]+ modifier
   	ld (ix+4), l
   	ld h,0
   	ld l, (iy+3)
   	add hl, bc	; hl = init_diffx[5]+ modifier
   	ld (ix+5), l
   	pop bc
   	pop hl		; restore BC and HL (finally)
;  // We have to search all 6 directions  
; grid[gridx | (gridy<<3)]  |= 0x80;  // Mark the ball: this ball will be deleted, and we avoid loops

	push hl		; may need it later on
	push de			
	ld d,0
	ex de,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ex de,hl	; DE = gridy << 3; HL = grid
	ld a, c
	or e
	ld e, a		; DE = gridx | (gridy <<3)
	add hl, de	; HL == &(grid[gridx|gridy<<3]);
	ld a, (hl)
	or $80
	ld (hl), a
; we need diffy in the loop, so IY = diffy. 
	ld iy, diffy	; IY = diffy
; d will be the looop counter
	pop de
	ld d,0		; d is the loop counter
	push de		; it will usually be in the stack
			; the stack when entering the loop is: -> (gridy, grid)
mkl_loopstart
;  for(i=0;i<6;i++)
;  {
; 	if ((grid[gridx | (gridy<<3)]&0x7f) == grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)])
;  	{  	
	ld (ix-2), l
	ld (ix-1), h	; save hl in the reserved stack space
	ld a, c
	add a, (ix+0)	; a = gridx + diffx[i]
	ld b, a
	pop de		; we need the right value for gridy
	ld a, e
	add a, (iy+0)	; a = gridy + diffy [i]
	add a, a
	add a, a
	add a, a	; a = (gridy + diffy[i]) << 3
	or b		; a = (gridx+diffx[i]) | ((gridy+diffy[i])<<3)
	ld b, a		; a = b = (gridx+diffx[i]) | ((gridy+diffy[i])<<3)
	pop hl
	push hl
	push de		; set the stack right (again)
	adc a, l
	ld l, a
	ld a, 0
	adc a, h
	ld h, a		; hl = grid + (gridx+diffx[i]) | ((gridy+diffy[i])<<3)
	ld a, (hl)
	ld b, a		; b = grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)]
	ld l,(ix-2)
	ld h,(ix-1)	; get tmp back from the stack
	ld a, (hl)	; a=grid[gridx | (gridy<<3)]
	and $7f		; a=grid[gridx | (gridy<<3)] & 0x7f 
	cp b		;
	jp nz, mkl_loop_continue
;	MarkLines(gridx+diffx[i],gridy+diffy[i],grid);

	pop de		; 
	pop hl		; get back the original hl value (i.e. grid)
	push hl		; save the current state in the stack
	push de
	push ix		
	push iy
	push bc

	ld a, c
	add a, (ix+0)	; a = gridx + diffx[i]
	ld c, a
	ld a, e
	add a, (iy+0)	; a = gridy + diffy [i]
	ld e, a		; c: gridx + diffx[i] , d: loop counter, e: gridy + diffy [i], hl: grid
	call MarkLines_ASM	; recursive call

	pop bc
	pop iy
	pop ix		; the current stack state is -> (de, hl), just like it was when we entered the loop	
	ld l,(ix-2)
	ld h,(ix-1)		; get tmp back from the stack
; 	}	
;  }  	
mkl_loop_continue
	pop de
	inc d
	push de				; the loop counter is back in the stack
	ld a, d				; the current stack state is -> (de, hl), just like it was when we entered the loop
	cp 6
	jp nc, mkl_finish		; if the counter has not reached 6, continue with the loop
	inc iy
	inc ix				; WARNING: when moving IX, we are moving the place where the tmp pointer is stored
					; in this VERY special case, it works, since we do not need the previous values of diffx
					; anymore. BUT THIS IS A NASTY HACK, which seems to be the best option btw :P	
	jp mkl_loopstart		
;}
mkl_finish
	pop de
	pop hl				; get the stack to a decent state
	pop hl
	pop hl
	pop hl		
	pop hl				; the 8 bytes we used in the stack
	ret

; INPUT
;		c: gridx
;		e: gridy
; 		hl: grid
; LOCAL
;		d: loop counter
;		b: modifier (in loop)
; OUTPUT
;		NONE

;void FindHangingBalls(char gridx, char gridy, uchar *grid)
;{
;  uchar i;
;  char diffx[6];

FindHangingBalls_ASM
;// If we are at the border of the game area, return 0 (no more balls)
;  if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
;	return; 
	ld a, c
	and $80		; if the highest bit is 1, it is a negative integer
	jp nz, fhb_return
	ld a, e
	and $80
	jp nz, fhb_return
	ld a, c
	cp 8		; a = gridx - 7
	jp nc, fhb_return		; if there is no carry, then it is higher. Return
	ld a, e
	cp 9
	jp nc, fhb_return
	jp continue_fhb
fhb_return
	ret	
continue_fhb
;modifier = gridy&1;
	ld a, e
	and 1		; the modifier variable is only used in the loop below, so A = modifier		
;  for(i=2;i<6;i++) 
;    diffx[i] = init_diffx[i]+modifier;
;  diffx[0]=-1;
;  diffx[1]=1;
	push hl
	push hl		; 
	push hl		; create a local 6 byte variable in the stack (diffx)
	push hl
	push bc		; these two are normal pushes, to be restored later on
	ld hl, 4	; this will take hl to the beginning of the diffx variable
   	add hl,sp
   	ld b, h
   	ld c, l
   	ld ix,0  
   	add ix, bc	; IX = pointer to diffx local variable
   			; (HL and BC are still in the stack!)
   	ld (ix+0), -1
   	ld (ix+1),1
   	ld bc, init_diffx
   	inc bc
   	inc bc
   	ld iy, 0
   	add iy, bc	; IY =pointer to init_diffx + 2
   	ld b,0
   	ld c,a		; bc = modifier   	
   	ld h,0
   	ld l, (iy+0)
   	add hl, bc	; hl = init_diffx[2]+ modifier
   	ld (ix+2), l
   	ld h,0
   	ld l, (iy+1)
   	add hl, bc	; hl = init_diffx[3]+ modifier
   	ld (ix+3), l   	
   	ld h,0
   	ld l, (iy+2)
   	add hl, bc	; hl = init_diffx[4]+ modifier
   	ld (ix+4), l
   	ld h,0
   	ld l, (iy+3)
   	add hl, bc	; hl = init_diffx[5]+ modifier
   	ld (ix+5), l
   	pop bc
   	pop hl		; restore BC and HL (finally)  
;  // We have to search all 6 directions  
; grid[gridx | (gridy<<3)]  |= 0x80;  // Mark the ball: this ball is in a safe position (must not fall)
	push hl		; may need it later on
	push de			
	ld d,0
	ex de,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ex de,hl	; DE = gridy << 3; HL = grid
	ld a, c
	or e
	ld e, a		; DE = gridx | (gridy <<3)
	add hl, de	; HL == &(grid[gridx|gridy<<3]);
	ld a, (hl)
	or $80
	ld (hl), a
; we need diffy in the loop, so IY = diffy. 
	ld iy, diffy	; IY = diffy
; d will be the looop counter
	pop de
	ld d,0		; d is the loop counter
	push de		; it will usually be in the stack
			; the stack when entering the loop is: -> (gridy, grid)  
fhb_loopstart
;  for(i=0;i<6;i++)
;  {
;  	modifier = grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)];
	ld a, c
	add a, (ix+0)	; a = gridx + diffx[i]
	ld b, a
	pop de		; we need the right value for gridy
	ld a, e
	add a, (iy+0)	; a = gridy + diffy [i]
	add a, a
	add a, a
	add a, a	; a = (gridy + diffy[i]) << 3
	or b		; a = (gridx+diffx[i]) | ((gridy+diffy[i])<<3)
	pop hl
	push hl
	push de		; set the stack right (again)
	adc a, l
	ld l, a
	ld a, 0
	adc a, h
	ld h, a		; hl = grid + (gridx+diffx[i]) | ((gridy+diffy[i])<<3)
	ld a, (hl)
	ld b, a		; a == b == modifier = grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)]
;  	if (modifier && (!(modifier &0x80))) // This ball is also safe: go there and search again
	and $80
	jp nz, fhb_loop_continue
	ld a, b
	and a		; this is equivalent to cp 0
	jp z, fhb_loop_continue
;  	{    	  
;      	  FindHangingBalls(gridx+diffx[i],gridy+diffy[i],grid);
	pop de		; 
	pop hl		; get back the original hl value (i.e. grid)
	push hl		; save the current state in the stack
	push de
	push ix		
	push iy
	push bc

	ld a, c
	add a, (ix+0)	; a = gridx + diffx[i]
	ld c, a
	ld a, e
	add a, (iy+0)	; a = gridy + diffy [i]
	ld e, a		; c: gridx + diffx[i] , d: loop counter, e: gridy + diffy [i], hl: grid
	call FindHangingBalls_ASM	; recursive call

	pop bc
	pop iy
	pop ix		; the current stack state is -> (de, hl), just like it was when we entered the loop	
;  	}	
fhb_loop_continue
	pop de
	inc d
	push de				; the loop counter is back in the stack
	ld a, d				; the current stack state is -> (de, hl), just like it was when we entered the loop
	cp 6
	jp nc, fhb_finish		; if the counter has not reached 6, continue with the loop
	inc iy
	inc ix				
	jp fhb_loopstart		
;}
fhb_finish
	pop de
	pop hl				; get the stack to a decent state
	pop hl
	pop hl		
	pop hl				; the 8 bytes we used in the stack
	ret	
;}

;globally used variables

modifier	defb 0
init_diffx	defb -1,1,-1,0,-1,0
diffy		defb 0,0,-1,-1,1,1

; ascii code of the numbers from 0 to 10
number_ascii	defb 48,49,50,51,52,53,54,55,56,57

; Convert integer to 5 character array
;
; IX: pointer to the string
; HL: value to be converted
; output: none
; modifies:everything

my_itoa
	ld bc, 10000
	push hl
	call divide		; DE = hl / 10000 (first digit)
	;ld hl, number_ascii
	;add hl, de
	;ld a, (hl)
	;ld (ix+0), a		; first character
	ld hl, 10000
	ld a, e
	call multiply
	ld c,l
	ld b,h
	pop hl
	xor a
	sbc hl, bc		
	
	ld bc, 1000
	push hl
	call divide		; DE = hl / 1000 (second digit)
	ld hl, number_ascii
	add hl, de
	ld a, (hl)
	ld (ix+0), a		; second character
	ld hl, 1000
	ld a, e
	call multiply
	ld c,l
	ld b,h
	pop hl
	xor a
	sbc hl, bc		
	
	ld bc, 100
	push hl
	call divide		; DE = hl / 1000 (second digit)
	ld hl, number_ascii
	add hl, de
	ld a, (hl)
	ld (ix+1), a		; second character
	ld hl, 100
	ld a, e
	call multiply
	ld c,l
	ld b,h
	pop hl
	xor a
	sbc hl, bc		
	
	ld bc, 10
	push hl
	call divide		; DE = hl / 1000 (second digit)
	ld hl, number_ascii
	add hl, de
	ld a, (hl)
	ld (ix+2), a		; second character
	ld hl, 10
	ld a, e
	call multiply
	ld c,l
	ld b,h
	pop hl
	xor a
	sbc hl, bc		; now hl only has the last digit
	
	ld e, l
	ld d, 0
	ld hl, number_ascii
	add hl, de
	ld a, (hl)
	ld (ix+3),a			
	
	ret

; Divide HL by BC
;
; HL: dividendo
; BC: divisor
; DE: result (HL / BC)

divide
    xor a
    ld de, 0
divide_loop
    sbc hl, bc
    ret c		
    inc de
    jp divide_loop    
    
; Multiply HL by A
;
; HL: b
; a: b
; output
; HL: b * a

multiply
	ld b,h
	ld c,l
	ld hl,0
multiply_loop
	and a
	ret z	; if z is zero, return
	add hl,bc
	dec a
	jp multiply_loop




; Rutinas de apoyo

; Imprimir cadena de caracteres en X,Y
; Entrada:     B: coord X
;              C: coord Y
;	       D: ink
;	       E: paper
;              HL: direccion de la cadena, terminada en FF
; Registros utilizados: A, BC, DE, HL

PRINTF:
       PUSH BC         ; la rutina en 1601H toca todo lo que puede...
       PUSH DE
       PUSH HL
       LD IY, 5C3Ah	; re-establish the IY pointer (must be done!)
       RES 0, (IY+02)
       RES 1, (IY+01)              
       LD BC, (23606)		; 23606 == CHARS
       LD (oldchars), BC	; save the old CHARS value
       LD BC, FONT-384		;CHARS must be loaded with 32 characters before the first char
       				; in this case we only have the numbers, which start from 48
       LD (23606), BC		; now we've got the new charset        
       LD A, 2        ; seleccionar pantalla
       CALL 1601H
       POP HL
       POP DE
       POP BC
       LD A, 16
       RST 10h       	
       LD A, D
       RST 10h		; ink
       LD A, 17
       RST 10h
       LD A, E
       RST 10h		; paper
       LD A, 19
       RST 10h
       LD A, 1
       RST 10h		; bright
       LD A, 22      ; seleccionar fila y columna
       RST 10h
       LD A, C        ; Y
       RST 10h
       LD A, B        ; X
PRINTC:
       RST 10h
       LD A, (HL)      ; caracter
       INC HL
       CP $FF
       JR NZ, PRINTC
       LD HL, (oldchars)	; restore the previous font
       LD (23606), HL
       RET
    
FONT	DEFB	255,227,221,213,221,227,255,  0
	DEFB	255,247,231,247,247,227,255,  0
	DEFB	255,227,253,227,223,227,255,  0
	DEFB	255,227,253,243,253,227,255,  0
	DEFB	255,251,243,235,227,251,255,  0
	DEFB	255,227,223,227,253,227,255,  0
	DEFB	255,227,223,195,221,227,255,  0
	DEFB	255,195,251,251,247,247,255,  0
	DEFB	255,227,221,227,221,227,255,  0
	DEFB	255,227,221,225,253,227,255,  0
	
oldchars DW 0

	org 50176
vortex	INCBIN "player.bin"