/*
	This file is part of "otopoto / Collapse & Gatitos".

    "otopoto / Collapse & Gatitos" is free software: you can redistribute
	it and/or modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, either version 3 of the
	License, or (at your option) any later version.

    "otopoto / Collapse & Gatitos" is distributed in the hope that it will
	be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
	of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with "otopoto / Collapse & Gatitos".  If not, see 
	<http://www.gnu.org/licenses/>.
*/

#ifndef SYNTH_H
#define SYNTH_H

#include "sizedtypes.h"

#define BUFFER_SIZE (1024*8)
#define SAMPLE_RATE 44100.0f
#define MAX_OPS 30
#define PI 3.1415926535897931f
#define TWOPI 6.2831853071795862f
#define PI_samplerate 7.10487365723e-05f
#define TWOPI_samplerate 0.000142097473145f
#define invSAMPLE_RATE 0.000022675736961451248f

/*
    An instrument is defined a FORTH-like stack of several operations between
    waveforms, possibly with parameters. For example:

    square_osc(wet=100%, pulse_width=50%) -> 
    LP_filter(cutoff=4000 Hz, Q=0.1) -> 
    Delay (5ms)

    These operations are encoded as sequences of bytes. The first byte in the
    sequence selects the operation, and the corresponding function reads as many
    parameter bytes as it needs, updating the pointer. Any non-existant
    operation ends the sequence.
*/

typedef struct
{
        float pitch;
        float vol;
        uint8 *ins;  // instrument definition

        int pos;     // position in samples since the start

        // data buffer to store, for example, previous inputs/outputs for
        // filtering. It is as big as the wave buffer. Anyway, voices will be
        // created at bss, so they don't count for the file size :)
        uint8 data[MAX_OPS][20*BUFFER_SIZE*sizeof(float)];

        // buffers generated by wave operations
        float waves[MAX_OPS][BUFFER_SIZE];
} Voice;

#ifdef CONST
#undef CONST
#endif

#define CONST    0
#define SINE     1
#define SQUARE   2
#define TRIANGLE 3
#define SUM      4
#define MUL      5
#define LPF      6

#define NOISE    8
#define SIGMOID  9
#define DELAY   10
#define ENDI   254
#define END    255

extern void synth(Voice *v, int len, float *mix_buf);
extern float detune(float base, int coarse, int fine);
extern float noise();


#endif // SYNTH_H
