#include "main.h"

/******* ACCURATE TIMER CODE ************************************/

/* VERY IMPORTANT !!!! DON'T TOUCH THE FOLLOWING DEFINES IF YOU WANT TO BE COMPATIBLE WITH
/* SYNCRO FILES GENERATED BY DAKE's UTIL !!! */


#define LowPart_Shift	10					//this one needs to be quite small
#define HighPart_Shift  (32-LowPart_Shift)	//the high part doesn't move much
#define Final_Shift     3					//change this for more accuracy
											//but larger integers.. be careful !!! read above


int MXM_hertz_start;
int MXM_hertz_per_second;

int Convert_LINT_to_INT(LARGE_INTEGER source)
{
	int low, high,n ;
	low=source.LowPart>>LowPart_Shift;
	high=source.HighPart>>HighPart_Shift;
	n=low|(high<<HighPart_Shift);
	return n;
}

void TIMER_init_timer()
{
  LARGE_INTEGER mxmtmp;
  QueryPerformanceCounter(&mxmtmp);
  MXM_hertz_start=Convert_LINT_to_INT(mxmtmp);
  QueryPerformanceFrequency(&mxmtmp);
  MXM_hertz_per_second=Convert_LINT_to_INT(mxmtmp)>>Final_Shift;
}

float ACCURATE_TIMER;

int TIMER_return_timer()
{
  int n;

  LARGE_INTEGER mxmtmp;
  QueryPerformanceCounter(&mxmtmp);
  n=Convert_LINT_to_INT(mxmtmp);
  n-=MXM_hertz_start;
  ACCURATE_TIMER=(float) n;
  return (n>>Final_Shift);
}

/* Linear interpolation of values according to time */
/* !!! current_hz must be within the range [time1;time2] !!! */

float INTERPOLATE_float(int time1, int time2, float value1, float value2, int current_hz)
{
	float dt,dx,ratio1,ratio2,ratio3;
	
	dt	   =  time2-time1;
	dx	   =  value2-value1;
	ratio1 =  (dx / dt);
	ratio2 =  (current_hz - time1);
	ratio3 =  value1+(ratio1*ratio2);

	return(ratio3);
}

int INTERPOLATE_long(int time1, int time2, int value1, int value2, int current_hz)
{
	float dt,dx,ratio1,ratio2,ratio3;
	
	dt	   =  time2-time1;
	dx	   =  value2-value1;
	ratio1 =  (dx / dt);
	ratio2 =  (current_hz - time1);
	ratio3 =  value1+(ratio1*ratio2);

	return(ratio3);
}


 
