/* mekka intro               */
/* c a l o d o x   2 0 0 1   */


#include "main.h"
#include "ttf.h"
#include <math.h>
#include <stdio.h>	
#include <stdarg.h>	


GLuint	base;		
GLfloat	cnt1;		
GLfloat	cnt2;	
GLYPHMETRICSFLOAT gmf[256];	// Storage For Information About Our Font
	


GLvoid BuildFont(HDC hDC)					// Build Our Bitmap Font

{

	HFONT	font;							// Windows Font ID

	base = glGenLists(96);					// Storage For 96 Characters ( NEW )

	font = CreateFont(	-45,				// Height Of Font ( NEW )
						  0,				// Width Of Font
						  0,				// Angle Of Escapement
						  0,				// Orientation Angle
					FW_BOLD,				// Font Weight
					  FALSE,				// Italic
					  FALSE,				// Underline
				      FALSE,				// Strikeout
			   ANSI_CHARSET,				// Character Set Identifier
			  OUT_TT_PRECIS,				// Output Precision
		CLIP_DEFAULT_PRECIS,				// Clipping Precision
		    DEFAULT_QUALITY,				// Output Quality
  FF_DONTCARE|DEFAULT_PITCH,				// Family And Pitch
				"Arial");				// Font Name


	SelectObject(hDC, font);				// Selects The Font We Created ( NEW )

	wglUseFontOutlines(	hDC,				// Select The Current DC
				0,				// Starting Character
				255,				// Number Of Display Lists To Build
				base,				// Starting Display Lists
				0.0f,				// Deviation From The True Outlines
				0.0f,				// Font Thickness In The Z Direction
				WGL_FONT_POLYGONS,	// Use Polygons, Not Lines
				gmf);				// Address Of Buffer To Recieve Data



}



GLvoid KillFont(GLvoid)						// Delete The Font
{
 	glDeleteLists(base, 96);				// Delete All 96 Characters ( NEW )
}


GLvoid glPrint(const char *fmt, ...)	
{

	char text[256];						
	va_list		ap;	
	float		length=0;				// Used To Find The Length Of The Text



	if (fmt == NULL) return;				

	va_start(ap, fmt);					
	vsprintf(text, fmt, ap);			
	va_end(ap);		
	
	for (unsigned int loop=0;loop<1;loop++)	// Loop To Find Text Length

	{
		length+=gmf[text[loop]].gmfCellIncX;		// Increase Length By Each Characters Width
	}


	glTranslatef(-length/2,0.0f,0.0f);			// Center Our Text On The Screen

	glPushAttrib(GL_LIST_BIT);				// Pushes The Display List Bits
	glListBase(base);					// Sets The Base Character to 0
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib();									// Pops The Display List Bits

}


void TTF_print_text(unsigned char *f, float rotat, float size, float ecart, float alpha, float posx, float posy)
{		
	unsigned char arse[2000];
	memset(arse,0,2000);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);	
	glColor4f(1.0f, 1.0f, 1.0f, alpha);
	glEnable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	
	int i=0;
	int len=strlen((const char*) f);
	float moveleft=-len*0.5*ecart;
	
	while(f[i]!=0)
	{
			glLoadIdentity();
			glRotatef(rotat,0.0f,0.0f,1.0f);	
			glTranslatef(moveleft+i*ecart+posx, posy, size);
			arse[0]=f[i];
			glPrint((const char*) &arse);
		i++;
	}

			glEnable(GL_DEPTH_TEST);
			glDisable(GL_BLEND);

}