/* 256x256x32bits TEXTURE GENERATOR
 * color routines - optimized for size
 * code by dake/calodox - July 99
 */

 #include "nmldec.h"
 #include "nmlcol.h"
 #include "savehead.h"

/**************************************************************************/

 void NML_COLINVERT(uchar *source)
      {
      int i=0,c,x;

      for (x=0;x<256*256;x++)
          {
          for (c=0;c<3;c++)
              {
              source[i+c]=255-source[i+c]; 
              }
         i+=4;
        }
     }

/**************************************************************************/

  void NML_COLGREYSCALE(uchar *source)
       {
       int i=0,x,c;

       for (x=0;x<256*256;x++)
           {
           int col=source[i]+source[i+1]+source[i+2]+source[i+2];
           col>>=2;

           for (c=0;c<3;c++)
               {
               source[i+c]=col;
              }
           i+=4;
          }
        }

/**************************************************************************/

 void NML_COLCONTRAST(uchar *source, float contrast, float bright)
      {     
      int i, c, col[3], mf[3],x;
      i=0;                   /* trouve d'abord la valeur moyenne du bitmap */
 
      col[0]=col[1]=col[2]=0;

        for (x=0;x<256*256;x++)
		{
		for (c=0;c<3;c++)
			{
                        col[c]+=source[c+i];
			}
		i+=4;
		}

      col[0]>>=16;
      col[1]>>=16;
      col[2]>>=16;   //couleur moyenne

      i=0;

  	for (x=0;x<256*256;x++)
	{ 
		for (c=0;c<3;c++)
			{
                        mf[c]=source[c+i];
			mf[c]+=col[c]*bright;

			if (mf[c]<col[c]) {mf[c]-=(col[c]-mf[c])*contrast;}
			else {mf[c]+=(mf[c]-col[c])*contrast;}

			if (mf[c] < 0) mf[c]=0;
                        if (mf[c] > 255) mf[c]=255;
		
                        source[c+i]=mf[c];
			}
		i+=4;
		}
       }

/**************************************************************************/

  void NML_COLRGB(uchar *source, float rp, float gp, float bp)
       {
       int i;

       for (i=0;i<256*256*4;i+=4)
           {
           source[i]=(source[i]*bp)/256.0;
           source[i+1]=(source[i+1]*gp)/256.0;
           source[i+2]=(source[i+2]*rp)/256.0;
          }              
       }
