texture texture_0;

struct VertexInput
{
	float3 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color	: COLOR;
};

struct VertexOutput
{
	float4 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color	: COLOR;
};

VertexOutput VS_VertexTransform( VertexInput IN )
{
	VertexOutput OUT;
	OUT.position = float4( IN.position, 1.0f );
	OUT.uvCoord = IN.uvCoord;
	OUT.color	= IN.color;
	
	return OUT;
}

technique GUI
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader = NULL;
		
		texture[0] = <texture_0>;
		AddressU[0] = WRAP;
		AddressV[0] = WRAP;
		MipFilter[0] = LINEAR;
		MinFilter[0] = LINEAR;
		MagFilter[0] = LINEAR;
		
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
		
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Diffuse;
		AlphaArg2[0] = Texture;
		
		ColorVertex = true;
	}
}