#version 150
#extension GL_ARB_explicit_attrib_location : enable

//<attributes>
layout(location = 0) in vec4 inPos;
layout(location = 1) in vec4 inVelocity;
//</attributes>

uniform mat4 mvMat;

out vec3 attribs;
out vec3 velocity;

vec3 UnPackFloat(float src)
{
  return vec3(fract(src), fract(src * 256.0f), fract(src * 65536.0f));
}

void main()
{
	vec4 posOne = vec4(inPos.xyz,1.0);

	gl_Position = posOne;
	attribs = UnPackFloat(inPos.w);

	velocity = normalize(inVelocity.xyz);
}