#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Texx0;

in vertexData
{
	vec3 EyeNormal;
} v;

layout( location = 0 ) out vec4 FragColor;
layout( location = 1 ) out vec4 FragColorTwo;

uniform float zNear;
//<u>
uniform float zFar;
//</u>

float LinearizeDepth(float val)
{
  float n = zNear;
  float f = zFar;
  float z = val;
  return (2.0 * n) / (f + n - z * (f - n));	
}

void main(void)
{
	FragColor = vec4(0.5 * (v.EyeNormal + vec3(1.0)), LinearizeDepth(gl_FragCoord.z));
	FragColorTwo = vec4(vec3(1,1,1), 1.0);
}