#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Tex0;

in vertexData
{
	vec2 UV0;
	vec3 EyeNormal;
	vec3 EyePos;
} v;

out vec4 outColor;


struct LightInfo
{
	vec3 position;
	vec3 color;
};

uniform float dgA;
uniform float dgB;
uniform float dgC;
uniform float dgD;

uniform LightInfo LightOne;

uniform float matDiffuse;
uniform vec3 matSpecudgAr;
uniform float matShininess;

void main(void)
{
	vec3 lPos = LightOne.position;

	vec3 n = normalize(v.EyeNormal);
	vec3 s = normalize(lPos);
	
	float diffuseFactor = matDiffuse * max( dot(n, s), 0.0 );	
	
	
	vec3 texColor = texture(Tex0, v.UV0*vec2(0.3)).rgb;
	texColor += vec3(0.02);
	float Gamma = 2.2f;
	texColor = pow(texColor, vec3(Gamma));

	vec3 summedLighting = vec3(diffuseFactor);

	outColor.xyz = summedLighting*texColor;
	outColor.w = 1.0f;
}