#version 150
#extension GL_ARB_explicit_attrib_location : enable

//<attributes>
layout(location = 0) in vec3 inPos;
layout(location = 1) in vec2 inUV0;
layout(location = 4) in vec3 inNormal;
//</attributes>

//<u>
uniform mat4 mvpMat;
uniform mat4 mvMat;
uniform mat3 nMat;
//</u>

out vertexData
{
	vec2 UV0;
	vec3 EyeNormal;
	vec3 EyePos;
} vO;


void main(void)
{
	vO.UV0 = inUV0;
	vO.EyeNormal = normalize(nMat * inNormal).xyz;
	vO.EyePos = (mvMat * vec4(inPos,1.0)).xyz;
	gl_Position = mvpMat*vec4(inPos,1.0);
}