#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Tex0;
uniform sampler2D Tex1;
uniform sampler2D Tex2;
uniform sampler2D Tex3;

in vertexData
{
	vec2 UV0;
	vec3 EyeNormal;
	vec3 EyePos;
} v;

out vec4 outColor;


struct LightInfo
{
	vec3 position;
	vec3 color;
};

struct MaterialexxtensionCelShading
{
	float lA;
	float lB;
	float lC;
	float lD;
};

uniform LightInfo LightOne;

uniform float matDiffuse;

uniform float fadeOne;
uniform float fadeTwo;
uniform float fadeThree;

void main(void)
{
	vec3 lPos = LightOne.position;

	vec3 n = normalize(v.EyeNormal);
	vec3 s = normalize(lPos);
	
	float diffuseFactor = matDiffuse * max( dot(n, s), 0.0 );

	float visibleOne = texture2D(Tex3, v.UV0).r+(fadeTwo/1.6)-0.35;
	visibleOne = step(0.5, visibleOne);
	float visibleTwo = texture2D(Tex3, v.UV0).r+(fadeThree/3)-0.20;
	visibleTwo = step(0.5, visibleTwo);
	
	vec3 color;
	color = texture2D(Tex0, v.UV0).rgb*vec3(fadeOne);
	//color.a = texture2D(Tex0, v.UV0).a*vec3(diffuseFactor*(5.0-(fadeOne*3.0)));

	color = (texture2D(Tex1, v.UV0).rgb*visibleOne) + (color.rgb * (1-texture2D(Tex1, v.UV0).a*visibleOne));
	//color.a = (texture2D(Tex1, v.UV0).a*visibleOne) + (color.a * (1-texture2D(Tex1, v.UV0).a*visibleOne));

	color = (texture2D(Tex2, v.UV0).rgb*visibleTwo) + (color.rgb * (1-texture2D(Tex2, v.UV0).a*visibleTwo));
	//color.a = (texture2D(Tex2, v.UV0).a*visibleTwo) + (color.a * (1-texture2D(Tex2, v.UV0).a*visibleTwo));

	color.xyz += vec3(0.01);

	float Gamma = 2.2f;
	color.xyz = pow(color.xyz, vec3(Gamma));

	outColor = vec4(color,1.0);
}