/*
 * BB_PLASMA by Brian Baird
 * 
 * Very simple plasma routine, based on some old PC demo sourcecode. 
 * Done as a quick test of my cygwin/gcc setup & development path to the Dreamcast
 *
 * Uses the sintable from "Ghettoplay" by Dan Potter. 
 *
 * Feel free to reuse/laugh at this code as much as you see fit. If you do reuse any
 * of it (except for sintab.h) please give me a mention. 
 *
 * Was written expecting to be in a folder 'plasma' inside the libdream\examples folder
 *
 * contact: fenners@bairdy.com
 * URL: http://www.bairdy.com/dc
 *
 */

#include <stdio.h>
#include "dream.h"
#include "sintab.h"

#define PI 3.141592654

// let's define some screen constants, for quick changing of onscreen position

uint16 xoffset;
uint16 yoffset;

uint16 pwidth;
uint16 pheight;


// put one pixel (three components) onto the screenbuffer
// presumes format is 565

void put_pixel(int x, int y, int r, int g, int b)
{
	y += yoffset;
	x += xoffset;
	vram_s[y*320+x] = (r << 12) | (g << 5) | (b << 0);
}

// put one pixel straight into buffer

void put_pixel_raw(int x, int y, int rgb)
{
	y += yoffset;
	x += xoffset;
	vram_s[y*320+x] = rgb;
}


// variables for the plasma
unsigned char p1,p2,p3,p4,t1,t2,t3,t4;
int x,y,col,v;
int cosinus[256];


//---------------------------------
// Plasmas Stuff
//---------------------------------

void Do_Plasma(void)
{
	v=0;
	t1=p1;
	t2=p2;
	for (y=0;y<pheight;y++)
	{
		t3=p3;
		t4=p4;
		for (x=0;x<pwidth;x++)
		{
			col=cosinus[t1]+cosinus[t2]+cosinus[t3] +cosinus[t4];
			put_pixel_raw(x, y, col);
			
			v++;
			t3+=1;
			t4+=3;
		}
		t1+=2;
		t2+=1;
	}
	p1+=1;
	p2-=2;
	p3+=3;
	p4-=4;
}


void Pre_Calc(void)
{
	int i;
	
	for (i=0;i<256;i++)
	{
		
		cosinus[i]=30*(cos(i));
	}

	p1 = 50;
	p2 = 70;
	p3 = 128;
	p4 = 0;
}

uint16 update_input(void)
{
	static uint8 mcont = 0;
	cont_cond_t cond;
	
	mcont = maple_controller_addr();
	if (!mcont) {
		return 1;
	}
	
	/* Check for start on the controller */
	if (cont_get_cond(mcont, &cond)) {
		return 1;
	}
	
	return cond.buttons;
}


//------------------------------------
// Main Stuff
//------------------------------------

void dc_main()
{
	uint16 controls = 0;
	pheight = 240;
	pwidth = pheight * 4 / 3;

	xoffset = (320 - pwidth) / 2;
	yoffset = (240 - pheight) / 2;
	dc_setup(DM_320x240, PM_RGB565);
	printf("PLASMA by Brian Baird (c) 2001\r\n");
	printf("\r\n");
	printf("Visit: http://www.bairdy.com/dc\r\n\r\n");

	printf("(%dx%d) offset (%d, %d)\r\n", pwidth, pheight, xoffset, yoffset);
	Pre_Calc();
	do {
		Do_Plasma();
		sleep(1);
		controls = update_input();
	} while (controls & CONT_START);
	printf("Finished\r\n");
}

