;-------------------------------------------------------------------------------
; Decompressor
; Byte based decompressor
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
DECOMPRESS_COLOUR_BARS		equ		0


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
	org		40000


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
start
	ld		de,32768+256*2		; de=address to decompress to
	ld		hl,compresseddata	; hl=address of compressed data
	push	de					; save start address on stack

readnextcontrolbyte
IF	DECOMPRESS_COLOUR_BARS EQ 1
	ld		a,(hl)				; get control byte
	and		7
	out		(0feh),a	
ENDIF
	ld		a,(hl)				; reget control byte
	inc		hl
	or		a					; 0=end of stream
	ret		z					; return to start address ( which has been pushed onto stack )
	bit		7,a
	jr		z,copy				; 0??????? means copy
;	jr		reference			; 1??????? means reference

reference
	ld		c,a
	res		7,c					; bc=length ( b will always be 0 when we get here cos there'll always be a 'copy' as the first bit of data )
	push	hl					; save pointer to src
	push	bc					; save 16bit reference length
	ld		c,(hl)
	dec		b					; bc=16bit reference offset ( b was 0, now -1 )
	push	de
	pop		hl					; hl=src
	add		hl,bc				; hl=address of reference
	pop		bc					; bc=16bit reference length
	ldir
	pop		hl					; restore pointer to src
	inc		hl					; point src to next control byte
	jr		readnextcontrolbyte

copy
	ld		b,0
	ld		c,a
	ldir
	jr		readnextcontrolbyte


compresseddata