; 2640 -> 1011
; -------------
; -  1 k d j  -
; -------------

; config

; debug options
;DEBUG_DONT_INLINE		equ	0
;DEBUG_DONT_UNROLL		equ	0

; various buffers and addresses
PROG_START				equ	32768+256*2

; rom addresses and data registers
VBL_TABLE				equ	32768
SCREEN_BASE_PIXELS		equ 16384
SCREEN_SIZE_PIXELS		equ	2048*3
SCREEN_BASE_ATTR		equ SCREEN_BASE_PIXELS+SCREEN_SIZE_PIXELS
SCREEN_SIZE_ATTR		equ	32*24
SCREEN_SIZE				equ	SCREEN_SIZE_PIXELS+SCREEN_SIZE_ATTR
AYCTRL					equ	65533
AYDATA					equ	49149
BORDER					equ	0xfe
ROM_PR_STRING			equ	0x203c



macro MACROshowChannelUI
		xor		a
_showAllKeys
		ld		c,%010111							; decide key colour
		cp		(ix+CHAN_CURRENTPATTERN)
		jr		z,_gotKeyColour
		ld		c,%100111
		cp		(ix+CHAN_NEXTPATTERN)
		jr		z,_gotKeyColour
		ld		c,%001111
_gotKeyColour		
		ld		(hl),c								; show one key
		inc		hl
		ld		(hl),c
		inc		hl
		ld		(hl),c
		inc		hl
		inc		hl

		inc		a
		cp		4
		jr		nz,_showAllKeys

		; draw bar
		xor		a
		ld		c,%110000
		or		(ix+CHAN_MUTE)
		jr		nz,_doBar
		ld		c,%001000
_doBar	xor		a
_showBar
		cp		(ix+CHAN_VOLUME)
		jr		c,_gotBarColour
		ld		c,%000000
_gotBarColour
		ld		(hl),c
		inc		hl
		inc		a
		cp		16
		jr		nz,_showBar
endm

		org		PROG_START

start
		; ---------- start of prog
		ld		de,%011000+(7<<8)					; set up mixer
		call	outAyByte
		out		(BORDER),a							; a good opportunity to set the border to black..
		ld		h,HIGH(SCREEN_BASE_PIXELS+SCREEN_SIZE)	; ..and clear the screen
_cls	dec		hl
		ld		(hl),a
		or		(hl)
		jr		z,_cls


		; ---------- display ui text
		ld		de,textUIStart
		ld		bc,textUIEnd-textUIStart
		call	ROM_PR_STRING
		ld		hl,SCREEN_BASE_ATTR
		ld		de,SCREEN_BASE_ATTR+1
		ld		bc,32*8-1
		ld		(hl),%001111
		ldir


		; ---------- display logo
		ld		de,logobitsStart
		ld		l,LOW(SCREEN_BASE_ATTR+7)
		ld		b,logobitsEnd-logobitsStart
_oneLogoByte
		ld		a,(de)
		inc		de
		REPT	8
		rlca
		jr		c,$+4
		ld		(hl),%010010
		inc		hl
		ENDM
		djnz	_oneLogoByte


		; ---------- make freq tab
		ld		hl,freqtab
		ld		de,freqtab+12*2
		ld		b,7*12
_freqLoop
		ld		a,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		sra		a
		rr		c
		ex		de,hl
		ld		(hl),a
		inc		hl
		ld		(hl),c
		inc		hl
		ex		de,hl
		djnz	_freqLoop


		; ---------- set up the vbl
;		di
		ld		hl,0x51								; points to "ei, ret" in the rom
		ld		(VBL_TABLE-1),hl
		ld		hl,VBL_TABLE-1
		ld		de,VBL_TABLE+2-1
		ld		b,HIGH(257)
		ldir
		ld		a,HIGH(VBL_TABLE)
		ld		i,a
		im		2
;		ei



		; ---------- main loop starts here!
mainloop
		; sync
		halt

		; draw border
		ld		a,%010
		out		(254),a
		ld		bc,547
_delay1	dec		bc
		ld		a,b
		or		c
		jr		nz,_delay1
		ld		a,%001
		out		(254),a
		ld		bc,1108-547
_delay2	dec		bc
		ld		a,b
		or		c
		jr		nz,_delay2
		xor		a
		out		(254),a

		; this last delay is to prevent tearing when we update the attrs
		ld		b,HIGH(600)
_delay3	dec		bc
		ld		a,b
		or		c
		jr		nz,_delay3

		; now onto the music player..
speed	ld		a,-1								; one note tick every 4 vbls
		inc		a
		and		%11
		ld		(speed+1),a
		jr		nz,chanUpdates

tick	ld		a,-1								; increase tick
		inc		a
		and		%111111
		ld		(tick+1),a
		
		ld		hl,SCREEN_BASE_ATTR+32*23			; get ready to show tick
		ld		c,a
		sra		c
		inc		c

		add		a,a									; tick * 2
		ld		e,a									; e = tick * 2

		ld		b,32								; show tick bar
_showBeat
		dec		c
		ld		d,%010010
		jr		z,_got
		ld		d,%001001
_got	ld		(hl),d
		inc		hl
		djnz	_showBeat
		
		ld		d,b									; de = tick

		; update notes
noteUpdates
		ld		ix,channels
		ld		b,3
_allChanNotes
		push	bc
		push	de
		call	getNextNote
		ld		de,SIZE_CHAN
		add		ix,de
		pop		de
		pop		bc
		djnz	_allChanNotes

		; update channels
chanUpdates
		ld		hl,SCREEN_BASE_ATTR+32*11
		exx
		ld		ix,channels
		ld		b,3
allChanUpdates
		push	bc
		push	de
		call	updateChannel
		call	readPatternKeys
		exx
scui_1	MACROshowChannelUI							; inlined to save a couple of bytes..
scui_2	MACROshowChannelUI
		ld		de,64
		add		hl,de
		exx
		ld		de,SIZE_CHAN
		add		ix,de
		pop		de
		pop		bc
		dec		b
		jp		nz,allChanUpdates

		jp		mainloop



getNextNote
		ld		a,d
		or		e
		jr		nz,_notNewPattern
		ld		a,(ix+CHAN_NEXTPATTERN)
		ld		(ix+CHAN_CURRENTPATTERN),a

_notNewPattern
		ld		h,0									; get pattern offset in hl
		ld		l,(ix+CHAN_CURRENTPATTERN)
		add		hl,hl								; * 2
		add		hl,hl								; * 4
		add		hl,hl								; * 8
		add		hl,hl								; * 16
		add		hl,hl								; * 32
		add		hl,hl								; * 64
		add		hl,hl								; * 128
		ld		c,(ix+CHAN_PATTERNBASE+0)			; bc -> patternbase
		ld		b,(ix+CHAN_PATTERNBASE+1)
		add		hl,bc
		add		hl,de								; hl -> next instrument
		ld		a,(hl)								; a = next instrument
		or		a
		ret		z									; no new note here..
	
_getPitch
		inc		hl
		ld		b,(hl)								; get pitch
		ld		(ix+CHAN_PITCH),b					; save base pitch
		ld		(ix+CHAN_VOLUME),0					; set initial volume
_getInstrument
		ld		hl,instruments						; first instrument
		dec		a
		ld		b,a
		ld		a,50
_findInstrument										; loop to find the correct instrument
;		ld		bc,1000								; ok as long as envelopes are never longer than 255..
;		ld		c,255								; ok as long as envelopes are never longer than 255..
		ld		c,h									; ok as long as.. well.. as long as the magic holds
		cpir										; skip pitch envelope
		cpir										; skip volume envelope
		djnz	_findInstrument
		ld		(ix+CHAN_PITCHENVPTR+0),l			; set instrument pitch ptr
		ld		(ix+CHAN_PITCHENVPTR+1),h
		cpir										; skip pitch envelope
		ld		(ix+CHAN_VOLUMEENVPTR+0),l			; set instrument volume ptr
		ld		(ix+CHAN_VOLUMEENVPTR+1),h
		ret		

updateChannel
		ld		l,(ix+CHAN_PITCHENVPTR+0)			; hl -> instrument pitch ptr
		ld		h,(ix+CHAN_PITCHENVPTR+1)
		ld		b,(ix+CHAN_PITCH)
		call	_updateChannelEnvelope
		ld		(ix+CHAN_PITCHENVPTR+0),l
		ld		(ix+CHAN_PITCHENVPTR+1),h
		ld		(ix+CHAN_PITCH),a
		ld		h,0									; hl = pitch
		ld		l,a
		add		hl,hl								; *2 for correct entry
		ld		de,freqtab
		add		hl,de
		ld		a,(hl)								; get ay pitch
		inc		hl
		ld		e,(hl)
		ld		d,(ix+CHAN_AYPITCH)
		call	outAyWord							; set pitch to ay

		ld		l,(ix+CHAN_VOLUMEENVPTR+0)			; hl -> instrument volume ptr
		ld		h,(ix+CHAN_VOLUMEENVPTR+1)
		ld		b,(ix+CHAN_VOLUME)
		call	_updateChannelEnvelope
		ld		(ix+CHAN_VOLUMEENVPTR+0),l
		ld		(ix+CHAN_VOLUMEENVPTR+1),h
		ld		(ix+CHAN_VOLUME),a
		and		(ix+CHAN_MUTE)						; muted?
		ld		e,a
		ld		d,(ix+CHAN_AYVOL)
		jp		outAyByte							; set volume to ay

_updateChannelEnvelope
		ld		a,(hl)								; get next envelope instruction
		cp		50									; end?
		jr		z,_noteEnded
;		cp		51									; loop?
;		jr		nz,_normalNoteData
;
;_loopNote
;		inc		hl
;		ld		e,(hl)
;		ld		d,-1
;		add		hl,de
;		ld		a,(hl)

_normalNoteData
		inc		hl
		add		a,b
		ret
		
_noteEnded
		ld		hl,deadInstrument
;		ld		(ix+CHAN_VOLUMEENVPTR+0),l
;		ld		(ix+CHAN_VOLUMEENVPTR+1),h	
		xor		a
		ret



readPatternKeys
		ld		a,(SCREEN_BASE_ATTR+32*6+4)			; is the demo message still visible?
		cp		%001001
		jr		z,_notDemoUpdate					; no longer in demo mode..
		ld		a,(tick+1)							; update demo keys on the 52nd tick of each pattern
		cp		52
		jr		nz,_notDemoUpdate
		ld		a,(speed+1)
		or		a
		jr		nz,_notDemoUpdate
_pos	ld		a,-1								; grab next pattern
		inc		a
		cp		demoPatternsEnd-demoPatternsStart
		jr		nz,_notLooped
		xor		a
_notLooped
		ld		(_pos+1),a
		ld		h,0
		ld		l,a
		ld		de,demoPatternsStart
		add		hl,de
		ld		a,(hl)
		and		%11
		ld		(ix+CHAN_NEXTPATTERN),a

_notDemoUpdate
		ld		b,(ix+CHAN_KEYPORT)					; read the input port for the key
		ld		c,0xfe
		in		a,(c)
		ld		de,255
		bit		4,a									; check channel mutes
		jr		nz,_gotMute
		ld		e,d
_gotMute
		ld		(ix+CHAN_MUTE),e
		;ld		d,0
		ld		b,4
_readKeys
		rrca
		jr		nc,_got
		inc		d
		djnz	_readKeys
		ret											; no key pressed
_got	ld		hl,SCREEN_BASE_ATTR+32*6+4			; clear demo text when key pressed
		ld		b,24
_clear	ld		(hl),%001001
		inc		hl
		djnz	_clear

		ld		(ix+CHAN_NEXTPATTERN),d				; set next pattern
		ld		b,c
		in		a,(c)
		rrca
		ret		c
		ld		(ix+CHAN_CURRENTPATTERN),d			; set current pattern if shift pressed too
		ret


		; d = ctrl1, e = data1, a = data2
outAyWord
		call	outAyByte
		inc		d
		ld		e,a
		; d = ctrl, e = data
outAyByte
		ld		bc,AYCTRL
		out		(c),d
		ld		b,HIGH(AYDATA)
		out		(c),e
		ret



textUIStart
		db		0x10,%111,0x11,%000
		db		0x16,6,4,"DEMO - PRESS KEYS ",204,"JAM"
		db		0x16,10,0,"Lead"
		db		0x16,14,0,"Bass"
		db		0x16,18,0,"Drum"
		db		0x16,12,2,"1   2   3   4"
		db		0x16,16,2,"Q   W   E   R"
		db		0x16,20,2,"A   S   D   F"
textUIEnd


CHAN_PATTERNBASE	equ	0
CHAN_PITCHENVPTR	equ	2
CHAN_VOLUMEENVPTR	equ	4
CHAN_CURRENTPATTERN	equ	6
CHAN_NEXTPATTERN	equ	7
CHAN_PITCH			equ	8	
CHAN_VOLUME			equ	9
CHAN_MUTE			equ	10
CHAN_AYPITCH		equ	11
CHAN_AYVOL			equ	12
CHAN_KEYPORT		equ	13
SIZE_CHAN			equ	14

channels
		dw		patternLead		; pattern base
		dw		deadInstrument	; pitch envelope ptr
		dw		deadInstrument	; volume envelope ptr
		db		0				; current pattern
		db		0				; next pattern
		db		0				; base pitch
		db		0				; volume value
		db		0				; mute flag
		db		2				; ay pitch channel
		db		9				; ay volume channel
		db		0xf7			; key port

		dw		patternBass		; pattern base
		dw		deadInstrument	; pitch envelope ptr
		dw		deadInstrument	; volume envelope ptr
		db		0				; current pattern
		db		0				; next pattern
		db		0				; base pitch
		db		0				; volume value
		db		0				; mute flag
		db		0				; ay pitch channel
		db		8				; ay volume channel
		db		0xfb			; key port

		dw		patternDrums	; pattern base
		dw		deadInstrument	; pitch envelope ptr
		dw		deadInstrument	; volume envelope ptr
		db		0				; current pattern
		db		0				; next pattern
		db		0				; base pitch
		db		0				; volume value
		db		0				; mute flag
		db		4				; ay pitch channel
		db		10				; ay volume channel
		db		0xfd			; key port


instruments
deadInstrument
		db		50
		db		50
leadsiren
		db		-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,-1,0,0,0,50
		db		15,0,-8,0,0,7,0,-8,0,0,7,0,-8,0,0,7,0,-8,0,0,7,0,-8,0,0,7,0,-8,0,0,7,0,-8,50
leadarp
		db		0,+4,+3,+5,-12,+4,+3,+5,-12,+4,+3,50
		db		10,+1,+1,-1,-1,-1,-1,-1,-1,-1,-1,50
divebass
		db		-2,-2,-2,-2,-2,-2,0,0,0,0,0,0,0,0,50
		db		15,0,0,0,0,0,0,0,0,0,0,0,0,0,50
kick
		db		0,-5,-8,-8,50
		db		14,+1,-1,50
snare
		db		0,-5,0,+5,50
		db		15,-1,-1,50
closedhat
		db		0,-20,50
		db		12,-5,50
simplelead
		db		0,0,0,0,0,0,0,0,50
		db		13,+1,+1,-1,-1,-2,-2,-2,50
simpleleadbend
		db		+1,+1,+1,+1,0,0,0,0,50
		db		13,+1,+1,-1,-1,-2,-2,-2,50
simpleleadquiet
		db		0,0,0,0,0,0,0,0,50
		db		8,+1,+1,-1,-1,-2,-2,-2,50


patternLead
		; lead 1 - silent
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0

		; lead 2 - triplet thing
		db		3,36,0,0,0,0,0,0
		db		0,0,0,0,3,36,0,0
		db		0,0,0,0,0,0,0,0
		db		3,36,0,0,0,0,0,0
		db		0,0,0,0,3,36,0,0
		db		0,0,0,0,0,0,0,0
		db		3,36,0,0,0,0,0,0
		db		0,0,0,0,3,36,0,0
		db		0,0,0,0,0,0,0,0
		db		3,36,0,0,0,0,0,0
		db		0,0,0,0,3,36,0,0
		db		0,0,0,0,0,0,0,0
		db		3,36,0,0,0,0,0,0
		db		0,0,0,0,3,36,0,0
		db		0,0,0,0,0,0,0,0
		db		3,36,0,0,0,0,0,0

		; lead 3 - fill
		db		2,36,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		2,31,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		2,36,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0

		; lead 4 - melody
		db		9,44,0,0,0,0,0,0		;a-4
		db		8,46,0,0,0,0,0,0		;g
		db		8,44,0,0,0,0,8,46		;fg
		db		0,0,0,0,0,0,8,46		;g
		db		0,0,0,0,10,43-12,0,0		;e
		db		10,44-12,0,0,10,46-12,0,0		;fg
		db		10,51-12,0,0,10,48-12,0,0		;ca
		db		10,51-12,0,0,10,48-12,0,0		;ca
		db		9,47,0,0,0,0,0,0		;c-4
		db		8,50,0,0,0,0,0,0		;b
		db		8,48,0,0,0,0,8,50		;ab
		db		0,0,0,0,0,0,8,50		;b
		db		0,0,0,0,10,46-12,0,0		;g
		db		10,48-12,0,0,10,50-12,0,0		;ab
		db		10,55-12,0,0,10,51-12,0,0		;ec
		db		10,55-12,0,0,10,51-12,0,0		;ec

patternDrums
		; drums 1 - silent
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		7,80,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0

		; drums 2 - normal
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80

		; drums 3 - simple fill
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		6,40,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80

		; drums 4 - fill
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		5,40,7,80,7,80,7,80
		db		6,40,7,80,7,80,7,80
		db		7,80,7,80,5,40,7,80
		db		6,40,7,80,7,80,7,80
		db		6,40,6,40,6,40,6,40
		db		6,40,6,40,6,40,6,40
		db		6,40,0,0,0,0,0,0
		db		5,40,0,0,0,0,0,0

patternBass
		; bass 1 - silent
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0

		; bass 2 - 
		db		4,15,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0

		; bass 3 - 
		db		4,15,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		4,12,0,0,0,0,0,0
		db		0,0,0,0,4,12,0,0
		db		0,0,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,15,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		4,14,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		4,12,0,0,0,0,0,0
		db		0,0,0,0,4,12,0,0
		db		0,0,0,0,0,0,0,0

		; bass 4 - 
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		4,12,0,0,0,0,0,0
		db		0,0,0,0,4,12,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		0,0,0,0,0,0,0,0
		db		4,12,0,0,0,0,0,0
		db		0,0,0,0,4,12,0,0
		db		0,0,0,0,0,0,0,0


demoPatternsStart
		db	0,1,0
		db	0,1,0
		db	0,1,1
		db	0,1,2
		db	0,2,1
		db	0,2,1
		db	2,2,1
		db	2,2,3
		db	3,3,0
		db	3,2,1
		db	3,2,1
		db	3,0,3
		db	1,1,1
		db	1,1,1
demoPatternsEnd


logobitsStart
		db		%10111011,%11001110,%00111111,%11111111
		db		%00111010,%11010111,%10111111,%11111111
		db		%10111001,%11010111,%10111111,%11111111
		db		%10111010,%11010110,%10111111,%11111111
		db		%00011010,%11001111,%01111111
logobitsEnd


freqtab
		db	0fh,0beh									;  0    55.00  a0
		db	0eh,0dch									;  1    58.27  a#0
		db	0eh,006h									;  2    61.74  b0
		db	0dh,03dh									;  3    65.41  c0
		db	0ch,07fh									;  4    69.30  c#0
		db	0bh,0cbh									;  5    73.42  d0
		db	0bh,022h									;  6    77.78  d#0
		db	0ah,082h									;  7    82.41  e0
		db	09h,0ebh									;  8    87.31  f0
		db	09h,05ch									;  9    92.50  f#0
		db	08h,0d6h									; 10    98.00  g0
		db	08h,057h									; 11   103.83  g#0
IF 0
		; don't need the rest of the table as we can easily generate it from the first octave
		db	07h,0dfh									; 12   110.00  a1
		db	07h,06eh									; 13   116.54  a#1
		db	07h,003h									; 14   123.47  b1
		db	06h,09eh									; 15   130.81  c1
		db	06h,03fh									; 16   138.59  c#1
		db	05h,0e5h									; 17   146.83  d1
		db	05h,091h									; 18   155.56  d#1
		db	05h,041h									; 19   164.81  e1
		db	04h,0f5h									; 20   174.61  f1
		db	04h,0aeh									; 21   185.00  f#1
		db	04h,06bh									; 22   196.00  g1
		db	04h,02bh									; 23   207.65  g#1
		db	03h,0efh									; 24   220.00  a2
		db	03h,0b7h									; 25   233.08  a#2
		db	03h,081h									; 26   246.94  b2
		db	03h,04fh									; 27   261.63  c2
		db	03h,01fh									; 28   277.18  c#2
		db	02h,0f2h									; 29   293.66  d2
		db	02h,0c8h									; 30   311.13  d#2
		db	02h,0a0h									; 31   329.63  e2
		db	02h,07ah									; 32   349.23  f2
		db	02h,057h									; 33   369.99  f#2
		db	02h,035h									; 34   392.00  g2
		db	02h,015h									; 35   415.30  g#2
		db	01h,0f7h									; 36   440.00  a3
		db	01h,0dbh									; 37   466.16  a#3
		db	01h,0c0h									; 38   493.88  b3
		db	01h,0a7h									; 39   523.25  c3
		db	01h,08fh									; 40   554.37  c#3
		db	01h,079h									; 41   587.33  d3
		db	01h,064h									; 42   622.25  d#3
		db	01h,050h									; 43   659.26  e3
		db	01h,03dh									; 44   698.46  f3
		db	01h,02bh									; 45   739.99  f#3
		db	01h,01ah									; 46   783.99  g3
		db	01h,00ah									; 47   830.61  g#3
		db	00h,0fbh									; 48   880.00  a4
		db	00h,0edh									; 49   932.33  a#4
		db	00h,0e0h									; 50   987.77  b4
		db	00h,0d3h									; 51  1046.50  c4
		db	00h,0c7h									; 52  1108.73  c#4
		db	00h,0bch									; 53  1174.66  d4
		db	00h,0b2h									; 54  1244.51  d#4
		db	00h,0a8h									; 55  1318.51  e4
		db	00h,09eh									; 56  1396.91  f4
		db	00h,095h									; 57  1479.98  f#4
		db	00h,08dh									; 58  1567.98  g4
		db	00h,085h									; 59  1661.22  g#4
		db	00h,07dh									; 60  1760.00  a5
		db	00h,076h									; 61  1864.66  a#5
		db	00h,070h									; 62  1975.53  b5
		db	00h,069h									; 63  2093.00  c5
		db	00h,063h									; 64  2217.46  c#5
		db	00h,05eh									; 65  2349.32  d5
		db	00h,059h									; 66  2489.02  d#5
		db	00h,054h									; 67  2637.02  e5
		db	00h,04fh									; 68  2793.83  f5
		db	00h,04ah									; 69  2959.96  f#5
		db	00h,046h									; 70  3135.96  g5
		db	00h,042h									; 71  3322.44  g#5
		db	00h,03eh									; 72  3520.00  a6
		db	00h,03bh									; 73  3729.31  a#6
		db	00h,038h									; 74  3951.07  b6
		db	00h,034h									; 75  4186.01  c6
		db	00h,031h									; 76  4434.92  c#6
		db	00h,02fh									; 77  4698.64  d6
		db	00h,02ch									; 78  4978.03  d#6
		db	00h,02ah									; 79  5274.04  e6
		db	00h,027h									; 80  5587.65  f6
		db	00h,025h									; 81  5919.91  f#6
		db	00h,023h									; 82  6271.93  g6
		db	00h,021h									; 83  6644.88  g#6
		db	00h,01fh									; 84  7040.00  a7
		db	00h,01dh									; 85  7458.62  a#7
		db	00h,01ch									; 86  7902.13  b7
		db	00h,01ah									; 87  8372.02  c7
		db	00h,018h									; 88  8869.84  c#7
		db	00h,017h									; 89  9397.27  d7
		db	00h,016h									; 90  9956.06  d#7
		db	00h,015h									; 91  10548.08  e7
		db	00h,013h									; 92  11175.30  f7
		db	00h,012h									; 93  11839.82  f#7
		db	00h,011h									; 94  12543.85  g7
		db	00h,010h									; 95  13289.75  g#7
ENDIF

prog_end
end start
