/*
    Renderfx.c
*/


#include    "renderfx.h"
#include    "g_main.h"
#include    "m_main.h"

#include    <math.h>

void *init_null (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)1;
    }

void  doit_null (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

    }

void  exit_null (void *dat) {

    }


void *init_addcomb (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)1;

    }

void  doit_addcomb (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;
int i;

int ta,tb,tc;

    if  ((s1->x!=160)||(s2->x!=160)||(d->x!=160)) m_fatalerror("Add combine, wrong bitmapsize!");
    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("Add combinde, wrong depth!");


    for (i=0; i<160*128; i++) {

                // add and clamp
        ta=*so1+++*so2++;
        tc=tb=ta&0x40404040;
        tc>>=6;
        tb-=tc;
        *des++=(ta|tb)&0x3f3f3f3f;

        }
    }

void  exit_addcomb (void *dat) {


    }

void *init_clearbuf (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

int *tdes=(int*)s->data;
char *cdes=(char*)tdes;
int i;

        if (s->bpp==18) {
            for (i=0; i<(s->x*s->y); i++) *tdes++=0;
            }

        if (s->bpp==8) {
            for (i=0; i<(s->x*s->y); i++) *cdes++=0;
            }
    return (void*)1;

    }

void  doit_clearbuf (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

    }

void  exit_clearbuf (void *dat) {


    }


void *init_50pcomb (void *dat,cbitmap *s ,cbitmap *d ,int duration) {
    return (void*)1;

    }

void  doit_50pcomb (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;
int i;

int ta;

    if  ((s1->x!=160)||(s2->x!=160)||(d->x!=160)) m_fatalerror("50p combine, wrong bitmapsize!");
    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("50p combinde, wrong depth!");


    for (i=0; i<160*128; i++) {

        ta=(*so1+++*so2++)>>1;
        *des++=ta&0x3f3f3f3f;

        }
    }


void  exit_50pcomb (void *dat) {
    }

void *init_25pcomb (void *dat,cbitmap *s ,cbitmap *d ,int duration) {
    return (void*)1;

    }

void  doit_25pcomb (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;


int i,ta,tb;


    if  (s1->x!=s2->x) m_fatalerror("25p combine, wrong bitmapsize!");
    if  ( d->x!=s2->x) m_fatalerror("25p combine, wrong bitmapsize!");

    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("25p combinde, wrong depth!");


    for (i=0; i<s1->x*s1->y; i++) {

                // add and clamp

        ta=*so1++;
        tb=*so2+++ta;
        ta<<=1;
        tb+=ta;
        tb>>=2;
        *des++=tb&0x3f3f3f3f;

        }
    }

void  exit_25pcomb (void *dat) {
    }


void  exit_25 (void *dat) {
    }

void *init_simblur (void *dat,cbitmap *s ,cbitmap *d ,int duration) {
    return (void*)1;

    }

void  doit_simblur (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=((int*)s1->data)+s1->x;
int *des=((int*)d->data);
int i,k;

int ta,tb,tc,off;

    if  ((s1->x!=d->x)) m_fatalerror("Simpleblur wrong bitmapsize");
    if  ((s1->bpp!=18)||(d->bpp!=18)) m_fatalerror("simpleblur, wrong depth!");

    off=s1->x;

    for (i=0; i<s1->x;i++) *des++=0;

    for (i=0; i<s1->y-2; i++) {
        ta=0;
        for (k=0; k<s1->x; k++) {

              tb=*so1;
              tc=*(so1+off);

              so1++;

              *des++=((ta+tb+tc)>>2)&0x3f3f3f3f;


              ta=tb+tc;
              }

        }

    for (i=0; i<s1->x;i++) *des++=0;

    }



void  exit_simblur (void *dat) {
    }

void *init_stripeblur (void *dat,cbitmap *s ,cbitmap *d ,int duration) {
    return (void*)1;

    }

void  doit_stripeblur (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *sox=((int*)s1->data);
int *so1;
int *dex=(int*)d->data;
int *des;
int i,k;

int ta,tb,tc,off;

    if  ((s1->x!=d->x)) m_fatalerror("Stripeblur wrong bitmapsize");
    if  ((s1->bpp!=18)||(d->bpp!=18)) m_fatalerror("stripeblur, wrong depth!");


    off=s1->x;

    for (i=0; i<(s1->y-1); i++) {
        so1=sox;
        des=dex;
        sox+=s1->x;
        dex+=d->x;
        ta=0;
        for (k=0; k<s1->x;k++) {

                      // add and clamp
              tb=*so1++;
              tc=((ta+ta+ta+tb)>>2)&0x3f3f3f3f;
              *des++=tc;
              ta=tc;
              }

        so1=sox+s1->x;
        des=dex+d->x;
        ta=0;
        for (k=0; k<s1->x;k++) {

                      // add and clamp
              tb=*--des;
              tc=((ta+ta+ta+tb)>>2)&0x3f3f3f3f;

              *des=tc;

              ta=tc;
              }

        }
    }

void  exit_stripeblur (void *dat) {
    }





void *init_edgedet (void *dat,cbitmap *s ,cbitmap *d ,int duration) {
    return (void*)1;

    }

void  doit_edgedet (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=((int*)s1->data);
int *des=((int*)d->data);
int i,k;

int ta,tb,tc=0,td,te,tf;

    if  ((s1->x!=d->x)) m_fatalerror("edgedet wrong bitmapsize");
    if  ((s1->bpp!=18)||(d->bpp!=18)) m_fatalerror("edgedet, wrong depth!");


    for (i=0; i<s1->y; i++) {
        ta=0;   //-2
        tb=*so1++;   //-1
        *des++=0;

        for (k=0; k<s1->x-1; k++) {


              tc=*so1++;

              td=(ta-tc);

              te=td&0x40404040;
              tf=te>>6;
              te-=tf;
              te&=0x3f3f3f3f;
              te^=0x3f3f3f3f;

              td&=te;
              td<<=1;

              te=tf=td&0x40404040;
              te>>=6;
              tf-=te;

              *des++=td|tf;

              ta=tb;
              tb=tc;

              }

        }

    }



void  exit_edgedet (void *dat) {
    }

void *init_subcomb (void *dat,cbitmap *s ,cbitmap *d ,int duration) {


    return (void*)1;

    }

void  doit_subcomb (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;
int i;

int ta,tb,tc;

    if  ((s1->x!=160)||(s2->x!=160)||(d->x!=160)) m_fatalerror("Add combine, wrong bitmapsize!");
    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("Add combinde, wrong depth!");


    for (i=0; i<160*128; i++) {

                // add and clamp
        ta=*so1++-*so2++;

              tb=ta&0x40404040;
              tc=tb>>6;
              tb-=tc;
              tb&=0x3f3f3f3f;
              tb^=0x3f3f3f3f;
        *des++=(ta&tb);

        }
    }

void  exit_subcomb (void *dat) {


    }


void *init_subcombnc (void *dat,cbitmap *s ,cbitmap *d ,int duration) {


    return (void*)1;

    }

void  doit_subcombnc (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;
int i;

int ta;

    if  ((s1->x!=160)||(s2->x!=160)||(d->x!=160)) m_fatalerror("Add combine, wrong bitmapsize!");
    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("Add combinde, wrong depth!");


    for (i=0; i<160*128; i++) {

                // add and clamp
        ta=*so1++-*so2++;
        *des++=(ta&0x3f3f3f3f);

        }
    }

void  exit_subcombnc (void *dat) {


    }


void *init_addcombnc (void *dat,cbitmap *s ,cbitmap *d ,int duration) {


    return (void*)1;

    }

void  doit_addcombnc (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

int *so1=(int*)s1->data;
int *so2=(int*)s2->data;
int *des=(int*)d->data;
int i;

int ta;

    if  ((s1->x!=160)||(s2->x!=160)||(d->x!=160)) m_fatalerror("Add combine, wrong bitmapsize!");
    if  ((s1->bpp!=18)||(s2->bpp!=18)||(d->bpp!=18)) m_fatalerror("Add combinde, wrong depth!");


    for (i=0; i<160*128; i++) {

                // add and clamp
        ta=*so1+++*so2++;
        *des++=(ta&0x3f3f3f3f);

        }
    }

void  exit_addcombnc (void *dat) {


    }

void *init_copycon (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)dat;
    }

void  doit_copycon (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {


tCopyCon *tin;

int i,k;
int xmax,ymax;
int mods,modd;

int sx1,sy1;
int sx2,sy2;
int dx1,dy1;
int dx2,dy2;

int *tso1=(int*)s1->data;
int *tdes=(int*)d->data;

char *cso1=(char*)s1->data;
char *cdes=(char*)d->data;

int *pal;

float   t;

int ax,ay;

    t=((float)time)/((float)duration);

    tin=(tCopyCon*)in;

    ax=(int)(tin->mx1*t);
    ay=(int)(tin->my1*t);

    sx1=tin->sx1+ax;
    sy1=tin->sy1+ay;
    sx2=tin->sx2+ax;
    sy2=tin->sy2+ay;

    ax=(int)(tin->mx2*t);
    ay=(int)(tin->my2*t);

    dx1=tin->dx1+ax;
    dy1=tin->dy1+ay;
    dx2=tin->dx2+ax;
    dy2=tin->dy2+ay;

    //clipping

    if (sx1<0) {
        dx1-=sx1;
        sx1=0;
        }

    if (sy1<0) {
        dy1-=sy1;
        sy1=0;
        }

    if (dx1<0) {
        sx1-=dx1;
        dx1=0;
        }

    if (dy1<0) {
        sy1-=dy1;
        dy1=0;
        }

    if (sx2>=s1->x) sx2=s1->x-1;
    if (sy2>=s1->y) sy2=s1->y-1;

    if (dx2>=d->x) dx2=d->x-1;
    if (dy2>=d->y) dy2=d->y-1;

    if ((sx2-sx1)>(dx2-dx1)){
        xmax=(dx2-dx1)+1;
        }
    else
        {
        xmax=(sx2-sx1)+1;
            }

    if ((sy2-sy1)>(dy2-dy1)){
        ymax=(dy2-dy1)+1;
        }
    else
        {
        ymax=(sy2-sy1)+1;
            }

    if ((xmax<0)||(ymax<0)) return;

    mods=s1->x-xmax;
    modd= d->x-xmax;

    if  ((s1->bpp==18)&&(d->bpp==18)) {

    tdes+=dx1+ d->x*dy1;
    tso1+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {
                *tdes++=*tso1++;
                 }
             tdes+=modd;
             tso1+=mods;
             }
         }

    if  ((s1->bpp==8)&&(d->bpp==18)) {

    tdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;
    pal=(int*)s1->pal;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {
                *tdes++=pal[(unsigned char)*cso1++];
                 }
             tdes+=modd;
             cso1+=mods;
             }
         }

    if  ((s1->bpp==8)&&(d->bpp==8)) {

    cdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {
                *cdes++=*cso1++;
                 }
             cdes+=modd;
             cso1+=mods;
             }
         }

    if  ((s1->bpp==18)&&(d->bpp==8)) m_fatalerror("CopyCon: Truecolor to 8bit CLUT not possible");

    }

void  exit_copycon (void *dat) {

    }


void *init_copyadd (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)dat;
    }

void  doit_copyadd (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {


tCopyCon *tin;

int i,k;
int xmax,ymax;
int mods,modd;

int sx1,sy1;
int sx2,sy2;
int dx1,dy1;
int dx2,dy2;

int *tso1=(int*)s1->data;
int *tdes=(int*)d->data;

char *cso1=(char*)s1->data;
char *cdes=(char*)d->data;

int *pal;

float   t;

int ax,ay;
int ta,tb,tc;

    t=((float)time)/((float)duration);

    tin=(tCopyCon*)in;

    ax=(int)(tin->mx1*t);
    ay=(int)(tin->my1*t);

    sx1=tin->sx1+ax;
    sy1=tin->sy1+ay;
    sx2=tin->sx2+ax;
    sy2=tin->sy2+ay;

    ax=(int)(tin->mx2*t);
    ay=(int)(tin->my2*t);

    dx1=tin->dx1+ax;
    dy1=tin->dy1+ay;
    dx2=tin->dx2+ax;
    dy2=tin->dy2+ay;

    //clipping

    if (sx1<0) {
        dx1-=sx1;
        sx1=0;
        }

    if (sy1<0) {
        dy1-=sy1;
        sy1=0;
        }

    if (dx1<0) {
        sx1-=dx1;
        dx1=0;
        }

    if (dy1<0) {
        sy1-=dy1;
        dy1=0;
        }

    if (sx2>=s1->x) sx2=s1->x-1;
    if (sy2>=s1->y) sy2=s1->y-1;

    if (dx2>=d->x) dx2=d->x-1;
    if (dy2>=d->y) dy2=d->y-1;

    if ((sx2-sx1)>(dx2-dx1)){
        xmax=(dx2-dx1)+1;
        }
    else
        {
        xmax=(sx2-sx1)+1;
            }

    if ((sy2-sy1)>(dy2-dy1)){
        ymax=(dy2-dy1)+1;
        }
    else
        {
        ymax=(sy2-sy1)+1;
            }

    if ((xmax<0)||(ymax<0)) return;

    mods=s1->x-xmax;
    modd= d->x-xmax;

    if  ((s1->bpp==18)&&(d->bpp==18)) {

    tdes+=dx1+ d->x*dy1;
    tso1+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {
                ta=*tdes+*tso1++;
                tb=ta&0x40404040;
                tc=tb>>6;
                tb-=tc;
                *tdes++=(ta|tb)&0x3f3f3f3f;
                 }
             tdes+=modd;
             tso1+=mods;
             }
         }

    if  ((s1->bpp==8)&&(d->bpp==18)) {

    tdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;
    pal=(int*)s1->pal;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {

                ta=*tdes+pal[(unsigned char)*cso1++];
                tb=ta&0x40404040;
                tc=tb>>6;
                tb-=tc;
                *tdes++=(ta|tb)&0x3f3f3f3f;
                 }
             tdes+=modd;
             cso1+=mods;
             }
         }

    if  ((s1->bpp==8)&&(d->bpp==8)) {

    cdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {
                *cdes++=*cso1++;
                 }
             cdes+=modd;
             cso1+=mods;
             }
         }

    if  ((s1->bpp==18)&&(d->bpp==8)) m_fatalerror("Copyadd: Truecolor to 8bit CLUT not possible");

    }

void  exit_copyadd (void *dat) {

    }

void *init_copytrans (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)dat;
    }

void  doit_copytrans (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

tCopyTrans *tin;

int i,k;
int xmax,ymax;
int mods,modd;

int sx1,sy1;
int sx2,sy2;
int dx1,dy1;
int dx2,dy2;

int *tdes=(int*)d->data;
int pal2[256];

char *cso1=(char*)s1->data;
int *pal,*pal3;

float   t,fade;

int ax,ay;
int ta,tb,tc;

    t=((float)time)/((float)duration);

    tin=(tCopyTrans*)in;

    ax=(int)(tin->mx1*t);
    ay=(int)(tin->my1*t);

    sx1=tin->sx1+ax;
    sy1=tin->sy1+ay;
    sx2=tin->sx2+ax;
    sy2=tin->sy2+ay;

    ax=(int)(tin->mx2*t);
    ay=(int)(tin->my2*t);

    dx1=tin->dx1+ax;
    dy1=tin->dy1+ay;
    dx2=tin->dx2+ax;
    dy2=tin->dy2+ay;

    fade=tin->fade+(tin->fadeadd*t);
    fade+=tin->sinamp*(float)sin((2.0*3.14159265/1000000.0)*((float)time)*tin->sinspeed);
    fade+=tin->sinamp2*(float)sin((2.0*3.14159265/1000000.0)*((float)time)*tin->sinspeed2);
    if (fade>1) fade=1;
    if (fade<0) fade=0;


    //clipping

    if (sx1<0) {
        dx1-=sx1;
        sx1=0;
        }

    if (sy1<0) {
        dy1-=sy1;
        sy1=0;
        }

    if (dx1<0) {
        sx1-=dx1;
        dx1=0;
        }

    if (dy1<0) {
        sy1-=dy1;
        dy1=0;
        }

    if (sx2>=s1->x) sx2=s1->x-1;
    if (sy2>=s1->y) sy2=s1->y-1;

    if (dx2>=d->x) dx2=d->x-1;
    if (dy2>=d->y) dy2=d->y-1;

    if ((sx2-sx1)>(dx2-dx1)){
        xmax=(dx2-dx1)+1;
        }
    else
        {
        xmax=(sx2-sx1)+1;
            }

    if ((sy2-sy1)>(dy2-dy1)){
        ymax=(dy2-dy1)+1;
        }
    else
        {
        ymax=(sy2-sy1)+1;
            }

    if ((xmax<0)||(ymax<0)) return;

    mods=s1->x-xmax;
    modd= d->x-xmax;

    if  ((s1->bpp==18)&&(d->bpp==18)) m_fatalerror("Copytrans:TRUE to TRUE not possible");

    if  ((s1->bpp==8)&&(d->bpp==18)) {

    pal=(int*)s1->pal;
    pal3=pal2;
    if (fade!=1) {
         for (i=0;i<1024;i++)
         {
           ((char *)pal2)[i]=(char)(((float)((char *)pal)[i])*fade);
         }
    }
    else
    {
        pal3=pal;
        }

    tdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {

                ta=*tdes+pal3[(unsigned char)*cso1++];
                tb=ta&0x40404040;
                tc=tb>>6;
                tb-=tc;
                *tdes++=(ta|tb)&0x3f3f3f3f;
                 }
             tdes+=modd;
             cso1+=mods;
             }
         }


    if  ((s1->bpp==8)&&(d->bpp==8)) m_fatalerror("Copytrans: 8bit to 8bit not possible");

    if  ((s1->bpp==18)&&(d->bpp==8)) m_fatalerror("Copytrans: Truecolor to 8bit CLUT not possible");

    }

void  exit_copytrans (void *dat) {

    }


void *init_copyxfade (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)dat;
    }

void  doit_copyxfade (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

tCopyTrans *tin;

int i,k;
int xmax,ymax;
int mods,modd;

int sx1,sy1;
int sx2,sy2;
int dx1,dy1;
int dx2,dy2;

int *tdes=(int*)d->data;
int pal2[256];
int pal3[256];

char *cso1=(char*)s1->data;
char *cso2=(char*)s2->data;

float   t,fade;

int ax,ay;
int ta,tb,tc;

    t=((float)time)/((float)duration);

    tin=(tCopyTrans*)in;

    ax=(int)(tin->mx1*t);
    ay=(int)(tin->my1*t);

    sx1=tin->sx1+ax;
    sy1=tin->sy1+ay;
    sx2=tin->sx2+ax;
    sy2=tin->sy2+ay;

    ax=(int)(tin->mx2*t);
    ay=(int)(tin->my2*t);

    dx1=tin->dx1+ax;
    dy1=tin->dy1+ay;
    dx2=tin->dx2+ax;
    dy2=tin->dy2+ay;

    fade=tin->fade+(tin->fadeadd*t);
    fade+=tin->sinamp*(float)sin((2.0*3.14159265/1000000.0)*((float)time)*tin->sinspeed);
    fade+=tin->sinamp2*(float)sin((2.0*3.14159265/1000000.0)*((float)time)*tin->sinspeed2);

    if (fade>1) fade=1;
    if (fade<0) fade=0;

    if  ((s1->x!=s2->x)||(s1->y!=s2->y)) m_fatalerror("CopyXfade - both sources have to be of the same size");

    //clipping

    if (sx1<0) {
        dx1-=sx1;
        sx1=0;
        }

    if (sy1<0) {
        dy1-=sy1;
        sy1=0;
        }

    if (dx1<0) {
        sx1-=dx1;
        dx1=0;
        }

    if (dy1<0) {
        sy1-=dy1;
        dy1=0;
        }

    if (sx2>=s1->x) sx2=s1->x-1;
    if (sy2>=s1->y) sy2=s1->y-1;

    if (dx2>=d->x) dx2=d->x-1;
    if (dy2>=d->y) dy2=d->y-1;

    if ((sx2-sx1)>(dx2-dx1)){
        xmax=(dx2-dx1)+1;
        }
    else
        {
        xmax=(sx2-sx1)+1;
            }

    if ((sy2-sy1)>(dy2-dy1)){
        ymax=(dy2-dy1)+1;
        }
    else
        {
        ymax=(sy2-sy1)+1;
            }

    if ((xmax<0)||(ymax<0)) return;

    mods=s1->x-xmax;
    modd= d->x-xmax;

    if  ((s1->bpp==18)&&(d->bpp==18)) m_fatalerror("Copytrans:TRUE to TRUE not possible");

    if  ((s1->bpp==8)&&(d->bpp==18)) {

         for (i=0;i<1024;i++)
         {
           ((char *)pal2)[i]=(char)(((float)((char *)s1->pal)[i])*fade);
           ((char *)pal3)[i]=(char)(((float)((char *)s2->pal)[i])*(1-fade));
         }

    tdes+=dx1+d->x*dy1;
    cso1+=sx1+s1->x*sy1;
    cso2+=sx1+s1->x*sy1;

         for (i=0; i<ymax; i++) {
             for (k=0; k<xmax; k++) {

                ta=*tdes+pal2[(unsigned char)*cso1++]+pal3[(unsigned char)*cso2++];
                tb=ta&0x40404040;
                tc=tb>>6;
                tb-=tc;
                *tdes++=(ta|tb)&0x3f3f3f3f;
                 }
             tdes+=modd;
             cso1+=mods;
             cso2+=mods;
             }
         }


    if  ((s1->bpp==8)&&(d->bpp==8)) m_fatalerror("Copytrans: 8bit to 8bit not possible");

    if  ((s1->bpp==18)&&(d->bpp==8)) m_fatalerror("Copytrans: Truecolor to 8bit CLUT not possible");

    }

void  exit_copyxfade (void *dat) {

    }


void *init_paladjust (void *dat,cbitmap *s ,cbitmap *d ,int duration) {

    return (void*)dat;
    }

void  doit_paladjust (void *in,cbitmap *s1,cbitmap *s2,cbitmap *d,int time, int duration) {

char    *pal1=(char*)s1->origpal;
char    *pal2=(char*)s1->pal;
tPalAdjust *rt=(tPalAdjust*)in;

int i;
float   ti,fo;

unsigned short bl;
    if (s1->bpp!=8) m_fatalerror("paladjust: you may only use this with clut pics");

    ti=((float)time)/((float)duration);

    if (ti>1) ti=1;
    if (ti<0) ti=0;

    fo=rt->bright1+ti*(rt->bright2-rt->bright1);

    bl=(unsigned short)(fo*256.0);
    for (i=0; i<1024; i++) {
        pal2[i]=(unsigned char)((((unsigned char)pal1[i])*bl)>>8);
        }
    }

void  exit_paladjust (void *dat) {

    }
