/* var captures = '';
window.onclick = function(e) {
	if (e.pageX > 1270)
		document.writeln(captures);
	else
		captures += e.pageX + ',' + e.pageY + ',';
} */

document.onkeydown=function (d){
	if (d.keyCode == 32)
		document.getElementById('audio').play();
}

V = document.getElementById('V');
C = V.getContext('2d');
V.width = W = innerWidth;
V.height = H = innerHeight; 

gfx = document.createElement('canvas');
gfxC = gfx.getContext('2d');
gfx.width = 1280;
gfx.height = 699;
render(gfxC, gfx, gfx.width, gfx.height);

window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       || 
		  window.webkitRequestAnimationFrame || 
		  window.mozRequestAnimationFrame    || 
		  window.oRequestAnimationFrame      || 
		  window.msRequestAnimationFrame     || 
		  function(/* function */ callback, /* DOMElement */ element){
			window.setTimeout(callback, 1000 / 60);
		  };
})();

// The audio element
audioElement = document.getElementById('audio');

// The canvas, its context and fillstyle
ctx = C;
ctx.fillStyle = "white";

// Create new Audio Context and an audio analyzer
audioContext = new webkitAudioContext();
analyser = audioContext.createAnalyser();

// Canvas' height and width
CANVAS_HEIGHT = H;
CANVAS_WIDTH = W;
// We'll need the offset later
OFFSET = 100;
// Initialize and start drawing
// when the audio starts playing
window.onload = init;
audioElement.addEventListener('play', draw);

function init() {
  // Take input from audioElement
  source = audioContext.createMediaElementSource(audioElement);
  // Connect the stream to an analyzer
  source.connect(analyser);
  // Connect the analyzer to the speakers
  analyser.connect(audioContext.destination);
  // Start the animation
  draw();
}

function light(x, y, size, color, alpha) {
	var n = ctx.createRadialGradient(x, y, 0, x, y, size);
	n.addColorStop(0, color);
	n.addColorStop(1, 'transparent');
	ctx.fillStyle = n;
	ctx.globalAlpha = alpha;
	ctx.globalCompositeOperation = 'lighter';
	ctx.fillRect(x-size, y-size, size*2, size*2);
}

function fen(x, y, size, alpha) {
	ctx.fillStyle = 'yellow';
	ctx.globalAlpha = alpha/2;
	ctx.globalCompositeOperation = 'lighter';
	ctx.fillRect(x-size/1.3, y-size, size*2/1.3, size*2);
	
	ctx.fillStyle = 'black';
	ctx.globalAlpha = 1;
	ctx.globalCompositeOperation = 'source-over';
	ctx.fillRect(x-.5, y-size, 1, size*2);
	ctx.fillRect(x-size/1.3, y-.5, size*2/1.3, 1);
}

var noelPos = [
75,263-61,142,322-61,138,271-61,172,342-61,197,239-61,241,286-61,320,205-61,301,295-61,352,283-61,
473,338,307,392,407,286,303,364,413,262
];
var noelColors = ['red', 'green', 'blue'];
var noelCount = noelPos.length/2;

var fenPos = [
35,413,63,408,100,415,140,409,178,404,247,409,354,411,404,412,480,387,611,391,657,377,715,386,854,383,918,362,964,367,1184,363,
19,449,93,440,167,427,275,435,339,434,374,420,434,422,507,428,664,416,745,419,797,397,848,401,888,388,958,389,1044,380,1099,375,
];
var fenCount = fenPos.length/2;

var flashCount = 10;

var eiffelPos = [
514,380,520,370,533,359,553,358,566,362,575,375,530,341,532,328,536,314,563,343,559,331,557,314,541,297,549,297,546,279,546,260,546,237,546,219,545,184,
];
var eiffelCount = eiffelPos.length/2;

var lights = new Array(noelCount+fenCount+eiffelCount+flashCount);
for (var i = 0; i < lights.length; i++)
	lights[i] = -1;

var flash = 0;

function draw() {
  // See http://paulirish.com/2011/requestanimationframe-for-smart-animating/
  requestAnimFrame(draw, V);  
  // New typed array for the raw frequency data
  freqData = new Uint8Array(analyser.frequencyBinCount);
  // Put the raw frequency into the newly created array
  analyser.getByteFrequencyData(freqData);
  // Clear the canvas
ctx.save();

if (!flash)
	ctx.clearRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
flash = 0;

ctx.drawImage(gfx,0,0,W,H);

ctx.scale(W / gfx.width, H / gfx.height);

/*
var mean = 0;
for (var i = 0; i < freqData.length - OFFSET; i++) {
	var magnitude = freqData[i] / 255;
	mean += magnitude;
}
mean /= freqData.length - OFFSET;
*/

for (var i = 0; i < lights.length; i++) {
	if (lights[i] == -1) {
		var magnitude = freqData[
			Math.round(Math.random()*freqData.length)
		] / 255;
		if (magnitude > .99)
			lights[i] = 0;
	}
	if (lights[i] != -1) {
		lights[i] += .01;
		if (i >= lights.length - flashCount) {
			if (lights[i] <= .04)
				flash = 1;
		} else {
			var c = Math.pow(
				//lights[i] > 1 ? 1 - (lights[i]-1)  : lights[i]
				(2-lights[i])/2
				,4);
			var j = i*2;
			if (i < noelCount) {
				light(noelPos[j], noelPos[j+1], 10+6*(i%2), noelColors[i%noelColors.length], c);
			} else if (i < noelCount + fenCount) {
				j -= noelCount*2;
				fen(fenPos[j], fenPos[j+1]+5, j > fenPos.length / 2 ? 5 : 3, c);
			} else if (i < noelCount + fenCount + eiffelCount) {
				j -= noelCount*2 + fenCount*2;
				light(eiffelPos[j], eiffelPos[j+1], 10, 'white', c);
			}
		}
		if (lights[i] >= 2)
			lights[i] = -1;
	}
}

ctx.restore();

}
