#version 430

layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;

out vec3 position;
out vec3 normal;
out vec2 uv;
out vec3 tangent;

uniform float g_time;

uniform int g_numOld;

//in int gl_VertexID;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
void main() {
  gl_Position = modelMatrix*vec4(vertexPosition*1.0, 1.0);
  if (gl_VertexID >= g_numOld) {
    position = (modelMatrix*vec4(vertexPosition, 1.0)).xyz;
  } else {
    position = vertexPosition;
  }
  normal = vertexNormal; // (modelMatrix*vec4(vertexNormal, 0.0)).xyz;
  tangent = vertexTangent; // (modelMatrix*vec4(vertexTangent, 0.0)).xyz;
  uv = vertexUV;
}
