import QtQuick 2.3
import QtQuick.Window 2.2

import SystemTime 1.0

import Qt.labs.settings 1.0

import AdaptDemoSystem 1.0

DemoRoot {
    id: root
    visible: true
    width: windowWidth
    height: windowHeight

    onWindowPosXChanged: {
        console.log("wpx:"+windowPosX)
    }
    onWindowWidthChanged: {
        console.log("wpw:"+windowWidth)
    }

    signal demoLoaded();

    focus: true

    property bool bExitDemo: true
    property real exitDemoTime: 133.0
    property bool bReleaseVer: true

    property bool bEnableCoordsAxis: true
    property bool bEnableCoordsPlaneXY: true
    property bool bEnableCoordsPlaneXZ: true
    property bool bEnableCoordsPlaneYZ: true

    signal keyLeft()
    signal keyRight()
    signal keyUp()
    signal keyDown()

    signal keyR()
    signal keyC()

    signal keyPressed(int keyCode, bool autoRepeat)
    signal keyReleased(int keyCode)

    signal mouseMove(int mouseX, int mouseY)
    signal mousePress(int mouseX, int mouseY)
    signal mouseRelease(int mouseX, int mouseY)

    signal showEditor()

    signal customTextGroupShowToggled(string groupId)
    function toggleCustomTextGroupShow(groupId) {
        customTextGroupShowToggled(groupId)
        console.log("toggleCustomTextGroupShow", groupId);
    }

    signal customTextSet(string groupId, string textId, string customText)
    function setCustomText(groupId, textId, customText) {
        customTextSet(groupId, textId, customText);
    }

//    onActiveFocusChanged: {
//        if (activeFocus) {
//            console.log("Demo window got the focus");
//            root.setEditViewAsForegroundWindow();
//        }
//    }

    Window {
        id: infoWindow
        width: 600
        height: 400
        title: "Adapt demosystem usage instructions (toggle with F1)"
        visible: false
        property bool lowered: true
        Text {
            anchors.margins: 20
            anchors.fill: parent
            wrapMode: Text.WordWrap
            textFormat: Text.StyledText
            text: "
<h2>Fly camera usage</h2>
<p>The fly camera can be enabled by using FlyCamera {} inside the Scene QML instead of plain Camera {}.
</p>
<h3>Keys</h3>
<b>UP/DOWN arrows</b>: camera front/back movement<br>
<b>LEFT/RIGHT arrows</b>: camera left/right movement<br>
<b>SHIFT + LEFT/RIGHT arrows</b>: camera roll along camera Z-axis<br>
<b>SHIFT + UP/DOWN arrows</b>: camera move up/down<br>
<b>U:</b> Toggle camera UP preserve setting<br>
<b>R:</b> Synchronize camera to the current rocket row<br>
<b>C:</b> Clear camera modifications by going back to current rocket values<br>
<h3>Mouse</h3>
<b>Mouse press+move:</b> Turn camera<br>
"
        }

        onVisibleChanged: {
            if (visible) {
                ikkunaFocus.forceActiveFocus();
            } else {
                lowered = true;
            }
        }

        FocusScope {
            id: ikkunaFocus
            Keys.onPressed: {
                if (event.key === Qt.Key_F1) {
                    infoWindow.visible = false;
                }
            }
        }
    }

//    Window {
//        id: skeneEditorWindow
//        title: "Skene editor"
//        x: 10
//        y: 24
//        width: 1024
//        height: 720
//        visible: true

//        Settings {
//            property alias x: skeneEditorWindow.x
//            property alias y: skeneEditorWindow.y
//            property alias width: skeneEditorWindow.width
//            property alias height: skeneEditorWindow.height

//            property alias skeneFileName: editor.skeneFileName
//            property alias skeneFilePath: editor.skeneFilePath
//            property alias bSkeneFileNameSet: editor.bSkeneFileNameSet

//            property alias prevSkeneFolder: editor.prevSkeneFolder
//            property alias prevImageFolder: editor.prevImageFolder
//            property alias prevGenericFolder: editor.prevGenericFolder
//            property alias prevShaderFolder: editor.prevShaderFolder
//        }
//        SkeneEditor {
//            id: editor
//            anchors.fill: parent
//        }
//    }

    Rocket {
        id: rocket
    }

    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }



    //    Item {
    //        id: loaderImage
    //        anchors.fill: parent
    //        Rectangle {
    //            anchors.fill: parent
    //            color: "orange"
    //        }
    //        Image {
    //            fillMode: Image.PreserveAspectFit
    //            anchors.fill:parent
    //            source: "../images/loader.png"
    //        }
    ////        Rectangle {
    ////            anchors.centerIn: parent
    ////            opacity: 1.0
    ////            radius: 5
    ////            width: 50
    ////            height: 10
    ////            color: "white"
    ////            rotation: time*20.0
    ////        }

    //    }

    //            Rectangle {
    //                opacity: 0.0
    //                radius: 5
    //                width: 10
    //                height: 10
    //                color: "black"
    //                rotation: time
    //            }

    //    property int huppa: 0

    //    Timer {
    //        interval: 20
    //        repeat: true
    //        running: true
    //        onTriggered: {
    //            huppa+=1;
    //        }
    //    }

    //    Image {
    //        anchors.centerIn: parent
    //        rotation: huppa*10
    //        source: "../images/stars2_blue.png"
    //    }


    Timer {
        interval: 200
        repeat: false
        running: true
        onTriggered: {
            //demoLoader.sourceComponent = demo
            demoLoader.source = "Skenes.qml"
            //  reloadDemo();
        }
    }

    Timer {
        id: delayedSetDemoLoaderSource
        interval: 200
        running: false
        repeat: false
        onTriggered: {
            demoLoader.source = "Skenes.qml";
            //reloadDemo();
        }
    }

    Connections {
        target: demoLoader.item
        onFileMissing: {
            console.log("QML received file not found:"+fName+" skene:"+sName);
        }
    }



    Timer {
        interval: 200
        repeat: true
        running: true
        onTriggered: {
            if (rocket.getTime() > exitDemoTime && (rocket.getTime() > 0.0) && (rocket.getTime() < 10000.0) && bExitDemo) {
                rocket.exitDemo();
            }
        }
    }

    property bool demoIsLoaded: false

    Loader {
        id: demoLoader
        anchors.fill: parent
        asynchronous: true
        onStatusChanged: {
            if (demoLoader.status === Loader.Ready) {
                console.log("xxxxxxxxxxxxxxx DEMO LOADER is ready xxxxxxxxxxxxxxxx")
               // loaderImage.visible = false;
                rocket.markDemoLoaded();
                demoLoaded();
                demoIsLoaded = true;

            }
        }
    }

    Connections {
        target: demoLoader.item
        onFrameRender: {
            if (demoIsLoaded) {
                loaderImage.visible = false;
            }
        }
    }


    Item {
        id: loaderImage
        anchors.fill: parent

        onVisibleChanged: {
            if (!visible) {
                console.log("Demo loader image hidden");
            }
        }

        Image {
            anchors.fill: parent
            //source: "../images/adapt_logo2_full.png"
            source: "../images/loader.png"
        }

//        Text {
//            //text: "Loading, hold your horseshoes...."
//            text: "Loading, please wait a momentos...."
//            font.pixelSize: 20
//            anchors.centerIn: parent
//            anchors.verticalCenterOffset: 200
//            color: "grey"
//        }

    }

//    Connections {
//        target: demo
//        onAckFirstDemoRender: {
//            console.log("AKU ANKKA");
//        }
//    }

    Keys.onEscapePressed: {
        console.log("esc esc")
        rocket.exitDemo();
    }

    property bool ctrlPressed: false
    property int mX: 0
    property int mY: 0

    MouseArea {
        anchors.fill: parent
        hoverEnabled: true
        propagateComposedEvents: true
        onMouseXChanged: {
            mX = mouseX;
            mY = mouseY;
            mouseMove(mouseX, mouseY);
            //console.log("main mouse at:"+mouseX+","+mouseY)
        }
        onMouseYChanged: {
            mX = mouseX;
            mY = mouseY;
            mouseMove(mouseX, mouseY);
            //console.log("main mouse at:"+mouseX+","+mouseY)
        }
        onPressedChanged: {
            if (bReleaseVer) {
                return;
            }

            if (pressed) {
                mousePress(mX, mY);
            } else {
                mouseRelease(mX, mY);
            }
        }
    }

    Keys.onReleased: {
        keyReleased(event.key);
        if (event.key === 16777249) { // Ctrl
            ctrlPressed = false;
        }
    }

    Keys.onPressed: {
       //  console.log("event.key:"+event.key)
        if (bReleaseVer) {
            return;
        }

        keyPressed(event.key, event.isAutoRepeat);

        if (event.key === Qt.Key_E) {
            showEditor();
        }

        if (event.key === 16777268) { // F5
            //console.log("jorma");
            // demoLoader.sourceComponent = undefined;
            demoLoader.source = "";
            rocket.reload();
            delayedSetDemoLoaderSource.start();

            //   demoLoader.sourceComponent = demo
        }
        if (event.key === 16777249) { // Ctrl
            ctrlPressed = true;
        }
        if (event.key === 82 && ctrlPressed) { // R
            rocket.reloadParticles();
        }

        if (event.key === 32) { // space
            // BUG: Pausing the actual demo window works bugged so that demo keeps
            // rolling over couple of rows even if paused.
            // Thus this is now disabled until fixed... 2016/7/22
//            if (rocket.getIsPaused()) {
//                rocket.setPause(false);
//            } else {
//                rocket.setPause(true);
//            }
        }

        if (event.key === 88) { // X
            bEnableCoordsPlaneYZ = !bEnableCoordsPlaneYZ;
        }
        if (event.key === 89) { // Y
            bEnableCoordsPlaneXZ = !bEnableCoordsPlaneXZ;
        }
        if (event.key === 90) { // Z
            bEnableCoordsPlaneXY = !bEnableCoordsPlaneXY;
        }
        if (event.key === 65) { // A
            bEnableCoordsAxis = !bEnableCoordsAxis;
        }

        if (event.key === 83) { // S
            // demoLoader.sourceComponent = demo
            // demoLoader.source = "Skenes.qml"
        }
        //        if (event.key === 84) { // T
        //             // demoLoader.sourceComponent = demo
        //            // demoLoader.source = "Skenes.qml"
        //            demoLoader.item.bDebugTexts = false;
        //            console.log("pressed")
        //        }

        if (event.key === Qt.Key_Left) {
            keyLeft();
        }
        if (event.key === Qt.Key_Right) {
            keyRight()
        }
        if (event.key === Qt.Key_Up) {
            keyUp();
        }
        if (event.key === Qt.Key_Down) {
            keyDown();
        }
        if (event.key === 82) { // R
            keyR();
        }
        if (event.key === 67) { // C
            keyC();
        }

        if (event.key === Qt.Key_F1) {
            if (infoWindow.lowered) {
                infoWindow.showNormal();
                infoWindow.requestActivate();
                infoWindow.lowered = false;
            } else {
                infoWindow.visible = false;
                infoWindow.lowered = true;
            }
        }
    }

}
