import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Group {
        //setup default textures
        TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
        TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
        Texture { textureUnit: 3; textureRT: "prev" }
        Texture { textureUnit: 4; textureRT: "prevBlur" }
        Texture { textureUnit: 5; textureRT: "prevNormal" }
    }

    // clear RGB & Z here so we are sure it happens at least once properly...
    DrawMesh {
        file: "mesh/tri.lwo"; Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0; }
        Sca { s: 0.0; }
    }

    BreakMesh {
        name: "box"
    }

    BreakMesh {
        name: "box2"
    }

    Blit { textureRT: "depth"; blitRT: 1}

    PrevBlur {
        id: pb
        Connections {
            function clamp(v) {
                return Math.max(Math.min(v, 1.0), -1.0);
            }
            property real prevTi: 0.0
            target: demo; onFrameRendered: {
                var camAutoEnabled = sync("camera.autoMove.ON");
                var ti = demoTime();
                var deltaTime = (ti-prevTi);
                prevTi = ti;
                if (camAutoEnabled && deltaTime > 0.0) {
                    flyCam.camOfs.x += (-pb.getAvgPosX())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accX")), rocket.timeStepReal/16.67);
                    flyCam.camOfs.y += (-pb.getAvgPosY())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accY")), rocket.timeStepReal/16.67);
                    flyCam.camOfs.z += (-pb.getAvgPosZ())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accZ")), rocket.timeStepReal/16.67);
                }
                var k = Math.pow(0.95, rocket.timeStepReal/16.67);
                flyCam.camOfs.x *= k;
                flyCam.camOfs.y *= k;
                flyCam.camOfs.z *= k;

                // console.log("x:"+pb.getAvgPosX(), "y:"+pb.getAvgPosY(), "z:"+pb.getAvgPosZ());
            }
        }
    }


    // postprocs
    Reflect { }


    Tonemap { }
    Glow { }

    Overlay { name: "ovl0" }
    Overlay { name: "ovl1" }
    Overlay { name: "ovl2" }


    Blit { textureRT: "prev" }
    Vignette { }

    Overlay { name: "ovlFin0" }
    Overlay { name: "ovlFin1" }
    Overlay { name: "ovlFin2" }


    Coords { }
}
