#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
layout (location=4) in float vertexBright;
layout (location=5) in vec3 vertexOrigCenter;
layout (location=6) in vec3 vertexBranchInfo;

out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;
out float bright;
out vec3 origCenter;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float g_bright = 1.0;
uniform float g_uvScale = 1.0;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}



void main() {
  gl_Position = vec4(vertexPosition*0.20, 1.0);

 // gl_Position.y = abs(gl_Position.y);

  vec4 posse = gl_Position*1.0;


  origPos = posse*1.0;

  float timeMul = 0.10;

 
  float times = g_time*0.1*timeMul;
  float times2 = g_time*0.2*timeMul;
  float times3 = g_time*timeMul;

  normal = vertexNormal;
  tangent = vertexTangent;
 // gl_Position.xyz += normal*1.0*(1.0+sin(posse.y*0.4+g_time*3.4));


  float makkara = 0.0*clamp(0.50+1.50*sin(times3*0.4), 0.0, 1.0);

  makkara = 0.0;

  float yk = 1.0;




  vec4 pos1 = rotateXZ(gl_Position, -times3*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
  vec4 pos2 = rotateXZ(gl_Position, -(times3+0.1)*0.20+yk*posse.y*sin(times2+0.02)+0.0*posse.z);

  origPos = pos2-pos1;
/*
  gl_Position = rotateXZ(gl_Position, -g_time*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
  gl_Position.xz *= mix(0.10, 1.0, makkara);
  gl_Position.y *= (1.0+makkara*1.0);
  normal = rotateXZ3(normal, -g_time*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
  tangent = rotateXZ3(tangent, -g_time*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
*/
//  gl_Position.xz *= 1.0+sin(cos(posse.y+g_time*2.0)+g_time*9.2)*0.02;

 // normal = (modelViewMatrix * vec4(normal, 0.0)).xyz;

    vec4 posNR = gl_Position;

    float mk = 1.0;
   gl_Position.y *= 1.0;
   gl_Position.xz *= 1.0;
   /*
   gl_Position = rotateXY(gl_Position, times3*0.0+mk*posse.y*(cos(times)))+0.10*rotateYZ(gl_Position, 0.01*posse.y*(cos(times)));
   normal = rotateXY3(normal, times3*0.0+mk*posse.y*(cos(times)))+0.10*rotateYZ3(normal, 0.01*posse.y*(cos(times)));
   tangent = rotateXY3(tangent, times3*0.0+mk*posse.y*(cos(times)))+0.10*rotateYZ3(tangent, 0.01*posse.y*(cos(times)));
*/
   //   gl_Position = 2.0*rotateYZ(gl_Position, 0.0030*posse.y*(cos(times)));
  // normal = rotateXZ3(normal, -times3*0.20+yk*posse.y*sin(times2)+0.0*posse.z);
  // tangent = rotateXZ3(tangent, -times3*0.20+yk*posse.y*sin(times2)+0.0*posse.z);


   // bright = vertexUV.x+g_bright;// vertexBright;
   bright = vertexBright+g_bright;// vertexBright;

   origCenter = vertexOrigCenter;

   gl_Position = mix(posNR, gl_Position, makkara);


  uv = vertexUV;

}
