#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
layout (location=4) in vec3 vertexOrigCenter;
layout (location=5) in vec4 vertexGenInfo;
layout (location=6) in vec4 vertexEmitInfo;
layout (location=7) in vec4 vertexBranchInfo;

out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;
out vec3 origCenter;
out vec4 genInfo;
out vec4 emitInfo;
out vec4 branchInfo;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float g_bright = 1.0;
uniform float g_uvScale = 1.0;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}



void main() {
  gl_Position = vec4(vertexPosition*1.0, 1.0);
  origPos = gl_Position;
  normal = vertexNormal;
  tangent = vertexTangent;
  vec4 posNR = gl_Position;
  genInfo = vertexGenInfo;
  genInfo.x = genInfo.x+g_bright;// vertexBright;

  origCenter = vertexOrigCenter;

  branchInfo = vertexBranchInfo;
  emitInfo = vertexEmitInfo;

  uv = vertexUV;

}
