#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 12) out;

in vec3 position[3];
in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in float bright[3];
in vec3 origCenter[3];
in vec4 branchInfo[3];

out vec3 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 tangentG;
out float brightG;
out vec3 origCenterG;
out vec4 branchInfoG; // x: age, y: 0.0 = main branch, > 1.0 side branch, z: number of replicas done


uniform float g_time;
uniform float g_timeStep;
uniform float g_emit = 1.0;

uniform float windowWidth;
uniform float windowHeight;

uniform float g_discardEdgeLen = 50.0;
uniform float g_branchEveryN = 30.0;
uniform float g_branchMax = 6.0;
uniform float g_maxLevel = 3.0;
uniform float g_maxAge = 10.0;
uniform float g_branchMoveFreq = 1.0;
uniform float g_branchMoveFreqVar = 1.0;
uniform float g_branchGrowScale = 1.002;
uniform float g_branchGrowScaleVar = 0.0;
uniform float g_branchGrowScaleVarFreq = 1.0;
uniform float g_branchGrowScaleVarPhase = 0.0;

uniform float g_branchMove = 0.08;
uniform float g_branchMovePerLevel = -0.005;

uniform float g_branchMoveOfs = 0.10;
uniform float g_branchMoveOfsPerLevel = -0.003;

uniform float g_branchScalePerLevel = 0.5;

uniform float g_branchRot1=1.0;
uniform float g_branchRot2=1.0;
uniform float g_branchRot1Level=0.30;
uniform float g_branchRot2Level=0.30;

uniform float g_maxDist = 100.0;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;



layout(binding=0) uniform sampler2D tex;

float atanSafe(float y, float x) {
    float ret=0.0;
    if (x!=0.0) {
        if (x>0.0) {
            ret=atan(y/x);
        } else	{
            ret=atan(y/x)+3.141592;
        }
    } else {
        if (y>=0.0) {
            ret=0.5*3.141592;
        } else {
            ret=-0.5*3.141592;
        }
    }
    return ret;
}

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

vec3 movePos(vec3 p, vec3 oc, float branchType, float dt) {
    vec3 moveDir;
    float fre;

    float t= g_time+dt;

    if (branchType < 0.5) {
        moveDir = vec3(0.0, g_branchMove*sin(t*0.5*g_branchMoveFreq)+g_branchMoveOfs, 0.0)*pow(1.3, g_timeStep/0.05);
        fre = (0.15+g_branchMoveFreqVar*0.1*sin(dt+4.7*g_branchMoveFreq*cos(t)))*g_branchMoveFreq;
        moveDir.yxz = rotateXZ3(moveDir.yxz, (0.40+oc.y*0.03)*sin(oc.y*2.0*fre+t)*g_branchRot1);
        moveDir.zyx = rotateXZ3(moveDir.xyz, (0.40+oc.y*0.03)*cos(oc.x*1.50*fre+oc.z*fre)*g_branchRot2);
    } else {
        moveDir = vec3(0.0, (g_branchMove+g_branchMovePerLevel*branchType)*sin(t*0.5*2.0*branchType*g_branchMoveFreq)+g_branchMoveOfs+g_branchMoveOfsPerLevel*branchType, 0.0)*pow(1.3, g_timeStep/0.05);
        fre = (0.15+g_branchMoveFreqVar*0.1*sin(t+4.7*cos(t*2.0*branchType*g_branchMoveFreq)))*g_branchMoveFreq;
        moveDir.yxz = rotateXZ3(moveDir.yxz, (0.40+oc.y*0.03)*sin(oc.y*(2.0+branchType)*fre+t)*(g_branchRot1+branchType*g_branchRot1Level));
        moveDir.zyx = rotateXZ3(moveDir.xyz, (0.40+oc.y*0.03)*cos(oc.x*(1.50+branchType)*fre+oc.z*fre)*(g_branchRot2+branchType*g_branchRot2Level));

    }
    p += moveDir;

    return p;
}

vec3 getDir(vec3 p, vec3 oc, float branchType) {
    vec3 p0 = movePos(p, oc, branchType, 0.0);
    vec3 p1 = movePos(p, oc, branchType, 0.01);

    return normalize(p1-p0);
}

vec3 rotPos(vec3 p, vec3 oc, vec4 bi, vec3 di, vec3 ta) {
//    float d = sqrt(dot(p, p));
    //d = abs(oc.x)*10.0;
  //  p-=oc;


//    p.x*=pow(1.0+0.05*(g_zoomAmount-1.0)/0.07, g_timeStep/0.05);
//    p.y*=pow(1.0-0.01*(g_zoomAmount-1.0)/0.07, g_timeStep/0.05);
//    p.z*=pow(1.0-0.01*(g_zoomAmount-1.0)/0.07, g_timeStep/0.05);
//  //  p+=oc;
//    p = rotateXZ3(p.xzy, (g_zoomAmount-1.0)/0.07*g_timeStep*15.50*sin(d*0.01)).xzy;
   // p = rotateXZ3(p.xyz, g_timeStep*0.250*sin(d*0.15)).xyz;

    ta = normalize(ta);

    float dotsi = dot(normalize(di), vec3(0.0, 0.0, 1.0));
    float ang = acos(dotsi)+3.14;

 //   ang = round(ang)*3.141592*0.25;
 //   ta = normalize(round(ta*1.5));

    float growScale = g_branchGrowScale+g_branchGrowScaleVar*sin(bi.x*g_branchGrowScaleVarFreq+bi.x+g_branchGrowScaleVarPhase);

    p *= pow(growScale, g_timeStep/0.05);

//   p = rotateXZ3(p, bi.w*0.01);
   p = rotAroundAxis(p, ta, ang);

    return p;
}


void main(void) {

    float dgl = g_discardEdgeLen*g_discardEdgeLen;
    vec3 dd = position[1]-position[0];
    if (dot(dd,dd) > dgl) {
        return;
    }
    dd = position[2]-position[0];
    if (dot(dd,dd) > dgl) {
        return;
    }
    dd = position[2]-position[1];
    if (dot(dd,dd) > dgl) {
        return;
    }

    float branchType = branchInfo[0].y;
    float replicas = branchInfo[0].z;
    float age = branchInfo[0].x;
    float branchCounter = branchInfo[0].w;

    if (age>g_maxAge) {
        return;
    }


//    vec4 pos4 = vec4(position[0], 1.0);
//    mat4 mvp = projectionMatrix * modelViewMatrix;
//    vec4 posScreen = mvp*pos4;
//    vec2 scrTexPos = posScreen.xy/posScreen.w*0.5+vec2(0.5, 0.5);
//    if (!(scrTexPos.x>=0.0 && scrTexPos.y>=0.0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
//      return;
//    }


    float doBranch = 0.0;

    branchCounter = branchCounter + 1.0;
    float bc = fract(branchCounter/1000.0)*1000.0;
    float branchesDone = floor(branchCounter/1000.0);
    if (bc > g_branchEveryN && branchType < g_maxLevel && branchesDone < (g_branchMax-branchType)) {
        doBranch = 1.0;
        branchCounter = branchesDone*1000.0+1000.0; // with every branch we increase this by 1000.0 which tracks the total number of branches
    }

    for (int i = 0; i < gl_in.length(); ++i) {
        gl_Position = gl_in[i].gl_Position;
        posG = position[i];
        origCenterG = origCenter[i];

        float d = g_maxDist;
        if (dot(posG, posG) > d*d) {
            return;
        }
        normalG = normal[i];
        uvG = uv[i];
        tangentG = tangent[i];
        brightG = bright[i];
        branchInfoG = branchInfo[i];

        // increase the replicas counter
        //if (replicas < 0.5) {
            branchInfoG.z = replicas + 1.0;
        //}


        branchInfoG.w = branchCounter;

        // increase the age counter
       // branchInfoG.x = age + g_timeStep;

       // }
        EmitVertex();
    }

    EndPrimitive();

    if (g_timeStep > 0.0) {
        // replicate the one in the end which is not yet replicated!
        if (replicas < 0.5 && ((branchType < g_maxLevel) || (branchType >= g_maxLevel && bc < 100))) {
            for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position;
                posG = position[i];
                origCenterG = origCenter[i];

                vec3 dir = getDir(origCenterG, origCenterG, branchInfoG.y);
                vec3 tang = cross(dir, vec3(0.0, 0.0, 1.0))*1.0;

                posG = movePos(posG, origCenterG, branchInfoG.y, 0.0);
                origCenterG = movePos(origCenterG, origCenterG, branchInfoG.y, 0.0);

                posG = rotPos(posG-origCenterG, origCenterG, branchInfoG, dir, tang)+origCenterG;
                normalG = normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                brightG = bright[i];
                branchInfoG.z = 0.0;
                branchInfoG.x = branchInfo[i].x+g_timeStep;
                EmitVertex();
            }
            EndPrimitive();


            if (doBranch > 0.5) {
                branchInfoG.x = branchInfo[0].x+g_timeStep;

                branchInfoG.y = branchInfoG.y+1.0;
                branchInfoG.z = 0.0;
              //  branchInfoG.w = 0.0;

                for (int i = 0; i < gl_in.length(); ++i) {
                    gl_Position = gl_in[i].gl_Position;
                    posG = position[i];
                    origCenterG = origCenter[i];

                    vec3 dir = getDir(origCenterG, origCenterG, branchInfoG.y);

                 //   posG = movePos(posG, origCenterG, branchInfoG.y, 0.0);
                 //   origCenterG = movePos(origCenterG, origCenterG, branchInfoG.y, 0.0);

                    vec3 per = posG-origCenterG;
                    per *= g_branchScalePerLevel;
                    per += origCenterG;

                    vec3 tang = cross(dir, vec3(0.0, 1.0, 0.0));
                    posG = per+tang;
                    origCenterG = origCenterG+tang;

                    normalG = normal[i];
                    uvG = uv[i];
                    tangentG = tangent[i];
                    brightG = bright[i];
                    //
                    EmitVertex();
                }
                EndPrimitive();
            }
        }
    }
}
