import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property alias simShaderParams: simPar.delegate
    property string drawShader: "partWater"
    property alias drawShaderParams: drawPar.delegate
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true
    property bool drawDepthEnabled: true

//    property string texture0: "../../images/particles_64_2048.png"

    property real partSize: 0.50

//    property string texture2: "../../images/adapt_logo2_full.png"

    property int particleCount: advanceSim.particleCount


    onParticleCountChanged: {
        root.setCustomText(name, name+": particle count", "Particle count:"+particleCount);
    }

    signal particleCountTo(int pc)

    Blit {
        textureRT: "screenBuffer"
    }

//    Texture {
//        textureUnit: 0
//        textureItem: particleTexture
//        Image {
//            id: particleTexture
//            source: texture0
//        }
//    }

    property alias tex0: t0.delegate
    Repeater { id: t0; model: 1 }

//    property alias tex1: t1.delegate
//    Repeater { id: t1; model: 1 }

   Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/random16.png"
        }
    }

   property alias tex2: t2.delegate
   Repeater { id: t2; model: 1 }


//    Texture {
//        textureUnit: 2
//        textureItem: particleAgeSwipe
//        Image {
//            id: particleAgeSwipe
//            visible: false
//            source: texture2

//        }
//    }

    Texture {
        textureUnit: 3
        textureRT: "depth" // world space normal in rgb components
    }


    Texture {
        textureUnit: 4
        textureRT: "mainDepth"
    }

    //    Texture {
    //        textureUnit: 2
    //        textureRT: "screenBuffer"
    //    }

//    Texture {
//        textureUnit: 3
//        textureItem: particleEnv
//        Image {
//            id: particleEnv
//            visible: false
//            source: "../../images/Bright-roof-multi.jpg"
//        }
//    }


    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;
        vec4 posInitG;"
       // vec3 posScrG;"


    Shader {
        file: sceneDir+simShader
        tfVaryings: shaderVaryings
    }


    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+partSim.name

        property real resetOn: sync(partSim.name+".reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
         //   console.log("jorma particle count:"+particleCount);
            particleCountTo(particleCount);
        }


        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_gridDim"
            paramValue: partSim.gridDimension
        }
//        ShaderParam {
//            paramName: "g_rotOrigin"
//            paramValue: sync(partSim.name+".rotOrigin")
//        }

        ShaderParam {
            paramName: "g_velDamping"
            paramValue: sync(partSim.name+".velDamping")
        }

//        ShaderParam {
//            paramName: "g_emitShape"
//            paramValue: sync(partSim.name+".emitShape")
//        }

        ShaderParam {
            paramName: "g_noiseScale"
            paramValueVec4: sync(partSim.forceName+".noiseScale.x")+","+sync(partSim.forceName+".noiseScale.y")+","+sync(partSim.forceName+".noiseScale.z")
        }
        ShaderParam {
            paramName: "g_noiseOfs"
            paramValueVec4: sync(partSim.name+".dirForce.x")+","+sync(partSim.name+".dirForce.y")+","+sync(partSim.name+".dirForce.z")
        }

        ShaderParam {
            paramName: "g_force"
            paramValue: sync(partSim.forceName+".force")
        }
        ShaderParam {
            paramName: "g_noiseFreq"
            paramValue: sync(partSim.forceName+".noiseFreq")
        }
        ShaderParam {
            paramName: "g_speed"
            paramValue: sync(partSim.forceName+".speed")
        }
        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".elasticity") }

        // inject custom shader params
        Repeater { id: simPar; model: 1 }

    }


    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: false

       // blendMode: "normal"
        blendMode: drawBlendMode
       // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }

        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }


        ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".scale") }


        // inject custom shader params
        Repeater { id: drawPar; model: 1 }

        drawBuffers: 2
    }

    Shader {
        file: sceneDir+"partDepthOnly"
    }
    DrawVB { // depth only draw
        enabled: drawDepthEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: true
       // blendMode: "normal"
        blendMode: "add"
       // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }

}
