import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: godray
    name: "godray"
    effectName: "GodRay"
    enabled: sync(godray.name+".ON")


    property real godRayX: 0.0
    property real godRayY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }
    Shader {
        file: "godray"
        ShaderParam {
            paramName: "rayX"; paramValue: sync(godray.name+".x")+godRayX
        }
        ShaderParam {
            paramName: "rayY"; paramValue: sync(godray.name+".y")+godRayY
        }
        ShaderParam {
            paramName: "g_rotCenterX"; paramValue: sync(godray.name+".x")+godRayX
        }
        ShaderParam {
            paramName: "g_rotCenterY"; paramValue: sync(godray.name+".y")+godRayY
        }

        ShaderParam {
            paramName: "lightZ"
            paramValue: sync(godray.name+".lightZ")+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync(godray.name+".intensity")
        }
        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(godray.name+".origAmount")
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync(godray.name+".specRounds")
        }
        ShaderParam {
            paramName: "g_specOfs"
            paramValue: sync(godray.name+".specOfs")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(godray.name+".specWeight")
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync(godray.name+".length")
        }
        ShaderParam {
            paramName: "g_loops"
            paramValue: sync(godray.name+".loops")
        }
        ShaderParam {
            paramName: "g_rotateAmp"
            paramValue: sync(godray.name+".rotateAmp")
        }
        ShaderParam {
            paramName: "g_rotatePrim"
            paramValue: sync(godray.name+".rotatePrim")
        }
        ShaderParam {
            paramName: "g_rotateSinAmp"
            paramValue: sync(godray.name+".rotateSinAmp")
        }
        ShaderParam {
            paramName: "g_rotateSinFreq"
            paramValue: sync(godray.name+".rotateSinFreq")
        }
        ShaderParam { paramName: "g_rotateMove"; paramValue: sync(godray.name+".rotateMove") }
        ShaderParam { paramName: "g_rotateBrightMove"; paramValue: sync(godray.name+".rotateBrightMove") }
        ShaderParam { paramName: "g_rotateBrightFreq"; paramValue: sync(godray.name+".rotateBrightFreq") }
        ShaderParam { paramName: "g_rotateDist"; paramValue: sync(godray.name+".rotateDist")+0.5 }
        ShaderParam { paramName: "g_timeRot"; paramValue: sync(godray.name+".timeRot")+0.0 }
        ShaderParam { paramName: "g_timeBrightRot"; paramValue: sync(godray.name+".timeBrightRot")+0.0 }

        ShaderParam { paramName: "g_screenSize"; paramValue: sync(godray.name+".screenSize") }

        ShaderParam { paramName: "g_baseFromCol"; paramValue: sync(godray.name+".baseFromCol") }

    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
    }
    Blit {
        textureRT: "godRaysResult"
        blitRT: 0
    }


    // mix original and result

    Shader {
        file: "fx/_SharedQML/glow"
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRaysResult"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }

        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(godray.name+".origAmount")
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: sync(godray.name+".screenSize") }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

}

