; Abaddon presents a Ninja-TomCat-Tuske production
; "Plcika megint kirly" the 4k intro for Rage'97
;_________________________________________________

SINLEN = 4096
Sorhossz = 320
SINDB=254


.586
LOCALS

B       EQU     BYTE PTR
W       EQU     WORD PTR
D       EQU     DWORD PTR
Q       EQU     QWORD PTR
F       EQU     FWORD PTR
O       EQU     OFFSET

SEG_A           SEGMENT PAGE USE16
                ASSUME  CS:SEG_A, DS:SEG_A
                ORG     100H
KIKOPI MACRO
                PUSH    DS
                MOV     AX,CS
                ADD     AX,1000H
                MOV     DS,AX
                SUB     SI,SI
                SUB     DI,DI
                MOV     CH,125
                REP     MOVSW
                POP     DS
        ENDM

RandVort        MACRO
        LOCAL   _1

                MOV     AX,randidx
                ADD     AX,8
                CMP     AX,RANDOMTABSIZE
                JB      _1
                randInt
                AND     AX,511
_1:
                MOV     BX,AX
                MOV     randidx,BX
                FLD     randtable[BX]
ENDM

RandInt         MACRO                   ;;Linear-congruential Method
                                        ;;      a <- a * b + c mod m
                MOV     EAX,SEED
                MOV     EDX,31415621    ;;recommended constant by Tom Swan
                INC     EAX
                MUL     EDX
                MOV     SEED,EAX
ENDM

START:
                MOV     CX,SINLEN       ; SINLEN hossz lesz a tblzatunk
                MOV     SI,O SINTAB
                FNINIT
                FLDPI
                FIDIV   COUNT2          ; Step = PI/(SINLEN/2)
                FLDZ
@@01:
                FLD     ST
                FSIN
                FADD    PLUS1
                FSTP    D [SI]
                FADD    ST,ST(1)
                ADD     SI,4
                LOOP    @@01
                FSTP    TRASH
                FSTP    TRASH

                LEA     DI,PAL
                MOV     BL,0
                MOV     CL,63
@@1:
                MOV     AL,0
                STOSB
                MOV     AL,DL
                STOSB
                MOV     AL,BL
                STOSB
                INC     BX
                LOOP    @@1

                MOV     CL,63
@@2:
                MOV     AL,0
                STOSB
                MOV     AL,DL
                STOSB
                MOV     AL,BL
                STOSB
                INC     DX
                LOOP    @@2
                MOV     CL,63
@@3:
                MOV     AL,0
                STOSB
                MOV     AL,DL
                STOSB
                MOV     AL,BL
                STOSB
                DEC     DX
                LOOP    @@3
                MOV     CL,64
@@4:
                MOV     AL,0
                STOSB
                MOV     AL,DL
                STOSB
                MOV     AL,BL
                STOSB
                DEC     BX
                LOOP    @@4
                MOV     CL,6
                REP     STOSB

                LEA     SI,randtable
@@0:
                randInt
                FILD    SEED
                FDIV    C32767
                FSTP    Q [SI] 
                ADD     SI,8
                CMP     SI,O randtable + RANDOMTABSIZE
                JNE     @@0

                MOV     AX,CS
                ADD     AX,1000H
                MOV     ES,AX
                SUB     DI,DI
                SUB     SI,SI
                SUB     BP,BP
                SUB     BX,BX

                MOV     CL,200
CSOR:
                PUSH    CX SI BP BX
                MOV     CX,SORHOSSZ
C2:
                FLD     SINTAB[SI]
                FADD    SINTAB[BP]
                FADD    SINTAB[BX]
                FIMUL    RXX
                FISTP   TRASH

                ADD     SI,2*8
                ADD     BP,2*8
                ADD     BX,2*8
                AND     SI,4*SINLEN-4
                AND     BP,4*SINLEN-4
                AND     BX,4*SINLEN-4

                MOV     AL,B TRASH
                INC     AX
                STOSB

                LOOP    C2
                POP     BP BX SI CX

                ADD     SI,-14*8
                AND     SI,4*SINLEN-4
                ADD     BP,4*8
                AND     BP,4*SINLEN-4
                ADD     BX,-14*8
                AND     BX,4*SINLEN-4

                LOOP    CSOR

FIRST:
                MOV     AX,13H
                INT     10H
                PUSH    0A000H
                POP     ES
                CALL    SETPALGBU
                DEC     DX
                MOV     AL,255
                OUT     DX,AL
                INC     DX
                MOV     AL,3FH
                OUT     DX,AL
                OUT     DX,AL
                OUT     DX,AL
UJRA4:
                CALL    GBU1
                PUSH    CURRCAPT
                CALL    DRAWCAPT
                POP     CURRCAPT
                MOV     ELTOLAS,0
                CALL    GBU1
                CALL    DRAWCAPT
                MOV     ELTOLAS,0
                JNC     UJRA4

                CALL    SETPALROT
UJRA:
                CALL    RETRACE2
                MOV     CL,3
                CALL    FILLROT
                PUSH    CURRCAPT
                CALL    DRAWCAPT
                POP     CURRCAPT
                CALL    RETRACE2
                MOV     CL,3
                CALL    FILLROT
                CALL    DRAWCAPT
                JNC     UJRA

UJRA3:
                MOV     DI,4
VAROK2:
                CALL    RETRACE
                INC     BP
                CMP     BP,SINDB
                JC      @@CIKL
                SUB     BP,BP
@@CIKL:
                MOV     SI,O PAL
                MOV     DX,3C8H
                MOV     AX,BP
                INC     AX
                OUT     DX,AL
                INC     DX
                MOV     CX,SINDB*3
                SUB     CX,BP
                SUB     CX,BP
                SUB     CX,BP
                REP     OUTSB
                DEC     DX
                MOV     AL,1
                OUT     DX,AL
                INC     DX
                MOV     CX,BP
                ADD     CX,BP
                ADD     CX,BP
                REP     OUTSB
                DEC     DI
                JNZ     VAROK2
                KIKOPI
                CALL    DRAWCAPT
                JNC     UJRA3

                SUB     AX,AX
                SUB     DI,DI
                MOV     CX,32000
                REP     STOSW
                MOV     ECX,1500000

                MOV     DX,3C8H         ; Egy lineris paletta belltsa
                MOV     AL,0            ; (vagyis a szntmenet folyamatos).
                OUT     DX,AL
                INC     DX
                MOV     CX,64
@@1:
                MOV     AL,64
                SUB     AL,CL
                OUT     DX,AL
                SHR     AL,1
                OUT     DX,AL
                SHR     AL,1
                OUT     DX,AL
                LOOP    @@1
UJB:
                randVort
                FADD    ST,ST(0)
                FSUB    PLUS1
                FISTP   TRASH
                MOV     AX,W TRASH
                IMUL    AX,320
                ADD     DI,AX
                randVort
                FADD    ST,ST(0)
                FSUB    PLUS1
                FISTP   TRASH
                MOV     AX,W TRASH
                ADD     DI,AX
                CMP     DI,64000
                JNB     UJB
                MOV     AL,ES:[DI]
                CMP     AL,64
                JNB     UJB
                INC     AX
                STOSB
                DEC     ECX
                JNZ     UJB

                PUSH    ES
                POP     DS
                MOV     AX,CS
                ADD     AX,1000H
                MOV     ES,AX
                SUB     DI,DI
                SUB     SI,SI
                MOV     CH,125
                REP     MOVSW
                PUSH    DS
                POP     ES
                PUSH    CS
                POP     DS

UJJ:
                CALL    RETRACE2
                CALL    RETRACE2
                KIKOPI
                CALL    DRAWCAPT
                JNC     UJJ

                CALL    SETPALROT
                MOV     CL,200
UJRA2:
                PUSH    CX
                CALL    RETRACE2
                MOV     CL,5
                CALL    FILLROT

                MOV     DI,SORHOSSZ*86+26
                LEA     SI,LOGOBIN
                MOV     AH,0
                MOV     CL,255
@@B1:
                MOV     BX,272
@@B3:
                LODSB
                ADD     DI,AX
                SUB     BX,AX
                JZ      @@B2
                LODSB
                SUB     BX,AX
                XCHG    AX,CX
                REP     STOSB
                XCHG    AX,CX
                JNZ     @@B3
@@B2:
                ADD     DI,SORHOSSZ-272
                CMP     SI,O LOGOEND
                JB      @@B1

                POP     CX
                LOOP    UJRA2

                MOV     BL,0            ; *** 5. FELADAT ***
                MOV     CX,Sorhossz*200
NEXT:
                RandInt
                CMP     AX,64000
                JNB      NEXT
                XCHG    DI,AX           ; DI: y*Sorhossz+x

                CMP     ES:[DI],BL
                JE      NEXT

                CMP     ES:[DI-Sorhossz-1],BL
                JE      OK
                CMP     ES:[DI-Sorhossz+1],BL
                JE      OK
                CMP     ES:[DI+Sorhossz-1],BL
                JE      OK
                CMP     ES:[DI+Sorhossz+1],BL
                JNE     NEXT
OK:
                MOV     ES:[DI],BL
                LOOP    NEXT

                MOV     AX,3
                INT     10H
                LEA     DX,DUMA
                MOV     AH,9
                INT     21H

                RETN

RETRACE2:
                CALL    RETRACE
RETRACE:
                MOV     DX,3DAH         ; Vrakozs kpernyvltsra
@@1:
                IN      AL,DX
                TEST    AL,8
                JNZ     @@1
@@2:
                IN      AL,DX
                TEST    AL,8
                JZ      @@2
                RETN
SETPALROT:
                MOV     DX, 3C8h
                MOV     AL, 1
                OUT     DX, AL
                INC     DX
                MOV     CL, 63
@@1:
                MOV     AL,63
                SUB     AL,CL
                SHR     AL,1
                OUT     DX, AL
                OUT     DX, AL
                OUT     DX, AL
                LOOP    @@1
                OUT     DX, AL
                OUT     DX, AL
                OUT     DX, AL
                MOV     CL, 64
@@2:
                MOV     AL,CL
                SHR     AL,1
                OUT     DX, AL
                OUT     DX, AL
                OUT     DX, AL
                LOOP    @@2
                RETN
FILLROT:
                MOV     BX,GAMA
                MOV     DX,3DAH
                AND     BX,4*SINLEN-4
                SUB     DI,DI
                SUB     SI,SI          ; A SI mutat a szinusz rtkekre
                SHL     DX,CL
@@2:
                PUSH    BP SI
                MOV     BP,Sorhossz
@@1:
                FLD     SINTAB[SI]
                FMUL    AMPL
                FISTP   TRASH
                ADD     SI,BX
                AND     SI,4*SINLEN-4
                MOV     AL,B TRASH
                inc     ax
                STOSB
                DEC     BP
                JNZ     @@1
                POP     SI BP
                ADD     SI,DX
                AND     SI,4*SINLEN-4
                CMP     DI,Sorhossz*200
                JB      @@2

                MOV     AX,2
                SHL     AX,CL
                SUB     BX,AX
                MOV     GAMA,BX
                RETN

SETPALGBU:
                MOV     DX,3C8H
                MOV     AL,1
                OUT     DX,AL
                INC     DX
                MOV     SI,SINLEN
@@1:
                FLD     SINTAB[SI]
                FMUL    AMPL
                FISTP   TRASH
                ADD     SI,SINLEN*4/2/128
                SHR     TRASH,1
                MOV     AL,B TRASH
                OUT     DX,AL
                MOV     AL,0
                OUT     DX,AL
                MOV     AL,B TRASH
                OUT     DX,AL
                CMP     SI,SINLEN*4/2+SINLEN
                JB      @@1
                RETN
GBU1:
                CALL    RETRACE2
                MOV     CL,10
                CALL    FILLGBU
                PUSH    CURRCAPT
                CALL    DRAWCAPT
                POP     CURRCAPT
                MOV     ELTOLAS,150
                PUSH    CURRCAPT
                CALL    DRAWCAPT
                POP     CURRCAPT
                MOV     ELTOLAS,94*SORHOSSZ+150
                PUSH    CURRCAPT
                CALL    DRAWCAPT
                POP     CURRCAPT
                MOV     ELTOLAS,94*SORHOSSZ
                RETN
FILLGBU:
                MOV     BX,ALFA
                MOV     SI,BETA
                LEA     BP,[BX+4*SINLEN/2]
                AND     BX,4*SINLEN-4
                AND     SI,4*SINLEN-4
                AND     BP,4*SINLEN-4
                FLD     SINTAB[BX]
                FIMUL    RX
                FISTP   X1L
                FLD     SINTAB[SI]
                FIMUL    RY
                FISTP   Y1L
                LEA     BP,[BX+4*SINLEN/2]
                AND     BP,4*SINLEN-4
                FLD     SINTAB[BP]
                FIMUL    RX
                FISTP   X2L
                ADD     BX,4*8*2
                ADD     SI,8*8*2
                MOV     ALFA,BX
                MOV     BETA,SI
                SUB     DI,DI
                MOV     EBP,200-1
@@7:
                MOV     ESI,Sorhossz-1
@@8:
                MOV     EAX,Y1L
                SUB     EAX,EBP
                IMUL    EAX
                MOV     EBX,EAX
                MOV     EAX,X1L
                SUB     EAX,ESI
                IMUL    EAX
                ADD     EAX,EBX
                SHR     EAX,CL
                AND     AL,127
                PUSH    AX
                MOV     EAX,X2L
                SUB     EAX,ESI
                IMUL    EAX
                ADD     EAX,EBX
                SHR     EAX,CL
                AND     AL,127
                POP     BX
                ADD     AL,BL
                RCR     AL,1
                INC     AX
                MOV     AH,AL
                MOV     ES:[DI+Sorhossz],AX
                STOSW
                SUB     SI,2
                JNS     @@8
                ADD     DI,Sorhossz
                SUB     BP,2
                JNS     @@7
                RETN

DRAWCAPT:
                MOV     SI,CURRCAPT
CC1:
                MOV     AH,0
                LODSB
                ADD     AL,AL
                JC      CC2
                MOV     W Y2[1],AX
                LODSB
                ADD     AX,STARTER
                ADD     AX,AX
                MOV     W X2[1],AX
                CALL    Line
                JMP     CC1
CC2:
                CMP     AL,200
                JNB     @@3
                MOV     W Y1[1],AX
                LODSB
                ADD     AX,STARTER
                ADD     AX,AX
                MOV     W X1[1],AX
                JMP     CC1
@@3:
                CMP     AL,254
                MOV     AX,SI
                MOV     CX,LCOUNTER
                JE      @@4
                MOV     AX,PREVCAPT
                LOOP    @@4
                LODSB
                MOV     CL,AL
                JCXZ    VEGE
                LODSB
                CBW
                ADD     AX,AX
                MOV     STARTER,AX
                XCHG    SI,AX
                MOV     PREVCAPT,AX
@@4:
                MOV     CURRCAPT,AX
                MOV     LCOUNTER,CX
                CLC
                RETN
VEGE:
                MOV     CURRCAPT,SI
                STC
                RETN
;=============================================================================
Line:
                PUSHA
;=============================================================================
X1:             MOV     DI,?
Y1:             MOV     AX,?
X2:             MOV     SI,?
Y2:             MOV     CX,?
                SUB     SI,DI           ;DX = X2 - X1
                SUB     CX,AX           ;DY = Y2 - Y1
                MOV     DX,SI
                MOV     BX,CX
                ADD     SI,SI           ;AX = ABS(DX) * 2
                JNC     @@L1
                NEG     SI
@@L1:
                ADD     CX,CX           ;AY = ABS(DY) * 2
                JNC     @@L2
                NEG     CX
@@L2:
                SAR     DX,16           ;SX = SGN(DX)
                SBB     DX,-1
                SAR     BX,16           ;SY = SGN(DY)
                SBB     BX,-1
                CMP     SI,CX
                JNA     @@L5            ;IF AX > AY
                MOV     BP,SI           ;  D = AY - AX / 2
                SHR     BP,1
                NEG     BP
                ADD     BP,CX
@@L3:                                   ;  DO
                CALL    Plot            ;    PLOT(X,Y)
                CMP     DI,W X2[1]
                JE      @@L8            ;  UNTIL X = X2
                TEST    BP,BP
                JS      @@L4            ;    IF D >= 0
                ADD     AX,BX           ;      Y += SY
                SUB     BP,SI           ;      D -= AX
@@L4:                                   ;    ENDIF
                ADD     DI,DX           ;    X += SX
                ADD     BP,CX           ;    D += AY
                JMP     @@L3            ;  ENDDO
@@L5:                                   ;ELSE
                MOV     BP,CX           ;  D = AX - AY / 2
                SHR     BP,1
                NEG     BP
                ADD     BP,SI
@@L6:                                   ;  DO
                CALL    Plot            ;    PLOT(X,Y)
                CMP     AX,W Y2[1]
                JE      @@L8            ;  UNTIL Y = Y2
                TEST    BP,BP
                JS      @@L7            ;    IF D >= 0
                ADD     DI,DX           ;      X += SX
                SUB     BP,CX           ;      D -= AY
@@L7:                                   ;    ENDIF
                ADD     AX,BX           ;    Y += SY
                ADD     BP,SI           ;    D += AX
                JMP     @@L6            ;  ENDDO
@@L8:                                   ;ENDIF
;=============================================================================
                POPA
                MOV     AX,W X2[1]
                MOV     W X1[1],AX
                MOV     AX,W Y2[1]
                MOV     W Y1[1],AX
                RETN
;=============================================================================
Plot:
                CMP     DI,320
                JNB     @@1
                PUSHA
                SHL     AX,6
                ADD     DI,AX
                SHL     AX,2
                ADD     DI,AX
                ADD     DI,ELTOLAS
                MOV     AL,255
                STOSB
                POPA
@@1:
                RETN
;=============================================================================

Motion:
                DB      254
                INCLUDE J3.INC
                DB      0
                DB      254
                INCLUDE J1.INC
                DB      0
                DB      254
                INCLUDE J2.INC
                DB      0
                DB      254
                INCLUDE J4.INC
                DB      0

LOGOBIN:        INCLUDE LOGO.INC
LOGOEND:

DUMA:           DB 'ZEHN KLEINE JGERMEISTER by TomCat/Abaddon$'

CURRCAPT        DW      O Motion
LCOUNTER        DW      1

C32767          DD      32767.0
RX              DW      159             ; A grbe x irny sugara
RY              DW      99              ; A grbe y irny sugara

Seed            DD      1

randidx         DW      -1
GAMA            DW      0

ALFA            DW      0
BETA            DW      0

ELTOLAS         DW      0

RXX             DW      21

AMPL            DD      63.4
COUNT2          DW      SINLEN/2

PLUS1           DD      1.0
TRASH           DD      ?

STARTER         DW      ?
PREVCAPT        DW      ?

X1L             DD      ?
Y1L             DD      ?
X2L             DD      ?

PAL             DB      768 DUP(?)
SINTAB          DD      SINLEN DUP(?)

randtable LABEL QWORD
    DQ 513 DUP(?)
RANDOMTABSIZE = $ - OFFSET randtable

SEG_A           ENDS         
                END     START
