; ADATOK:
; -------
; A sugr (flegyenes)
;                          _
;       - kiindul pontja: P = (Px,Py,Pz)
;                 _
;       - irnya: D = (Dx,Dy,Dz)      <--  egysgnyi vektor
; 
; A sk
;                         _
;       - norml vektora: N = (A,B,C)
;                     _
;       - egy pontja: Po = (Xo,Yo,Zo)
; 
;
; SZMOLS:
; ---------
; A tvolsg (t)
; 
;       D = - (A * Xo + B * Yo + C * Zo)       <-- init0
; 
;       d = A * Dx + B * Dy + C * Dz
; 
; s
;             A * Px + B * Py + C * Pz + D
;       t = - ---------------------------- , ha d <> 0
;                          d
; vagy
; 
;       V = - (A * Px + B * Py + C * Pz + D)       <-- init
; 
;           V
;       t = - , ha d <> 0
;           d
;                _
; A metszspont (M)
;       _   _       _
;       M = P + t * D, ha t > 0
; 
;       azaz
;       _
;       M = (Px + t * Dx, Py + t * Dy, Pz + t * Dz), ha t > 0
; ___________________________________________________________________________

PlaneType       STRUC
                Object<>
Base            Vector<>
Norm            Vector<>
Offs            DQ      ?
NdotP           DQ      ?
ENDS

Plane           MACRO   _Xo,_Yo,_Zo,_A,_B,_C,_Texture:REQ,_Next

        IFB <_Next>
                DD      L O $ + SIZE PlaneType
        ELSE
                DD      L O _Next
        ENDIF
                DD      L O PlaneInitO
                DD      L O PlaneInitF
                DD      L O PlaneFirst
                DD      L O PlaneShade
                DD      L O PlaneIsect
                DD      L O PlaneNorml
                DD      L O _Texture
                DD      ?
                DD      ?

                Vector<_Xo,_Yo,_Zo>
                Vector<_A,_B,_C>
                DQ      ?
                DQ      ?
ENDM

PlaneInitO:
                VDOT    ESI.Base,ESI.Norm
                FCHS
                FSTP    [ESI.Offs]
                NextInitO

PlaneInitF:
                VDOT    ESI.Norm,EBX.EyePos
                FADD    [ESI.Offs]
                FCHS
                FSTP    [ESI.NdotP]
                NextInitF

PlaneFirst:
                VDOT    Direction,ESI.Norm
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FDIVR   [ESI.NdotP]
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     EBX,ESI
                MOV     ESI,[ESI.NextO]
                FSTP    Distance
                CMP     ESI,FirstO
                JE      LastFirst
                JMP     O [ESI.First]
@@1:
                NextFirst 1

PlaneShade:
                VDOT    Shadow,ESI.Norm
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                VDOT    ESI.Norm,Position
                FADD    [ESI.Offs]
                FCHS
                FDIVRP  ST(1),ST
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FCOMP   Distance
                FNSTSW  AX
                SAHF
                JAE     @@0
                CALL    [ESI.Texture]
                FLD     [EDX.Transmit]  ; T
                FTST
                FNSTSW  AX
                SAHF
                JNZ     @@2
                MOV     [EBX.Cache],ESI
                RETN
@@2:
                MOV     ESI,[ESI.NextO]
                FMUL    Trans           ; P*T
                FSTP    Trans
                CMP     ESI,FirstO
                JE      LastShade
                JMP     O [ESI.Shade]
@@1:
                NextShade 1
@@0:
                NextShade

PlaneIsect:
                VDOT    Direction,ESI.Norm
                FLD     ST
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                VDOT    ESI.Norm,Position
                FADD    [ESI.Offs]
                FCHS
                FDIVRP  ST(1),ST
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     EBX,ESI
                MOV     ESI,[ESI.NextO]
                FSTP    Distance
                CMP     ESI,FirstO
                JE      LastIsect
                JMP     O [ESI.Isect]
@@1:
                NextIsect 1

PlaneNorml:
                VNLD    EBX.Norm
                RETN
