; ADATOK:
; -------
; A sugr (flegyenes)
;                          _
;       - kiindul pontja: P = (Px,Py,Pz)
;                 _
;       - irnya: D = (Dx,Dy,Dz)  <--  egysgnyi vektor
; 
; A Z tengely irny 
;                      _
;       - kzppontja: C = (Cx,Cy)
; 
;       - sugara: r
;
; SZMOLS:
; ---------
; A tvolsg (t)
; 
;       r2 = r * r      <-- init0
;       _
;       V = (Cx,Cy) - (Px,Py)
; 
;       b = Vx * Dx + Vy * Dy
; 
;       a = Dx * Dx + Dy * Dy
; 
; s
; 
;       d = b * b - a * (Vx * Vx + Vy * Vy + r2)
; 
;       t = ( b +/- sqrt(d) ) / a, ha d >= 0
; 
; vagy
; 
;       V2 = - Vx * Vx + Vy * Vy + r2      <-- init
; 
;       d = b * b + a * V2
; 
;       t = ( b +/- sqrt(d) ) / a, ha d >= 0
;                _
; A metszspont (M)
;       _   _       _
;       M = P + t * D, ha t > 0
; 
;       azaz
;       _
;       M = (Px + t * Dx, Py + t * Dy, Pz + t * Dz), ha t > 0
; ___________________________________________________________________________

Cone_ZType      STRUC
                Object<>
CCenter         DQ      ?
                DQ      ?
CRadius         DQ      ?
CRadius2        DQ      ?
CCsubP          DQ      ?
                DQ      ?
CCsubP2         DQ      ?
ENDS

Cone_Z          MACRO   _Cx,_Cy,_R,_Texture:REQ,_Next

                ObjectInit Cone_Z,_Texture,_Next

                DQ      _Cx,_Cy
                DQ      _R
                DQ      ?
                DQ      ?,?
                DQ      ?
ENDM

Cone_ZInitO:
                FLD     Plus1            ;; 1
                FLD     [SI.CRadius]     ;; R  1
                FDIV    ST(1),ST         ;; R  1/R
                FMUL    ST,ST            ;; R*R  1/R
                FXCH                     ;; 1/R  R*R
                FSTP    [SI.CRadius]     ;; R*R
                FSTP    [SI.CRadius2]
                NextInitO

Cone_ZInitF:
                FLD     [SI.CCenter.X]
                FSUB    [BX.EyePos.X]
                FLD     [SI.CCenter.Y]
                FSUB    [BX.EyePos.Y]
                FXCH
                FST     [SI.CCsubP.X]
                FXCH
                FST     [SI.CCsubP.Y]
                FMUL    ST,ST
                FXCH
                FMUL    ST,ST
                FXCH
                FADDP
                FCHS
                FADD    [SI.CRadius2]
                FSTP    [SI.CCsubP2]
                NextInitF

Cone_ZFirst:
                FLD     [Direction.X]
                FMUL    ST,ST
                FLD     [Direction.Y]
                FMUL    ST,ST
                FXCH
                FADDP                           ; a
                FLD     [SI.CCsubP.X]
                FMUL    [Direction.X]
                FLD     [SI.CCsubP.Y]
                FMUL    [Direction.Y]
                FXCH
                FADDP                           ; b  a
                FLD     ST                      ; b  b  a
                FMUL    ST,ST(1)                ; b*b  b  a
                FLD     [SI.CCsubP2]            ; -c  b*b  b  a
                FMUL    ST,ST(3)                ; -c*a  b*b  b  a
                FADDP                           ; d  b  a
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@3
                FSQRT                           ; d  b  a
                FLD     ST(1)                   ; b  d  b  a
                FXCH                            ; d  b  b  a
                FADD    ST(2),ST                ; d  b  b+d  a
                FSUBP   ST(1),ST                ; b-d  b+d  a
                FDIV    ST,ST(2)                ; (b-d)/a  b+d  a
                FXCH                            ; b+d  (b-d)/a  a
                FDIVRP  ST(2),ST                ; (b-d)/a  (b+d)/a
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@2
                FCOM    Epsilon
                FXCH                            ; b+d  b-d
                FNSTSW  AX
                SAHF
                JA      @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                            ; b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@2
@@1:
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Trash                   ; t
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastFirst
                JMP     O [SI.First]
@@2:
                NextFirst 2
@@3:
                NextFirst 3

Cone_ZShade:
                FLD     [Shadow.X]
                FMUL    ST,ST
                FLD     [Shadow.Y]
                FMUL    ST,ST
                FXCH
                FADDP                   ; a
                FLD     [SI.CCenter.X]  ; CX  a
                FSUB    [Position.X]    ; CX-PX  a
                FLD     [SI.CCenter.Y]  ; CY  CX-PX  a
                FSUB    [Position.Y]    ; CY-PY  CX-PX  a
                FLD     [Shadow.X]      ; DX  VY  VX  a
                FMUL    ST,ST(2)        ; DX*VX  VY  VX  a
                FLD     [Shadow.Y]      ; DY  DX*VX  VY  VX  a
                FMUL    ST,ST(2)        ; DY*VY  DX*VX  VY  VX  a
                FXCH                    ; DX*VX  DY*VY  VY  VX  a
                FADDP                   ; DX*VX+DY*VY  VY  VX  a
                FLD     ST(1)           ; VY  DX*VX+DY*VY  VY  VX  a
                FMULP   ST(2)           ; DX*VX+DY*VY  VY*VY  VX  a
                FLD     ST              ; b  b  VY*VY  VX  a
                FXCH    ST(3)           ; VX  b  VY*VY  b  a
                FMUL    ST,ST           ; VX*VX  b  VY*VY  b  a
                FADDP   ST(2),ST        ; b  VX*VX+VY*VY  b  a
                FMUL    ST,ST           ; b*b  VX*VX+VY*VY  b  a
                FXCH                    ; VX*VX+VY*VY  b*b  b  a
                FSUBR   [SI.CRadius2]   ; -c  b*b  b  a
                FMUL    ST,ST(3)        ; -c*a  b*b  b  a
                FADDP                   ; d  b  a
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@3
                FSQRT                   ; d  b  a
                FLD     ST(1)           ; b  d  b  a
                FADD    ST,ST(1)        ; b+d  d  b  a
                FXCH                    ; d  b+d  b  a
                FSUBP   ST(2),ST        ; b+d  b-d  a
                FDIV    ST,ST(2)        ; (b+d)/a  b-d  a
                FXCH                    ; b-d  (b+d)/a  a
                FDIVRP  ST(2),ST        ; (b+d)/a  (b-d)/a
                FCOM    Epsilon
                FXCH                    ; b-d  b+d
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                    ; b+d  b-d
                FNSTSW  AX
                SAHF
                JAE     @@2
                CALL    O [SI.Texture]
                FLD     [DI.Transmit]   ; T  b+d  b-d
                FTST
                FXCH    ST(2)           ; b-d  b+d  T
                FNSTSW  AX
                SAHF
                JNZ     @@0
                MOV     [BX.Cache],SI
                FSTP    Trash           ; b+d  0
                FSTP    Trash           ; 0
                RETN
@@0:
                FCOM    Epsilon
                FXCH                    ; b+d  b-d  T
                FNSTSW  AX
                SAHF
                JBE     @@1
                FCOM    Distance
                FXCH    ST(2)           ; T  b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@1
                FMUL    ST,ST           ; T*T  b-d  b+d
@@1:
                FMUL    Trans           ; P*TT  b-d  b+d
                FSTP    Trans           ; b-d  b+d
@@2:
                NextShade 2
@@3:
                NextShade 3

Cone_ZIsect:
                FLD     [Direction.X]
                FMUL    ST,ST
                FLD     [Direction.Y]
                FMUL    ST,ST
                FXCH
                FADDP                   ; a
                FLD     [SI.CCenter.X]  ; CX  a
                FSUB    [Position.X]    ; CX-PX  a
                FLD     [SI.CCenter.Y]  ; CY  CX-PX  a
                FSUB    [Position.Y]    ; CY-PY  CX-PX  a
                FLD     [Direction.X]   ; DX  VY  VX  a
                FMUL    ST,ST(2)        ; DX*VX  VY  VX  a
                FLD     [Direction.Y]   ; DY  DX*VX  VY  VX  a
                FMUL    ST,ST(2)        ; DY*VY  DX*VX  VY  VX  a
                FXCH                    ; DX*VX  DY*VY  VY  VX  a
                FADDP                   ; DX*VX+DY*VY  VY  VX  a
                FLD     ST(1)           ; VY  DX*VX+DY*VY  VY  VX  a
                FMULP   ST(2)           ; DX*VX+DY*VY  VY*VY  VX  a
                FLD     ST              ; b  b  VY*VY  VX  a
                FXCH    ST(3)           ; VX  b  VY*VY  b  a
                FMUL    ST,ST           ; VX*VX  b  VY*VY  b  a
                FADDP   ST(2),ST        ; b  VX*VX+VY*VY  b  a
                FMUL    ST,ST           ; b*b  VX*VX+VY*VY  b  a
                FXCH                    ; VX*VX+VY*VY  b*b  b  a
                FSUBR   [SI.CRadius2]   ; -c  b*b  b  a
                FMUL    ST,ST(3)        ; -c*a  b*b  b  a
                FADDP                   ; d  b  a
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@3
                FSQRT                           ; d  b  a
                FLD     ST(1)                   ; b  d  b  a
                FXCH                            ; d  b  b  a
                FADD    ST(2),ST                ; d  b  b+d  a
                FSUBP   ST(1),ST                ; b-d  b+d  a
                FDIV    ST,ST(2)                ; (b-d)/a  b+d  a
                FXCH                            ; b+d  (b-d)/a  a
                FDIVRP  ST(2),ST                ; (b-d)/a  (b+d)/a
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@2
                FCOM    Epsilon
                FXCH                            ; b+d  b-d
                FNSTSW  AX
                SAHF
                JA      @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                            ; b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@2
@@1:
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Trash                   ; t
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastIsect
                JMP     O [SI.Isect]
@@2:
                NextIsect 2
@@3:
                NextIsect 3

Cone_ZNorml:
                FLD     Zero
                FLD     [Position.Y]
                FSUB    [BX.CCenter.Y]
                FMUL    [BX.CRadius]
                FLD     [Position.X]
                FSUB    [BX.CCenter.X]
                FMUL    [BX.CRadius]
                RETN
