#include "gamecore.h"

#include <fmod.hpp>
#include <fmod_errors.h>

#include <deque>

FMOD_RESULT result;
FMOD::System *fmodsys;
FMOD::Sound *song1;
FMOD::Sound *song2;
FMOD::Sound *song3;
FMOD::Sound *death;
FMOD::Sound *death2;
FMOD::Sound *rocket;
FMOD::Sound *select[13];

FMOD::Channel *channel1;
FMOD::Channel *channel2;
FMOD::Channel *channel3;
FMOD::Channel *channel4;
FMOD::Channel *channel5;
FMOD::Channel *deathch[5];

void initSound( )
{
	result = FMOD::System_Create(&fmodsys);		// Create the main system object.
  if (result != FMOD_OK)
  {
	  printf("FMOD error! (%d) %s\n", result, FMOD_ErrorString(result));
	  exit(-1);
  }

  result = fmodsys->init(100, FMOD_INIT_NORMAL, 0);	// Initialize FMOD.
  if (result != FMOD_OK)
  {
	  printf("FMOD error! (%d) %s\n", result, FMOD_ErrorString(result));
	  exit(-1);
  }

  fmodsys->createStream( "data/part1.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME|FMOD_LOOP_NORMAL, 0, &song1 );
	fmodsys->createStream( "data/part2.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME|FMOD_LOOP_NORMAL, 0, &song2 );
	fmodsys->createStream( "data/part3.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME|FMOD_LOOP_NORMAL, 0, &song3 );

	fmodsys->createSound( "data/G5 power up2.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &death );
	fmodsys->createSound( "data/G5 rakett.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &rocket );

	fmodsys->createSound( "data/scale/01.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[0] );
	fmodsys->createSound( "data/scale/02.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[1] );
	fmodsys->createSound( "data/scale/03.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[2] );
	fmodsys->createSound( "data/scale/04.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[3] );
	fmodsys->createSound( "data/scale/05.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[4] );
	fmodsys->createSound( "data/scale/06.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[5] );
	fmodsys->createSound( "data/scale/07.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[6] );
	fmodsys->createSound( "data/scale/08.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[7] );
	fmodsys->createSound( "data/scale/09.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[8] );
	fmodsys->createSound( "data/scale/10.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[9] );
	fmodsys->createSound( "data/scale/11.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[10] );
	fmodsys->createSound( "data/scale/12.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[11] );
	fmodsys->createSound( "data/scale/13.ogg", FMOD_DEFAULT|FMOD_SOFTWARE|FMOD_ACCURATETIME, 0, &select[12] );

	channel4->setVolume( 1.0f );
}

void playMusak( )
{
	fmodsys->playSound( FMOD_CHANNEL_FREE, song1, false, &channel1 );
	fmodsys->playSound( FMOD_CHANNEL_FREE, song2, false, &channel2 );
	fmodsys->playSound( FMOD_CHANNEL_FREE, song3, false, &channel3 );
	//channel->setPosition( demoTime, FMOD_TIMEUNIT_MS );

	channel1->setVolume( 0 );
	channel2->setVolume( 0 );
	channel3->setVolume( 0 );

}

int death_queue = 0;
float death_play_cooldown = 0;
int deathc = 0;

void playDeath( )
{
	death_queue++;

	//fmodsys->playSound( FMOD_CHANNEL_REUSE, death, false, &channel4 );
}

void updateDeath( )
{
	//std::cout << death_queue << "\n";

	if( death_queue > 0 && death_play_cooldown <= 0 )
	{
		fmodsys->playSound( FMOD_CHANNEL_REUSE, death, false, &deathch[deathc] );
		
		deathc++;
		if( deathc > 4 )
			deathc = 0;

		death_play_cooldown = 50;
		death_queue--;
	}

	death_play_cooldown -= dTime;
}

int rocket_queue = 0;
float rocket_play_cooldown = 0;

void playRocket( )
{
	rocket_queue++;

	//fmodsys->playSound( FMOD_CHANNEL_REUSE, rocket, false, &channel4 );
}

void updateRocket( )
{
	//std::cout << rocket_queue << "\n";

	if( rocket_queue > 0 && rocket_play_cooldown <= 0 )
	{
		fmodsys->playSound( FMOD_CHANNEL_REUSE, rocket, false, &channel4 );

		rocket_play_cooldown = 200;
		rocket_queue--;
	}

	rocket_play_cooldown -= dTime;
}

std::deque<int> select_queue;
float select_play_cooldown = 0;

void playSelect( int combo )
{
	//if( combo > 12 )
	int theShiftScale = 0; // rand()%3 -1;
		combo = combo + theShiftScale;
		if(combo<0)
			combo = 0;
		if(combo >12)
		combo = 12;// combo%13;

	select_queue.push_back( combo );
}

void updateSelect( )
{
	if( select_queue.begin( ) != select_queue.end( ) && select_play_cooldown <= 0 )
	{
		int tmp = (*select_queue.begin( ));
		select_queue.pop_front( );

		fmodsys->playSound( FMOD_CHANNEL_REUSE, select[tmp], false, &channel5 );

		select_play_cooldown = 100;
	}

	select_play_cooldown -= dTime;
}

void mixMusak( float value )
{	
	channel1->setVolume( 1.0f-(value*2) );

	float tmp;

	if( value > 0.5 ) tmp = 2-(value*2);
	else tmp = value*2;

	channel2->setVolume( tmp );
	channel3->setVolume( value-0.5f );

	//std::cout << 1.0f-(value*2) << " : " << tmp << " : " << (value*2)-1.0f << "\n";
}