#ifndef H_xxGAMECORExx_H
#define H_xxGAMECORExx_H
#include <fusa.h>
#include <queue>
#include <SDL.h>
using namespace fusa;

extern int  winW;
extern int  winH;
extern long dTime;
extern long demoTime;
extern bool exitGame;



void drawNumber(int number, 
				fusa::cVec2f pos, 
				fusa::cVec2f size);
void drawSprite( fusa::cVec2f pos, fusa::cVec2f size );
bool buttonDown(Uint8 button);
bool buttonUp(Uint8 button);
bool buttonPress(Uint8 button);


float getMouseX();
float getMouseY();

bool getMouseDown();
bool getMousePress();

bool posOutOfGrid(const cVec2f &pos,float radi);

struct sHudMessage
{
	std::string textFile;
	float time;
	float delay;
};

 

enum eFaction
{
	facGray,
	facGreen,
	facRed,
	facBlue
};

struct sGameObj
{
	float colRadi;
	float radi;
	cVec2f pos;
	std::string texture;
	std::string loadedFrom;
	void loadFile(const std::string &file);
	void reload();
	void draw();

	virtual void subLoad(std::ifstream &f_in)
	{
	}

	bool collision(const sGameObj &obj)
	{//are two things colliding?
		//distance between two squared.
		float disSqr = (pos - obj.pos).squareLength();
		float radiSqr = colRadi + obj.colRadi;
		radiSqr*=radiSqr;
		return disSqr < radiSqr*0.5f;
	}
	eFaction faction;
};

struct sPlayerAim : public sGameObj
{
	sPlayerAim()
	{
		currSelChain = 0;
	}
	int currSelChain;
	std::queue<int> enSelects;
};

struct sPlayer : public sGameObj
{
	void subLoad(std::ifstream &f_in);

void doBounding();

	cVec2f velocity;
	float accel;
	float deAcc;
	float speed;
	int shotSpeedDelayPerShot;

	float origSize;
	float origColliSize;

};

struct sAttachedDot : public sGameObj
{
	sAttachedDot()
	{
		alive = false;
	}
	void subLoad(std::ifstream &f_in);

	bool alive;
	
	int delayUntilPopScale;
	float popScaleSpeed;
	float currScale;
	int delayPerDot;

	cVec2f velocity;
	
};

struct sEnemy : public sGameObj
{
	sEnemy()
	{
		selectNr = 0;
		alive = true;
		homedByShot = -1;
		bulletSpawnTimer = rand()%2000 + 2000;
		notInShot = true;
	}

	void updateTexture()
	{
	
		if(faction==facRed)
		{
			texture=textureRed;
		}
		if(faction==facGreen)
		{
			texture=textureGreen;
		}
		if(faction==facBlue)
		{
			texture=textureBlue;
		}
	}

	void subLoad(std::ifstream &f_in);
	int homedByShot;
	int selectNr;
	int bulletSpawnTimer;
	bool alive;
	bool notInShot;
	cVec2f velocity;
	float speed;
	cVec2f selNumberSize;
	std::string selectedTex;



	std::string textureRed;
	std::string textureGreen;
	std::string textureBlue;

	int howOftenSpawn;
	int randomQ;
	int manySpawn;
	int randomManyQ;
};

struct sDangerDot : public sGameObj
{
	sDangerDot()
	{
		alive = false;
	}
	void subLoad(std::ifstream &f_in);

	void updateTexture()
	{
	
		if(faction==facRed)
		{
			texture=textureRed;
		}
		if(faction==facGreen)
		{
			texture=textureGreen;
		}
		if(faction==facBlue)
		{
			texture=textureBlue;
		}
	}

	cVec2f velocity;
	bool alive;
	float shotSpeed;

	std::string textureRed;
	std::string textureGreen;
	std::string textureBlue;
};

struct sDangerSpawn : public sGameObj
{
	sDangerSpawn()
	{
		alive = false;
		timeToSpawn = 6000 + rand()%2000;
	}

	void subLoad(std::ifstream &f_in);
	void updateTexture()
	{
	
		if(faction==facRed)
		{
			texture=textureRed;
		}
		if(faction==facGreen)
		{
			texture=textureGreen;
		}
		if(faction==facBlue)
		{
			texture=textureBlue;
		}
	}
	
	bool alive;
	int timeToSpawn;

	int howOftenSpawn;
	int randomQ;
	int manySpawn;
	int randomManyQ;

	
	std::string textureRed;
	std::string textureGreen;
	std::string textureBlue;
	float rotaSpeed;
	float radius;
	
};

struct sPlayerProjectiles : public sGameObj
{
	sPlayerProjectiles()
	{
		alive = false;
		enemyTarget = -1;
	}
	void subLoad(std::ifstream &f_in);

	int chainValue;

	bool alive;
	int enemyTarget;
	float shotSpeedStart;
	float shotSpeedEnd;
	float shotSpeedAcc;
	float shotSpeed;
	int shotSpeedDelay;
	
};

struct sGame
{

	bool inSplash;

	int chainValue;
	eFaction chainFaction;

	int currScore;
	int topScore;
	int lastScore;

	void reload();
	void doInput();
	void doMouse();

	void killAll();

	void playerProjDeathSwap(int index);
	void enemyDeathSwap(int index);
	void dangerDotDeathSwap(int index);
	void attachDotDeathSwap(int index);

	void initGame(const std::string &filename);
	void doGame();
	sPlayer playa; //player object
	sPlayerAim playaAim; //player aim recticle
	std::vector<sEnemy> enemies; //enemies
	std::vector<sDangerDot> dangerDots; //bullets shot by enemies
	std::vector<sDangerSpawn> dangerHoles; //spawn holes for enemies
	std::vector<sPlayerProjectiles> playerProjects; //projectiles the player shoot out.
	std::vector<sAttachedDot> attachedDots;
	

	bool inACaliBlow;
	float caliBlow;

	int lastDeadPlayerProj;
	int lastDeadEnemy;
	int lastDeadDot;
	int lastDeadAttach;


	int timeWithoutRespawn;
	int currLevel;
	std::vector<int> levelNeeds;
	std::vector<std::string> levelPaths;
	std::stack<int> chainStack;
	int soundStack;

	bool gameIsDone;
};

extern sGame rb;

void doRogg();
void initRogg();

//---------

void drawPointSprite( fusa::cVec2f pos, float size );

void drawSplash( );

void newSplash( std::string tex ,float timeToTake=5000.0,float delay=0.0);

void initSound( );

void playMusak( );
void mixMusak( float value );

void playDeath( );
void updateDeath( );

void playRocket( );
void updateRocket( );

void playSelect( int combo );
void updateSelect( );

#define MAX_PARTICLES 100

float random( );

struct Particle
{
	Particle( ):
	pos( -10000, -10000 ),
	vel( 0, 0 ),
	r( random( ) ), g( random( ) ), b( random( ) ), a( 1.0f ),
	size( 100.0f ), grow( 0.0f ), fade( 0.001 )
	{ }

	fusa::cVec2f pos;
  fusa::cVec2f vel;
	float r, g, b, a;

	float size, grow, fade;
};

struct ParticleSystem
{
	ParticleSystem( std::string tex_ );

	void render( );

	void addParticle( );

	virtual Particle makeParticle( );

	Particle particles[MAX_PARTICLES];
	std::string tex;
	fusa::cVec2f pos;

	float spawn_rate;
	float spawn_timer;
};

struct SpawnParticleSystem : public ParticleSystem
{
	SpawnParticleSystem( );

	virtual Particle makeParticle( );
};

#endif