#include "gamecore.h"
#include "math.h"
#include <sstream>

std::string splash;
float splash_fade = 0.0f;
std::queue<sHudMessage> messageQueue;

float random( )
{
	return (float)(rand( )%1000)/1000;
}

void drawNumber(int number, 
				fusa::cVec2f pos, 
				fusa::cVec2f size)
{
	std::stringstream ss;
	ss<<number;
	std::string numb;
	ss>>numb;
	for(unsigned int i=0; i < numb.size(); i++)
	{
		std::string texPath = "0-9/";
		texPath+=numb[i];
		texPath+=".png";
		getTexture(texPath).bindTexture();
		cVec2f mod(i*size.x,0.0f);
		drawSprite(pos + mod,size);
	}
}

void newSplash( std::string tex , float timeToTake,float delay)
{
	sHudMessage hum;
	hum.textFile = tex;
	hum.time = timeToTake;
	hum.delay = delay;
	messageQueue.push(hum);
}

void drawSplash( )
{
	if(messageQueue.size())
	{

		//check if its time to remove from queue.
		if(messageQueue.front().delay>0.0)
		{
			messageQueue.front().delay-=dTime;
			return;
			
		}
		else
		{
			messageQueue.front().delay = 0.0;
		}

		messageQueue.front().time-=dTime;
		if(messageQueue.front().time<0.0)
		{
			messageQueue.pop();
		}
		else
		{
			fusa::getTexture( messageQueue.front().textFile ).bindTexture( 0 );

			//splash_fade -= dTime;

			glColor4f( 1.0f, 1.0f, 1.0f, messageQueue.front().time/1000 );

			glBegin( GL_QUADS );
			glTexCoord2f( 0.0f, 1.0f ); glVertex2f( 0,    -128 );
			glTexCoord2f( 0.0f, 0.0f ); glVertex2f( 0,    -128+winH );
			glTexCoord2f( 1.0f, 0.0f ); glVertex2f( winW, -128+winH );
			glTexCoord2f( 1.0f, 1.0f ); glVertex2f( winW, -128 );
			glEnd( );
		}
	}
}

void drawSprite( fusa::cVec2f pos, fusa::cVec2f size )
{
	size /= 2;

	//glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f, 1.0f ); glVertex2f( pos.x-size.x, pos.y-size.y );
		glTexCoord2f( 0.0f, 0.0f ); glVertex2f( pos.x-size.x, pos.y+size.y );
		glTexCoord2f( 1.0f, 0.0f ); glVertex2f( pos.x+size.x, pos.y+size.y );
		glTexCoord2f( 1.0f, 1.0f ); glVertex2f( pos.x+size.x, pos.y-size.y );
	glEnd( );
}

void drawPointSprite( fusa::cVec2f pos, float size )
{
	size /= 2;

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f, 1.0f ); glVertex2f( pos.x-size, pos.y-size );
		glTexCoord2f( 0.0f, 0.0f ); glVertex2f( pos.x-size, pos.y+size );
		glTexCoord2f( 1.0f, 0.0f ); glVertex2f( pos.x+size, pos.y+size );
		glTexCoord2f( 1.0f, 1.0f ); glVertex2f( pos.x+size, pos.y-size );
	glEnd( );
}

