#include "fusa_scenegraph.h"
#include <fstream>
#include <string>
#include "../OGLIncludes.h"
#include "../common/fusa_logging.h"
using namespace fusa;
//FIX_ME
//load file should clear old scene.


cScenegraph::cScenegraph()
{

  m_idGenerator=1;
  mptr_root = new cSpatialNode(this);
  mptr_root->m_ID= 0;
  mptr_root->Name() = "fusa_root";

  cCameraNode *defCam = createCameraNode();
  defCam->Name()="fusa_defcam";
  defCam->translate(cVec3f(0,0,0));

  mptr_root->addChild(defCam);

  m_activeCamera = defCam;

  mptr_pickedNode = 0;

  m_ready=false;

}

bool cScenegraph::loadFile(const std::string &filename,bool binForm)
{
  cSpatialNode * ptr_newScene=0;
  if(binForm)
    {
      std::ifstream in;
      in.open(filename.c_str(),std::ios::binary);
      if(!in.good())
	{
	  //return false or crash?.. at this moment I'll just crash.
	  logger<<"Could not find file:"<<filename<<std::endl;
	  return false;
	}
      int format=0;
      in.read(reinterpret_cast<char*>(&format),sizeof(int));
      if(format == 1)
	{
	  ptr_newScene=loadFormat1Bin(in,filename);
	  if( !ptr_newScene )
	    {
	      return false;
	    }
	}
    }
  else
    {
      std::string buff;
      std::ifstream in;
      in.open(filename.c_str());
      if(!in.good())
	{
	  //return false or crash?.. at this moment I'll just crash.
	  logger<<"Could not find file:"<<filename<<std::endl;
	  return false;
	}
      int format;
      std::getline(in,buff,':');
      in>>format;
      in.ignore();
      if(format == 1)
	{
	  ptr_newScene=loadFormat1Ascii(in,filename);
	  if( !ptr_newScene )
	    {
	      return false;
	    }
	}
    }
  updateSceneNodeIdToInternalValues(ptr_newScene);
  return true;
}

cSpatialNode* cScenegraph::loadFormat1Ascii(std::ifstream &in,const std::string &filename)
{

  cSpatialNode *ptr_root = new cSpatialNode(this);
  ptr_root->m_ID=-1;
  ptr_root->Name()=filename;

  int nrOfHierarchies;
  std::string buff;
  std::getline(in,buff,':');
  in>>nrOfHierarchies;

  for(int i=0; i<nrOfHierarchies; i++)
    {
      int nodesInHier;
      std::getline(in,buff,':');
      in>>nodesInHier;
      in.ignore();
      for(int j=0; j < nodesInHier; j++)
	{
	  cSpatialNode *ptr_node=0;
	  std::getline(in,buff);
	 
	  if(buff=="mesh")
	    {
	      ptr_node = new cGeometryNode(this);
	    }
	  else if(buff=="spatial")
	    {
	      ptr_node = new cSpatialNode(this);
	    }
	  if(!ptr_node)
	    {
	      std::cout<<"BAD LOADING:"<<buff<<" h:"<<i<<" j:"<<j<<std::endl;
	      return 0;
	    }

	  if(!ptr_node->loadNode(in,false,1))
	    {
	      return 0;
	    }

	  in.ignore();
	  //we have now loaded the node. time to place it in the tree/scene.
	  cSpatialNode *ptr_parent=ptr_root->getNode( ptr_node->getParentId() );
	  ptr_parent->addChild(ptr_node);
	}
    }
  return ptr_root;
}

cSpatialNode* cScenegraph::loadFormat1Bin(std::ifstream &in,const std::string &filename)
{
  cSpatialNode *ptr_root = new cSpatialNode(this);
  ptr_root->m_ID=-1;
  ptr_root->Name()=filename;
  int nrOfHierarchies;
  in.read(reinterpret_cast<char*>(&nrOfHierarchies),sizeof(int));
  for(int j=0; j < nrOfHierarchies; j++)
    {
      int nodesInHier;
      in.read(reinterpret_cast<char*>(&nodesInHier),sizeof(int));
      for(int j=0; j < nodesInHier; j++)
	{
	  std::string keyword;
	  char c=in.get();
	  while(c!='\0')
	    {
	      keyword+=(c);
	      c=in.get();
	    }
	  cSpatialNode *ptr_node=0;
	  if(keyword=="mesh")
	    {
	      ptr_node = new cGeometryNode(this);
	    }
	  else if(keyword=="spatial")
	    {
	      ptr_node = new cSpatialNode(this);
	    }
	  if(!ptr_node->loadNode(in,true,1))
	    {
	      return 0;
	    }
	  //we have now loaded the node. time to place it in the tree/scene.
	  cSpatialNode *ptr_parent=ptr_root->getNode( ptr_node->getParentId() );
	  ptr_parent->addChild(ptr_node);
	}
    }
  return ptr_root;
}


//GLOBAL HACCCCCK!! ('n slash)

fusa::cScenegraph* fusa::Scenegraph()
{
  static cScenegraph* ptr_scenegraph = new cScenegraph;
  return ptr_scenegraph;

}

void cScenegraph::update(float t)
{
  recursiveUpdate(mptr_root,t);
}

void cScenegraph::recursiveUpdate(cSpatialNode* ptr_node,float t)
{




  ptr_node->preUpdate(t,ptr_node->getParent());

  ptr_node->postUpdate(t);


  //go through recursivly.


  std::list<cSpatialNode*>::iterator it = ptr_node->m_children.begin();
  while(it!=ptr_node->m_children.end())
    {
      recursiveUpdate(*it,t);

      it++;
    }
}

void cScenegraph::insertNodeAsParent(cSpatialNode *ptr_insertNode, const std::string &name)
{
  insertNodeAsParent(ptr_insertNode, getNode(name) );
}

void cScenegraph::insertNodeAsParent(cSpatialNode *ptr_insertNode,cSpatialNode *ptr_node)
{
  ptr_node->insertNodeAsParent(ptr_insertNode);
}

void cScenegraph::insertNodeAsParent(cSpatialNode *ptr_insertNode,int nodeId)
{
  insertNodeAsParent(ptr_insertNode, getNode(nodeId) );
}


cSpatialNode* cScenegraph::addFileToScene(const std::string &filename,bool binForm,cSpatialNode* ptr_root)
{
  cSpatialNode *ptr_topNode=0;
  bool result=false;

  if(binForm)
    {
      std::ifstream in;
      in.open(filename.c_str(),std::ios::binary);
      if(!in.good())
	{
	  //return false or crash?.. at this moment I'll just crash.
	  logger<<"Could not find file:"<<filename<<std::endl;
	  return false;
	}
      int format=0;
      in.read(reinterpret_cast<char*>(&format),sizeof(int));
      if(format == 1)
	{
	  ptr_topNode=loadFormat1Bin(in,filename);
	}
    }
  else
    {
      std::string buff;
      std::ifstream in;
      in.open(filename.c_str());
      if(!in.good())
	{
	  //return false or crash?.. at this moment I'll just crash.
	  logger<<"Could not find file:"<<filename<<std::endl;
	  return false;
	}
      int format;
      std::getline(in,buff,':');
      in>>format;
      in.ignore();
      if(format == 1)
	{
	  ptr_topNode = loadFormat1Ascii(in,filename);
	}
    }

  //we now have newTree which contains the new subtree.

  if(!ptr_topNode)
    {
      return 0;
    }
  //first go through new tree and update id's.
  updateSceneNodeIdToInternalValues(ptr_topNode);

  //then add it to the scene.
  if(ptr_root)
    {
      ptr_root->addChild(ptr_topNode);
    }
  else
    {
      mptr_root->addChild( ptr_topNode );
    }

  //it is a double pointer since we are changing the address of the pointer.
  return ptr_topNode;


}


void cScenegraph::updateSceneNodeIdToInternalValues(cSpatialNode *ptr_node)
{

  cSpatialNode* ptr_par = ptr_node->getParent();
  if(ptr_par)
    {
      ptr_node->mptr_parentID=ptr_par->getId();
    }
  else
    {
      ptr_node->mptr_parentID=-1;
    }


  //go through recursivly.
  std::list<cSpatialNode*>::iterator it = ptr_node->ChildList().begin();
  while(it!=ptr_node->ChildList().end())
    {
      updateSceneNodeIdToInternalValues(*it);
      it++;

    }

}

void cScenegraph::setActiveCamera(cCameraNode *cam)
{
  m_activeCamera = cam;
}

cSpatialNode* cScenegraph::createSpatialNode()
{
  cSpatialNode *ptr_newNode = new cSpatialNode(this);
  ptr_newNode->m_ID = generateId();
  return ptr_newNode;
}


cGeometryNode* cScenegraph::createGeometryNode()
{
  cGeometryNode *ptr_newNode = new cGeometryNode(this);
  ptr_newNode->m_ID = generateId();
  return ptr_newNode;
}

cCameraNode* cScenegraph::createCameraNode()
{
  cCameraNode *ptr_newNode = new cCameraNode(this);
  cameras.push_back(ptr_newNode);
  ptr_newNode->m_ID = generateId();
  return ptr_newNode;
}

cLinkNode* cScenegraph::createLinkNode()
{
  cLinkNode *ptr_newNode = new cLinkNode(this);
  ptr_newNode->m_ID = generateId();
  return ptr_newNode;
}

cParticleNode* cScenegraph::createParticleNode()
{
  cParticleNode *ptr_newNode = new cParticleNode(this);
  ptr_newNode->m_ID = generateId();
  return ptr_newNode;
}

void cScenegraph::setRenderBool(bool doRender)
{
  m_doRender = doRender;
}

bool cScenegraph::shouldGetRendered()const
{
  return m_doRender;
}

cSpatialNode* cScenegraph::getRoot()
{
  return mptr_root;
}

cCameraNode* cScenegraph::getActiveCamera()
{
  return m_activeCamera;
}

cSpatialNode* cScenegraph::getNode(const std::string &name)const
{
  return mptr_root->getNode(name);
}

cSpatialNode* cScenegraph::getNode(int id)const
{
  return mptr_root->getNode(id);
}

void cScenegraph::deleteWholeScenegraph()
{
  deleteRecursive(mptr_root);
}

void cScenegraph::deleteRecursive(cSpatialNode *ptr_node)
{
  std::list<cSpatialNode*>::iterator it = ptr_node->ChildList().begin();
  while(it!=ptr_node->ChildList().end())
    {
      deleteRecursive(*it);
      it++;

    }
  //we are now at node which have visited all his children, so delete it.
  delete ptr_node;
}

unsigned int cScenegraph::getNumberOfCameras()const
{
  return cameras.size();
}

cCameraNode* cScenegraph::getCamera(unsigned int i)
{
  if ( i < cameras.size() )
    {
      return cameras[i];
    }
  
  return 0;
}

void cScenegraph::deleteNodeAndSubtree(cSpatialNode *ptr_deleteNode)
{
  //find this item in the parents childList .. unless the ptr_deleteNode has no parent
  cSpatialNode* ptr_delParent = ptr_deleteNode->getParent();
  if(ptr_delParent != 0)
    {
      std::list<cSpatialNode*>::iterator it = ptr_delParent->ChildList().begin();
      while(it != ptr_delParent->ChildList().end())
	{
	  if( (*it) == ptr_deleteNode)
	    {
	      ptr_delParent->ChildList().erase(it);
	      break;
	    }

	  it++;
	}
    }
  deleteRecursive(ptr_deleteNode);
}

void cScenegraph::deleteNode(cSpatialNode *ptr_deleteNode,cSpatialNode* ptr_replaceNode)
{
  //find this item in the parents childList .. unless the ptr_deleteNode has no parent
  cSpatialNode* ptr_delParent = ptr_deleteNode->getParent();
  if(ptr_delParent != 0)
    {
      std::list<cSpatialNode*>::iterator it = ptr_delParent->ChildList().begin();
      while(it != ptr_delParent->ChildList().end())
	{
	  if( (*it) == ptr_deleteNode)
	    {
	      (*it) = ptr_replaceNode;
	      break;
	    }

	  it++;
	}
    }

  //now take all the children of ptr_deleteNode and add to ptr_replaceNode.
  //also adjust parent-link.
  std::list<cSpatialNode*>::iterator it = ptr_deleteNode->ChildList().begin();
  while(it != ptr_deleteNode->ChildList().end())
    {
      (*it)->mptr_parent = ptr_replaceNode;
      ptr_replaceNode->addChild(*it);
    }

  //all childs of ptr_deleteNode transfered to ptr_replaceNode, so this will not cause memory leak.
  ptr_deleteNode->ChildList().clear();
  delete ptr_deleteNode;

}

void cScenegraph::deleteNode(cSpatialNode *ptr_deleteNode)
{
  //find this item in the parents childList .. unless the ptr_deleteNode has no parent
  cSpatialNode* ptr_delParent = ptr_deleteNode->getParent();
  if(ptr_delParent != 0)
    {
      std::list<cSpatialNode*>::iterator it = ptr_delParent->ChildList().begin();
      while(it != ptr_delParent->ChildList().end())
	{
	  if( (*it) == ptr_deleteNode)
	    {
	      ptr_delParent->ChildList().erase(it);
	      break;
	    }

	  it++;
	}
    }

  delete ptr_deleteNode;

}

void cScenegraph::getCulledRenderList(unsigned int cameraNr,std::vector<cSpatialNode*> &crl)
{
  cCameraNode *ptr_cam = getCamera(cameraNr);
  if(ptr_cam)
    {
      recursiveCull(crl,ptr_cam,mptr_root);
    }

}



void cScenegraph::recursiveCull(std::vector<cSpatialNode*> &crl,cCameraNode *ptr_cam, cSpatialNode *ptr_node)
{



  //if(ptr_node->cullingSphereOutsideCamFrustrum(ptr_cam))
  {
    //don't bother visiting childs of this node.
    ////std::cout<<"culling away:"<<ptr_node->Name()<<std::endl;
    //return;
  }//*/

  //passed the tests, toss into list.
  //but first, check if this node actually is something we want to render.
  if(!ptr_node->getWorldShouldRender())
    {
      return;
    }
  if(ptr_node->getNodeType() == cSpatialNode::ntGeometry || ptr_node->hasLocalRenderState()==true || ptr_node->getNodeType() == cSpatialNode::ntLink)
    {
      if(ptr_node->getWorldShouldRender())
	crl.push_back(ptr_node);
    }

  std::list<cSpatialNode*>::iterator it = ptr_node->ChildList().begin();
  while(it!=ptr_node->ChildList().end())
    {

      recursiveCull(crl,ptr_cam,*it);
      it++;
    }
}

cScenegraph::~cScenegraph()
{
  deleteWholeScenegraph();
}
