#ifndef H_xxFUSA_GEOMETRYNODExx_H
#define H_xxFUSA_GEOMETRYNODExx_H
#include "fusa_spatialNode.h"
#include "fusa_mesh.h"
#include "../renderer/fusa_hardmesh.h"
#include <string>
/*******************************************************

Original Author...Hvard Christensen
Purpose...........Geometry node for scenegraph

Description:
This is the geometry node. it is the only node that is renderable by the renderer.


*/
namespace fusa
{
  /*!
    @class cGeometryNode
    @brief this is a geometry node, it derives cSpatialNode. It contains data to be drawn by the renderer.
  */
  class cGeometryNode : public cSpatialNode
  {
  public:
    friend class cScenegraph;
    friend class cOglRenderer;
    friend class cOglEs2Renderer;
		
    ///loads up a geometry node given instream, binary format flag and version number. returns true on success, false on error.
    bool loadNode(std::ifstream &in, bool binForm,int versionForm);
		
    ///for a geometry node, this returns ntGeometry
    virtual NodeType getNodeType()const;

    ///pickNode is able to pick node based on active camera. returns true if mouse pointer is intersecting object.
    ///user must do the mouse input himself.
    bool pickNode()const;

    ///The mesh containing the geometrical data.
    cMesh mesh;
    cHardMesh *mptr_hMesh;
  protected:
		
    ///protected constructor. This is because only the cScenegraph should be able to create a node of cGeometryNode.
    cGeometryNode(cScenegraph *ptr_sceneLink);

    //this is something the renderer uses to generate buffer id's
    //for gfx-adapter geometrical data buffers.
    int generateNewId()
    {
      m_bufferId=genBufferIdCounter;
      return genBufferIdCounter++;
    }

    int getBufferId()
    {
      return m_bufferId;
    }
    static int genBufferIdCounter;

    int m_bufferId;
	
  };
}

#endif
