#ifndef H_xxFUSA_CCAMERANODExx_H
#define H_xxFUSA_CCAMERANODExx_H

#include "../math/fusa_mathincludes.h"
#include <iostream>
#include "fusa_spatialNode.h"
#include "../renderer/fusa_framebuffer.h"

/*******************************************************

Original Author...Hvard Christensen
Purpose...........camera node.

Description:
This is a spatial camera node.

********************************************************/


//TODO:
/*
- Create code/functionality for perspective settings.
*/
#include <utility>
#include <vector>



namespace fusa
{

	/*!
	@class cCameraPass
	@brief this is a camera pass.
	*/
	struct cCameraPass
	{
		cCameraPass()
		{
			m_shouldOnlyRenderWhenActive=true;
		}
		///Nodes to render.
		/*! contains things to render, the integer is the renderpass. renderpass 0 is always the one used for
		rendering to the window (the visible window). This renders things in a recursive fashion.
		inserting root into this renderpass, will send the whole scenegraph to rendering.
		use m_thingsToBlock for blocking/disabling the rendering of certain subtrees.
		*/
		std::vector< std::pair<cSpatialNode*,int> > m_thingsToRender;

		///Nodes to block.
		/*! contains nodes/subtrees that will get blocked when rendering.
		  i.e , if you have a scene with one root, and three subtrees trolls, humans and wizards, and insert
		  the troll-node (top-node of a subtree), into the block-list , the pass will render
		  all humans and wizards.
		*/
		std::vector< cSpatialNode* > m_thingsToBlock;


		///this is a variable that, if true, only renders this camerapass when the camera
		///is the active one (the one being used to render to screen).
		///it is a temporary solution to a design problem, which I do not have time to fix.
		bool m_shouldOnlyRenderWhenActive;

	protected:



	private:

	};

	/*!
	@class cCameraNode
	@brief this is a camera node, it derives cSpatialNode.
	*/
	class cCameraNode : public cSpatialNode
	{
	public:
		friend class cScenegraph;
		NodeType getNodeType()const
		{
			return ntCamera;
		}

		///gets the translation you need to apply to models for the camera to take effect.
		cVec3f getCameraPositionTransform()const;

		///gets the rotational transform you need to apply to models for the camera to take effect.
		cQuat<float> getCameraRotationTransform()const;

		///takes camera and looks at position. upvec is upvec.
		void lookAt(const cVec3f &lookPos,const cVec3f& upVec);

		///Camera Perspective
		/*!
		sets camera perspective by giving fovy, aspect and zNear,zFar.
		FIX_ME currently there are some bugs here as some values of fovy will make it odd.
		*/
		void setPerspective(float fovy, float aspect,float zNear,float zFar);

		cMatrix4<float> getProjectionMatrix()const;

		///Add a cameraPass..
		/*!Remember important to notice! the nodes added to the cameraPass will be treated recursivly
		if you add the root of the scenegraph, it will render the whole scenegraph in a recursive fashion.*/
		void addCameraPass(const cCameraPass &camPass);
		std::vector<cCameraPass>& getCameraPasses(){return cameraPasses ;}

		///gets the number of passes this camera will render.
		int getNrOfCameraPasses()const;

		///gets reference to the camerapass at index i
		cCameraPass& AccessCameraPass(int i);

		///gets const  reference to the camerapass at index i
		const cCameraPass& AccessCameraPass(int i)const;

		bool& UseLookAtData()
		{
			return m_useLookAt;
		}

		//FIX_ME look-at-hack.
		cVec3f m_camLookAtTarget;
		cVec3f m_camLookAtUpVec;


	protected:
		cCameraNode(cScenegraph *ptr_sceneLink);

		bool m_renderToRtt;
		int m_rttId;

		cMatrix4<float> m_projMatrix;
		bool m_useLookAt;



		//a Camera might do different passes.
		std::vector<cCameraPass> cameraPasses;


	};
}

#endif
