#include "fusa_hardmesh.h"
#include "fusa_material.h"
#include "fusa_shader.h"
#include <fstream>
using namespace fusa;

cBufferData::cBufferData()
{
  m_target =GL_ELEMENT_ARRAY_BUFFER;
  m_bytesPerChannel = 0;
  m_channelsPerElement = 0;
  m_nrOfElements = 0;
  glGenBuffers(1,&m_buffer);
  m_usage = GL_STATIC_DRAW;
  m_hasDataStored = false;
}

void cBufferData::saveToFile(std::ofstream &f_out)
{
  void *data=0;
  glBindBuffer(m_target,m_buffer);
  data = glMapBuffer(m_target,GL_READ_ONLY);
  if(!data)
    return;
  f_out.write(reinterpret_cast<const char*>(&m_usage),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(&m_target),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(&m_bytesPerChannel),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(&m_nrOfElements),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(&m_channelsPerElement),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(&m_type),sizeof(GLint));
  f_out.write(reinterpret_cast<const char*>(data),m_bytesPerChannel*m_channelsPerElement*m_nrOfElements);
  glUnmapBuffer(m_target);
}

void cBufferData::loadFromFile(std::ifstream &f_in )
{
  f_in.read(reinterpret_cast<char*> (&m_usage),sizeof(GLint));
  f_in.read(reinterpret_cast<char*> (&m_target),sizeof(GLint));
  f_in.read(reinterpret_cast<char*> (&m_bytesPerChannel),sizeof(GLint));
  f_in.read(reinterpret_cast<char*> (&m_nrOfElements),sizeof(GLint));
  f_in.read(reinterpret_cast<char*> (&m_channelsPerElement),sizeof(GLint));
  f_in.read(reinterpret_cast<char*> (&m_type),sizeof(GLint));
  std::vector<char> buffer(m_bytesPerChannel*m_channelsPerElement*m_nrOfElements);
  f_in.read(&buffer[0],m_bytesPerChannel*m_channelsPerElement*m_nrOfElements);
  storeData(m_target,m_bytesPerChannel,m_channelsPerElement,m_nrOfElements,
	    m_type,&buffer[0],m_usage);

}

    

void cBufferData::storeData(GLint target,GLint bytePerChannel,
			    GLint channelsPerElement,
			    GLint nrOfElements,
			    GLint type,
			    const void *data,GLint usage)
{
  m_target = target;
  m_usage = usage;
  m_hasDataStored = true;
  m_bytesPerChannel = bytePerChannel;
  m_channelsPerElement = channelsPerElement;
  m_nrOfElements =  nrOfElements;
  m_type = type;
  glBindBuffer(m_target,m_buffer);
  glBufferData(m_target,m_bytesPerChannel*m_channelsPerElement*m_nrOfElements,
	       data,m_usage);
}


void cBufferData::sendData( GLint nrOfElements,
			   const void *data,unsigned int offset)
{

  if(m_usage!=GL_STATIC_DRAW && m_hasDataStored==true)
    {
      glBindBuffer(m_target,m_buffer);
      glBufferSubData(m_target,offset*m_bytesPerChannel*m_channelsPerElement,
		      m_bytesPerChannel*m_channelsPerElement*nrOfElements,
		      data);
    }
}



void cHardMesh::draw(cShader *shade,GLint drawType)
{
	
  if(shade)
    {
      shade->activate();
      std::map<std::string,cBufferData>::iterator it = m_attribBuffer.begin();
      while(it!=m_attribBuffer.end())
	{
	  GLint loc = shade->getAttribLocation(it->first);
	  if(loc!=-1)
	    {
	      glEnableVertexAttribArray(loc);
	      glBindBuffer(it->second.m_target,it->second.m_buffer);
	      glVertexAttribPointer(loc,it->second.m_channelsPerElement,
				    it->second.m_type,false,0,0);
	    }
	  it++;
	}
    }

  glEnableClientState(GL_VERTEX_ARRAY);
  glBindBuffer(m_vertices.m_target,m_vertices.m_buffer);
  glVertexPointer(m_vertices.m_channelsPerElement, m_vertices.m_type, 0, 0);

  bool pointDrawing = false;

  if(drawType!=GL_POINTS)
    {
      glBindBuffer(m_indices.m_target,m_indices.m_buffer);
      glDrawElements(drawType,
		     m_indices.m_channelsPerElement*m_indices.m_nrOfElements,
		     m_indices.m_type,0);
    }
  else
    {
      glDrawArrays(GL_POINTS,0,m_vertices.m_nrOfElements);
    }

  if(shade)
    {
      std::map<std::string,cBufferData>::iterator it = m_attribBuffer.begin();
      while(it!=m_attribBuffer.end())
	{
	  GLint loc = shade->getAttribLocation(it->first);
	  if(loc!=-1)
	    {
	      glDisableVertexAttribArray(loc);
	    }
	  it++;
	}
    }

  glDisableClientState(GL_VERTEX_ARRAY);
  
}

void cHardMesh::saveToFile(std::ofstream &f_out)
{
  m_vertices.saveToFile(f_out);
  m_indices.saveToFile(f_out);
  unsigned int nrOfAttribs = m_attribBuffer.size();
  f_out.write(reinterpret_cast<const char*>(&nrOfAttribs),sizeof(unsigned int));
  for(std::map<std::string,cBufferData>::iterator it=m_attribBuffer.begin();
      it!=m_attribBuffer.end(); it++)
    {
      f_out.write(reinterpret_cast<const char*> (&it->first[0]),
		  it->first.size());
      f_out.put(0);
      it->second.saveToFile(f_out);
    }
}

void cHardMesh::loadFromFile(std::ifstream &f_in)
{
  if(f_in.is_open())
    {
      m_vertices.loadFromFile(f_in);
      m_indices.loadFromFile(f_in);
      unsigned int nrOfAttribs=0;
      f_in.read(reinterpret_cast<char*>(&nrOfAttribs),sizeof(unsigned int));
      for(unsigned int i=0; i < nrOfAttribs; i++)
	{
	  std::string attribName;
	  cBufferData attrib;
	  char c;
	  c = f_in.get();
	  while(c!=0)
	    {
	      attribName+=c;
	      c = f_in.get();
	    }
	  attrib.loadFromFile(f_in);
	  m_attribBuffer[attribName] = attrib;
	}
      
    }
}

void cHardMesh::saveToFile(const std::string &filename)
{
  std::ofstream f_out;
  f_out.open(filename.c_str(),std::ios::binary);
  saveToFile(f_out);
  f_out.close();
}

void cHardMesh::loadFromFile(const std::string &filename)
{
	std::string fn = "data\\" + filename;
  std::ifstream f_in;
  f_in.open(fn.c_str(),std::ios::binary);
  loadFromFile(f_in);
  f_in.close();
  
}
