/*******************************************************
Original Author...Hvard Christensen
Purpose...........fixed point types

Description:
This file contains fixed point types. The fixed point types use a short type (16 bit on most platforms).
a fixed point type represents fractions with a given amount of bits. i.e 8 bit for fraction, 8 for integer.
this file contains.
cFPVal	a signed fixed point using 4 bits for fraction
cFPValFrac8Signed	a signed fixed point using 8 bits for fraction
cFPValFrac12Signed	a signed fixed point using 12 bits for fraction
cFPValFrac14Signed	a signed fixed point using 14 bits for fraction

********************************************************/


//TODO:
/*
- needs to be tested in action to iron out any hidden bugs.
*/

#ifndef H_xxFUSA_FIXEDPOINTTYPESxx_H
#define H_xxFUSA_FIXEDPOINTTYPESxx_H
#include <cmath>
#include <iostream>

namespace fusa
{

	///a fixed point with 4 bits for fraction. every fixed point is 16 bit in total.
	template<int bitsForFraction,class Ta>
	class cFPVal
	{
		///fixed point value
		/**this is a fixed point value class. it operates like a float, but does calculations in fixed point on a short type., values from -2048 to 2048 + fraction
		*/
	public:

		//friend std::ostream& operator<<(std::ostream &os,cFPVal fp);
		//friend std::istream& operator>>(std::istream &in,cFPVal &fp);

		cFPVal()
		{
			m_data=0;
		}
		
		cFPVal(const cFPVal &dataIn)
		{
			m_data=dataIn.m_data;
		}
		
		cFPVal(float dataIn)
		{
			m_data = std::floor(dataIn*(1<<bitsForFraction));
		}

		cFPVal(const double &dataIn)
		{
			m_data = std::floor(dataIn*(1<<bitsForFraction));
		}

		cFPVal(int dataIn)
		{
			m_data = dataIn<<bitsForFraction;
		}

		cFPVal(short dataIn)
		{
			m_data = dataIn<<bitsForFraction;
		}

		const cFPVal& operator=(float dataIn)
		{
			m_data = std::floor(dataIn*bitsForFraction);
			return *this;
		}

		const cFPVal& operator=(const double &dataIn)
		{
			m_data = std::floor(dataIn*(1<<bitsForFraction));
			return *this;
		}

		
		const cFPVal& operator=(Ta dataIn)
		{
			m_data = dataIn<<bitsForFraction;
			return *this;
		}

		const cFPVal& operator=(const cFPVal &dataIn)
		{
			m_data = dataIn.m_data;
			return *this;
		}

		cFPVal operator+(cFPVal val)const
		{
			cFPVal res;
			res.m_data = val.m_data + m_data;
			return res;
		}

		cFPVal operator-(cFPVal val)const
		{
			cFPVal res;
			res.m_data = val.m_data - m_data;
			return res;
		}

		cFPVal operator*(cFPVal val)const
		{
			cFPVal res;
			res.m_data = (val.m_data * m_data)>>bitsForFraction;
			
			return res;	
		}

		cFPVal operator/(cFPVal val)const
		{
			cFPVal res;
			res.m_data = (m_data / (val.m_data>>bitsForFraction));
			return res;
		}

		void operator+=(cFPVal val)
		{
			m_data+=val.m_data;
		}

		void operator-=(cFPVal val)
		{
			m_data-=val.m_data;
		}

		void operator*=(cFPVal val)
		{
			m_data= (val.m_data * m_data)>>bitsForFraction;
		}

		void operator/=(cFPVal val)
		{
			m_data = (m_data / (val.m_data>>bitsForFraction));
		}

		float getFloatRepresentation()const
		{
			float divisor = (1 << bitsForFraction);
			Ta mask = (1 << (bitsForFraction)) -1;
			return (((m_data) >> bitsForFraction ) + ((m_data & mask)/divisor));		
			
		}

		int getNrOfBitsForFractions()
		{
			return bitsForFraction;
		}

		int getTotalBitSizeOfType()
		{
			return sizeof(Ta);
		}
	
		bool operator<(cFPVal val)const
		{
			return (m_data<val.m_data);
		}

		bool operator>(cFPVal val)const
		{
			return (m_data>val.m_data);
		}


		bool operator<=(cFPVal val)const
		{
			return (m_data<=val.m_data);
		}

		bool operator>=(cFPVal val)const
		{
			return (m_data>=val.m_data);
		}

		bool operator<(float val)const
		{
			cFPVal test(val);
			return (m_data<test.m_data);
		}

		bool operator>(float val)const
		{
			cFPVal test(val);
			return (m_data>test.m_data);
		}

		bool operator<=(float val)const
		{
			cFPVal test(val);
			return (m_data<=test.m_data);
		}

		bool operator>=(float val)const
		{
			cFPVal test(val);
			return (m_data>=test.m_data);
		}
		
		bool operator==(cFPVal val)const
		{
			return (m_data==val.m_data);
		}

		bool operator==(float val)const
		{
			cFPVal test(val);
			return (m_data==test.m_data);
		}

		bool operator!=(cFPVal val)const
		{
			return !(*this==val);
		}

		bool operator!=(float val)const
		{
			return !(*this==val);
		}

		///this gets the integer value of the fixed point. it is mainly used for printing.
		Ta& AccessFixedPointAsIntegerValue()
		{
			return m_data;
		}

		Ta AccessFixedPointAsIntegerValue()const
		{
			return m_data;
		}

	protected:
		Ta m_data;
		
	};



	template<int bitsForFractions,class Ta>
	cFPVal<bitsForFractions,Ta> operator+(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> res(f);
		res+=fp;
		return res;
	}

	template<int bitsForFractions,class Ta>
	cFPVal<bitsForFractions,Ta> operator-(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> res(f);
		res-=fp;
		return res;
	}

	template<int bitsForFractions,class Ta>
	cFPVal<bitsForFractions,Ta> operator*(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> res(f);
		res*=fp;
		return res;
	}

	template<int bitsForFractions,class Ta>
	cFPVal<bitsForFractions,Ta> operator/(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> res(f);
		res/=fp;
		return res;
	}

	template<int bitsForFractions,class Ta>
	bool operator<(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> test(f);
		return (test<fp);
	}

	template<int bitsForFractions,class Ta>
	bool operator>(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> test(f);
		return (test>fp);
	}

	template<int bitsForFractions,class Ta>
	bool operator<=(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> test(f);
		return (test<=fp);
	}

	template<int bitsForFractions,class Ta>
	bool operator>=(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> test(f);
		return (test>=fp);
	}

	template<int bitsForFractions,class Ta>
	bool operator==(float f,cFPVal<bitsForFractions,Ta> fp)
	{
		cFPVal<bitsForFractions,Ta> test(f);
		return (test==fp);
	}

	template<int bitsForFractions,class Ta>
	std::ostream& operator<<(std::ostream &os,cFPVal<bitsForFractions,Ta> fp)
	{
		os<<fp.AccessFixedPointAsIntegerValue();
		return os;
	}

	template<int bitsForFractions,class Ta>
	std::istream& operator>>(std::istream &is,cFPVal<bitsForFractions,Ta> &fp)
	{
		is>>fp.AccessFixedPointAsIntegerValue();
		return is;
	}

	typedef cFPVal<4,short> cFPSignShort4;
	typedef cFPVal<8,short> cFPSignShort8;
	typedef cFPVal<12,short> cFPSignShort12;
	typedef cFPVal<14,short> cFPSignShort14;

	typedef cFPVal<4,unsigned short> cFPUsignShort4;
	typedef cFPVal<8,unsigned short> cFPUsignShort8;
	typedef cFPVal<12,unsigned short> cFPUsignShort12;
	typedef cFPVal<14,unsigned short> cFPUsignShort14;

	typedef cFPVal<4,int> cFPSignInt4;
	typedef cFPVal<8,int> cFPSignInt8;
	typedef cFPVal<12,int> cFPSignInt12;
	typedef cFPVal<16,int> cFPSignInt16;
	typedef cFPVal<20,int> cFPSignInt20;
	typedef cFPVal<24,int> cFPSignInt24;
	typedef cFPVal<28,int> cFPSignInt28;
	typedef cFPVal<30,int> cFPSignInt30;

	typedef cFPVal<4,unsigned int> cFPUsignInt4;
	typedef cFPVal<8,unsigned int> cFPUsignInt8;
	typedef cFPVal<12,unsigned int> cFPUsignInt12;
	typedef cFPVal<16,unsigned int> cFPUsignInt16;
	typedef cFPVal<20,unsigned int> cFPUsignInt20;
	typedef cFPVal<24,unsigned int> cFPUsignInt24;
	typedef cFPVal<28,unsigned int> cFPUsignInt28;
	typedef cFPVal<30,unsigned int> cFPUsignInt30;
}
#endif
