/*******************************************************

Original Author...Christer Vasseng
Creation Date.....
Last Modified.....
Purpose...........Wrap static + dynamic values in one package
				  for easy switching between the two

Description:


********************************************************/

#ifndef h__fusa_animatableObjects__
#define h__fusa_animatableObjects__

//TODO: Consider auto-assigning; is there a better way?

#include "fusa_controllerServer.h"

namespace fusa
{
	///Types of animatable objects
	enum AnimatableObjectTypes
	{
		aotNone,
		aotFloat,
		aotVec2f,
		aotVec3f,
		aotVec4f,
		aotQuaternion,
	};

	///Small base class for animatable objects in case someone wants to stack different types..
	class cAnimatableObject
	{
	public:
		///Constructor
		cAnimatableObject()
		{
			mptr_assignedController = 0;
			m_controllerID = -1;
			m_autoAssign = false;
		}
		///Sets the selected controller in the assigned controller server
		void setControllerResourceID(unsigned int id)
		{
			m_controllerID = id;
		}
		///Return the ID of the current assigned controller
		unsigned int getControllerResourceID()const
		{
			return m_controllerID;
		}
		///sets the controller server used for the object
		void assignController(cControllerServer *ptr_control)
		{
			mptr_assignedController = ptr_control;
		}
		//Remove the assigned controller
		void clearAssignedController()
		{
			mptr_assignedController = 0;
		}
		///Return the type of the object
		virtual AnimatableObjectTypes getType(){ return aotNone; }
		//returns true if no controller is assigned
		bool isStatic()const
		{
			if (m_controllerID<0 || !mptr_assignedController)
				return true;
			return false;
		}
		///Auto assign controller id based on the first component of the controller
		void setAutoAssignControllerID(bool val)
		{
			m_autoAssign = val;
		}
		
	protected:
		cControllerServer *mptr_assignedController;
		unsigned int m_controllerID;
		bool m_autoAssign;
	private:
		
	};

	///Animatable float object
	class cAnimatableFloat : public cAnimatableObject
	{
	public:
		cAnimatableFloat()
		{
			cAnimatableObject::cAnimatableObject();
			m_activeComponent = 1;
			m_link = 0;
		}

		~cAnimatableFloat()
		{
			
		}

		///Attach a link to the object
		void attachAnimatable(cAnimatableFloat *ptr_obj)
		{
			//ptr_obj->childLink(this);
			m_link = ptr_obj;
		}

		///remove link
		void flushAnimatable()
		{
			m_link = 0;
		}

		///Set the static value of the object
		void setValue(float val)
		{
			if (m_autoAssign)
				setControllerResourceID((int)val);
			m_staticValue = val;
		}

		///Set the active (used) component for the controller
		void setActiveComponent(int component) //0 = x, 1 = y, 2 = z
		{
			if (component > 3)
			{
				component = 3;
			}

			if (component < 1)
			{
				component  = 1;
			}

			m_activeComponent = component;
		}	

		///Get the value of the object
		float getValue(float t)const
		{	
		//	if (m_autoAssign)
//				m_controllerID = m_staticValue;
			if (m_link)
			{
				return m_link->getValue(t);
			}

			if (mptr_assignedController && m_controllerID >= 0)
				if (m_controllerID < mptr_assignedController->getNrOfControllers())
			{
				
				if (m_activeComponent == 1)
					return mptr_assignedController->getController(m_controllerID)->getData(t).x;
				if (m_activeComponent == 2)
					return mptr_assignedController->getController(m_controllerID)->getData(t).y;
				if (m_activeComponent == 3)
					return mptr_assignedController->getController(m_controllerID)->getData(t).z;
			}
			return m_staticValue;
		}
	protected:
	private:
		float m_staticValue;
		int m_activeComponent;
		cAnimatableFloat* m_link;
	};

	///Animatable vec3
	class cAnimatableVec3f : public cAnimatableObject
	{
	public:
		cAnimatableVec3f()
		{
			cAnimatableObject::cAnimatableObject();
			m_link = 0;
		}

		~cAnimatableVec3f()
		{
			
		}

		///Attach a link to another animatable vec3
		void attachAnimatable(cAnimatableVec3f *ptr_obj)
		{
			//ptr_obj->childLink(this);
			m_link = ptr_obj;
		}

		///Remove link
		void flushAnimatable()
		{
			m_link = 0;
		}

		///Return the value of the object
		const cVec3f getValue(float t)const
		{
			
			if (m_link)
			{
				return m_link->getValue(t);
			}

		//	if (m_autoAssign)
			//	m_controllerID = (unsigned int) m_staticData.x;
		

			if (mptr_assignedController)
			{
				if (m_controllerID < mptr_assignedController->getNrOfControllers())
				{
					cVec3f tmp = mptr_assignedController->getController(m_controllerID)->getData(t); 
					return tmp;
				}
			}
			return m_staticData;
		}
		///Set the static value
		void setValue(cVec3f value)
		{
			if (m_autoAssign)
				setControllerResourceID((int)value.x);
			m_staticData = value;
			//std::cout << m_staticData << std::endl;
		}
	protected:
		cAnimatableVec3f* m_link;
	private:
		cVec3f m_staticData;
	};

}
#endif
