#ifndef H_xxFUSA_GLHELPxx_H
#define H_xxFUSA_GLHELPxx_H
#include "../OGLIncludes.h"
#include <string>
#include <map>

namespace fusa
{
static std::map<std::string,GLint> convMap;
static std::map<GLint,std::string> convMapRev;

class cGlHelpConverterMachine
{
public:
  cGlHelpConverterMachine()
    {
      //back front lols
      addConversion("GL_BACK",GL_BACK);
      addConversion("GL_FRONT",GL_FRONT);

      //primitives
      addConversion("GL_TRIANGLES",GL_TRIANGLES);
      addConversion("GL_POINTS",GL_POINTS);
      addConversion("GL_LINES",GL_LINES);
      addConversion("GL_LINE_STRIP",GL_LINE_STRIP);
      addConversion("GL_LINE_LOOP",GL_LINE_LOOP);
      addConversion("GL_TRIANGLE_STRIP",GL_TRIANGLE_STRIP);
      addConversion("GL_TRIANGLE_FAN",GL_TRIANGLE_FAN);
      addConversion("GL_QUADS",GL_QUADS);
      addConversion("GL_POLYGON",GL_POLYGON);

      //blend thingies.
      addConversion("GL_ZERO",GL_ZERO);
      addConversion("GL_ONE",GL_ONE);
      addConversion("GL_SRC_COLOR",GL_SRC_COLOR);
      addConversion("GL_ONE_MINUS_SRC_COLOR",GL_ONE_MINUS_SRC_COLOR);
      addConversion("GL_DST_COLOR",GL_DST_COLOR);
      addConversion("GL_SRC_ALPHA",GL_SRC_ALPHA);      
      addConversion("GL_ONE_MINUS_DST_ALPHA",GL_ONE_MINUS_DST_ALPHA);
      addConversion("GL_DST_ALPHA",GL_DST_ALPHA);
      addConversion("GL_ONE_MINUS_DST_ALPHA",GL_ONE_MINUS_DST_ALPHA);
      addConversion("GL_SRC_ALPHA_SATURATE",GL_SRC_ALPHA_SATURATE);      
      addConversion("GL_CONSTANT_COLOR",GL_CONSTANT_COLOR);
      addConversion("GL_ONE_MINUS_CONSTANT_COLOR",GL_ONE_MINUS_CONSTANT_COLOR);
      addConversion("GL_CONSTANT_ALPHA",GL_CONSTANT_ALPHA);
      addConversion("GL_ONE_MINUS_CONSTANT_ALPHA",GL_ONE_MINUS_CONSTANT_ALPHA);

      addConversion("GL_TRUE",GL_TRUE);
      addConversion("GL_FALSE",GL_FALSE);


    }
  void addConversion(const std::string &name,GLint glValue)
  {
    convMap[name]=glValue;
    convMapRev[glValue]=name;
  }
};

  extern  cGlHelpConverterMachine convertMachine;


   GLint glEnumLookup(const std::string &name);
   std::string glEnumLookup(GLint enumVal);

}

#endif
