comment +
 Pixel Tunnel  for "Forever Reality"   4k-intro (2023)
 coded by bitl/7dump       (email: aleks_gs@yahoo.com)
 -----------------------------------------------------
 Greetz to:   HellMood,  sensenstahl, rrrola, Optimus,
 TomCatAbaddon, p01,  pestis,  Asato,  iONic,  Manwe,
 superogue, Kuemmel,  Digimind,  wbc\\bz7, LBi, & YOU!

 For compilation use:   Notes:
 Turbo Assembler 2.02   Sizecoding optimization wasn't
 tasm /m2 tunnel.asm    applied here!   You can try to
 tlink /t tunnel.obj    make it smaller ;)
 -----------------------------------------------------
comment end! +

.model tiny
.data
ZigZag       DD 0.4   ; sinuosity force (0..0.6)
Circl        DW 64    ; count layers in tunnel
Dots         DW 64    ; count dots in one circle
Speed_tunnel DW 100
Zcam         DW 0
V8           DW 8
V20          DW 20
V160         DW 160
V100         DW 100
V04          DD 0.4
V035         DD 0.35

.code
.486
org 0100h

start:
mov al, 13h        ; set VGA 320x200x8bpp
int 10h

add dh, al         ; FS=DS+1300h  (for screen buffer)
mov fs, dx

push 0A000h
pop es

xor bx, bx         ; Setup palette
mov ax, 1010h
@pal:
mov dh, bl
mov cl, dh
mov ch, dh
int 10h
inc bl
cmp bl, 64
jb @pal


finit


;**********************************************************************
; MAIN LOOP
;**********************************************************************
@mainloop:

inc word ptr Zcam  ; movement


mov dx, 1
@tunnel_draw: ;for d:=1 to circl do begin}
push dx
fild word ptr v8   ;    4     |           |          |         |       }
fild word ptr circl;  circl   |    4      |          |         |       }
fld1               ;   1      |  circl    |    4     }
fild word ptr [esp];   d      |    1      |  circl   |    4    }

;PZ:= 1 - d / circl;}
fdiv st(0), st(2)  ;  d/circl |    1      |  circl   |    4    }
fsubp st(1), st(0) ;   pz     |  circl    |    4     }
fxch  st(1)        ;  circl   |   pz      |    4     }

;a:=round(Zcam / (4/circl));
;a:=a*(4/circl);
;A:=Zcam - a;}

fdivp st(2), st(0);   pz     |  4/circl  |          |       }
fild word ptr Zcam;  Zcam    |   circl   |   pz     | 4/circl |         |       }
fidiv word ptr speed_tunnel
fld st(0)         ;  Zcam    |   Zcam    |   pz     | 4/circl |         }
fdiv st(0), st(3) ;Zcam/(4/m)|   Zcam    |   pz     | 4/circl |         }
frndint           ;    a     |   Zcam    |   pz     | 4/circl |         }
fmulp st(3), st(0);  Zcam    |    pz     |a*(4/circ)|         |         }
fld st(0)         ;  Zcam    |   Zcam    |   pz     |a*(4/circ|         }
fxch st(3)        ; a*(4/cir)|   Zcam    |   pz     |  Zcam   }
fsubp st(1), st(0);    A     |    pz     |   Zcam   }

;pz:= pz - a;}

fsubp st(1), st(0) ;   pz     |   Zcam    }
fxch st(1)         ;  Zcam    |    pz     }

;---Call center coord of circle----}
;cam_x:=zigzag*sin(2Pi * Zcam * x_const);
;cam_y:=zigzag*cos(2Pi * Zcam * y_const);
;tun_x:=zigzag*sin(2Pi * (Zcam+pz) * x_const);
;tun_y:=zigzag*cos(2Pi * (Zcam+pz) * y_const);}

fadd st(0), st(1) ; Zcam+pz  | pz                                     }
mov cx, 2
@l_path:
fldpi             ; pi       | Zcam      | pz       |                 }
fadd st(0),st(0)  ; 2pi      | Zcam      | pz       |                 }
fmul st(0), st(1) ; 2pi*Zcam | Zcam      | pz       |                 }
FLDLN2            ; x_const  | 2pi*Zcam  |  Zcam    | pz              }
fmul st(0), st(1) ; 2pi*c*x  | 2pi*Zcam  |  Zcam    | pz              }
fsin              ; sin()    | 2pi*Zcam  |  Zcam    | pz              }
FLDLG2            ; y_const  |   sin     | 2pi*Zcam | Zcam    | pz    }
fmulp st(2), st(0);   sin    | 2pi*c*y   | Zcam     | pz      |       }
fxch st(1)        ; 2pi*c*y  |   sin     | Zcam     | pz      |       }
fcos              ;   cos    |   sin     | Zcam     | pz      |       }
fld dword ptr zigzag ;  zigzag  |   cos     | sin      | Zcam    | pz    }
fmul st(1), st(0) ;  zigzag  |  tun_y    | sin      | Zcam    | pz    }
fmulp st(2), st(0);  tun_y   |  tun_x    | Zcam     | pz      |       }
fxch st(2)        ;  Zcam    |  tun_x    | tun_y    | pz      |       }
fsub st(0), st(3) ; Zcam-pz  |  tun_x    | tun_y    | pz      |       }
loop @l_path
fstp st(0)        ; cam_x    |  cam_y    | tun_x    | tun_y   | pz    }

;xx := round((tun_x - cam_x)*160);}
;yy := round((tun_y - cam_y)*100);}

fsubp st(2), st(0); cam_y    |  xx       | tun_y    | pz      |       }
fsubp st(2), st(0); xx       |  yy       | pz       |         |       }

;Diametr
;dd:= pz * 0.8 + 0.4;
;dd:= (dd * dd);
;dd:= 1/dd*0.25;
fld1
fld dword ptr v04   ; 0.4      | 1         | xx       | yy      | pz    }
fld st(0)           ; 0.4      | 0.4       | 1        | xx      | yy    | pz   }
fadd st(0),st(0)    ; 0.8      | 0.4       | 1        | xx      | yy    | pz   }
fmul st(0),st(5)    ; pz*0.8   | 0.4       | 1        | xx      | yy    | pz   }
faddp st(1), st(0)  ;pz*0.8+0.4| 1         | xx       | yy      | pz    }
fmul st(0),st(0)    ; dd*dd    | 1         | xx       | yy      | pz    }
fdivp st(1),st(0)   ; 1/(dd*dd)| xx        | yy       | pz      |       }
fmul dword ptr v035 ;   DD     | xx        | yy       | pz      |       }

;fade:=round((1-pz)*32);}
fld1                ;   1      |  DD       | xx       | yy      | pz    }
fsub st(0), st(4)   ;  1-pz    |  DD       | xx       | yy      | pz    }
fabs
fimul word ptr v20  ;  fade    |  DD       | xx       | yy      | pz    }
fistp word ptr [esp];   DD     |  xx       | yy       | pz      }
pop cx

;col:=(d shr 2 and 1 + 2) * fade;}
mov ax, dx
shr ax, 2
and ax, 1
inc ax
inc ax
mul cl


fldpi
fadd st(0),st(0)
fidiv word ptr dots  ;  2Pi/dots  |   DD     |  xx       | yy       | pz      }
mov cx, dots ;count_dots

@draw_circle: ;for n:=dots downto 1 do begin}
;xc:= sin(2Pi/dots*n)*dd + xx;}
;yc:= cos(2Pi/dots*n)*dd + yy;}
;x:=round(xc*160+160);}
;y:=round(yc*100+100);}

push cx
fild word ptr [esp]  ;   n        |  2Pi/dots   |   DD     |  xx      | yy       | pz      }
fmul st(0), st(1)    ;n*(2Pi/dots)|  2Pi/dots   |   DD     |  xx      | yy       | pz      }
fsincos              ;  cos     |  sin      |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fmul st(0), st(3)    ;  yc      |  sin      |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fadd st(0), st(5)    ;  YC      |  sin      |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fimul word ptr v100
fiadd word ptr v100
fxch st(1)           ;  sin     |  YC       |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fmul st(0), st(3)    ;  xc      |  YC       |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fadd st(0), st(4)    ;  XC      |  YC       |  2Pi/dots  |  DD      | xx       | yy      | pz      }
fimul word ptr v160
fiadd word ptr v160
fistp word ptr [esp]
pop di  ; x
push di
fistp word ptr [esp]
pop bx  ; y

;if (x>0) and (x<319) and (y>0) and (y<199) then mem[vaddr:word(y*320+x)]:=byte(col);}
cmp di, 320
jae @skip_dot
cmp bx, 200
jae @skip_dot
imul bx, bx, 320
mov fs:[di+bx], al

@skip_dot:
loop @draw_circle

fstp st
fstp st
fstp st
fstp st
fstp st

inc dx
cmp dx, circl
jbe @tunnel_draw



mov  dx, 3DAh    ; Wait for vertical retrace
@w1:
in   al, dx
test al, 8
jnz  @w1
@w2:
in   al, dx
test al, 8
jz   @w2


mov cx, 16000    ; copy buffer on screen and clear buffer
xor di, di
xor si, si
xor eax, eax
@l:
db 64h
movsd
mov fs:[si-4], eax
loop @l


in al, 60h       ; wait for ESC
dec ax
jnz @mainloop    ; none received, start over


;**********************************************************************
; EXIT
;**********************************************************************
mov ax, 3        ; back to text
int 10h          ; mode
int 20h          ; exit

end start
