// top.cpp : Defines the entry point for the console application.
//


#include "stdafx.h"
#include <windows.h>
#include <stdio.h>



struct CallbackArgs
{
    char* pcName;
    HWND  hwnd;
};

BOOL CALLBACK EnumWindowsCB(HWND hwnd, LPARAM lParam)
{
    CallbackArgs* pArgs = (CallbackArgs*) lParam;

    #define MAX_CHARS 256
    char  pcWindowText[MAX_CHARS];
    GetWindowText(hwnd, pcWindowText, MAX_CHARS-1);

    strupr(pcWindowText);

    if (strcmp(pcWindowText, pArgs->pcName) == 0)
    {
        pArgs->hwnd = hwnd;
        return FALSE;
    }


    return TRUE;
}


int main(int argc, char* argv[])
{
    if (argc <= 1)
    {
        printf("Usage: %s windowtitle [notop]\n", argv[0]);
        return 0;
    }


    strupr(argv[1]);

    CallbackArgs args;

    args.hwnd   = 0;
    args.pcName = argv[1];
    if (FAILED(EnumWindows(EnumWindowsCB, (long) &args)))
    {
        printf("EnumWindows failed.\n");
        return -1;
    }

    if (args.hwnd)
    {
        if (argc > 2)
        {
            SetWindowPos(args.hwnd, HWND_NOTOPMOST, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
        }
        else
        {
            SetWindowPos(args.hwnd, HWND_TOPMOST, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
        }

        
    }
    else
    {
        printf("Window with title %s not found\n", argv[1]);
    }

	return 0;
}



