#include "DemoIDEPch.h"
#include "PreviewWindow.h"
#include "SM_D3d.h"
#include "SM_Main.h"



int PreviewWindow::Init(Window* pParent)
{
  
  if (Window::InitPrivate("Preview", 0, WS_CHILDWINDOW, pParent) == -1)
  {
    return -1;
  }

  SetSize(640, 480);

  m_bIsOK = true;

  Show();    

  return 0;
}

int PreviewWindow::ProcessMessage(const UINT message, const WPARAM wParam, const LPARAM lParam)
{
  switch (message)
  {
  case WM_PAINT:         
    {
    PreviewPaintEvent Event;
    PostEvent(&Event);
    break;
    }
  case WM_SIZE:
    {
      InvalidateRect(m_hwnd, 0, FALSE);
    }
    break;
  case WM_MOUSEMOVE:
    {
      int x = LOWORD(lParam);
      int y = HIWORD(lParam);

      int w,h;
      GetClientSize(&w, &h);      

      CoordEvent Event(int((float(x)/w)*640.0f), int((float(y)/h)*480.0f));
      PostEvent(&Event);      
    }
  case WM_ERASEBKGND :      
    return 0;
  }

  return Window::ProcessMessage(message, wParam, lParam);
}

